/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: mas_data.c,v 1.3 2003/06/26 20:50:13 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#include <string.h>
#include "mas/mas_common.h"

#define MAS_MIN_SEGMENT 3072 /* that's 50% more than 2048! */

/***********************************************************************
 * mas_data make/destroy routines.
 ***********************************************************************/

/***************************************************************************
 * masc_setup_data
 *
 * arguments:
 *  1. pointer to struct mas_data.
 *  2. allocation size
 *
 *  Allocates space for the segment internals of a mas_data structure.
 *  Also allocates space for the segment, if "size" is nonzero.
 *  Payloads of mas_data are assumed to be dynamically allocated.  If
 *  masc_setup_data isn't used to allocate the segment, the caller is
 *  responsible for setting length and allocated_length.
 *
 * returns: error
 *
 ***************************************************************************/
int32
masc_setup_data( struct mas_data* data, int size )
{
    if ( data == NULL )
	return mas_error(MERR_NULLPTR);

    memset( data, 0, sizeof *data );
    
    if (size > 0)
    {
	data->allocated_length       = max( MAS_MIN_SEGMENT, size );
	data->length                 = 0;
	
	if ( ( data->segment = masc_rtalloc(data->allocated_length) ) == 0)
	    return mas_error(MERR_MEMORY);
    }

    return 0;
}
int32
masc_strike_data( struct mas_data* data )
{
    if (data == NULL)
        return mas_error(MERR_NULLPTR);
    
    if ( ( data->segment != NULL ) && ( data->allocated_length > 0) )
        masc_rtfree(data->segment);

    data->segment = NULL;
    
    return 0;
}
