/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/* HACKED UP VERSION -- adapted from the ppm gui */
/* a widget to draw a ruler next to a GtkVScale widget on mixer channels */

#ifndef __PPMSCALE_H__
#define __PPMSCALE_H__

    
#include <gtk/gtk.h>

#define REG_FONT "-adobe-helvetica-medium-r-*-*-8-*-*-*-*-*-iso8859-*"


#ifdef __cplusplus
extern "C" {
#endif
    
extern guint gtk_ppmscale_get_type();

#define GTK_TYPE_PPMSCALE		(gtk_ppmscale_get_type ())
#define GTK_PPMSCALE(obj)		(GTK_CHECK_CAST ((obj), GTK_TYPE_PPMSCALE, GtkPpmscale))
#define GTK_PPMSCALE_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_PPMSCALE, GtkPpmscaleClass))
#define GTK_IS_PPMSCALE(obj)		(GTK_CHECK_TYPE ((obj), GTK_TYPE_PPMSCALE))
#define GTK_IS_PPMSCALE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_PPMSCALE))


typedef struct _GtkPpmscale       GtkPpmscale;
typedef struct _GtkPpmscaleClass  GtkPpmscaleClass;

struct _GtkPpmscale
{
    GtkDrawingArea darea;
    gboolean ismono;
    gboolean leave_colors_hack;
    int db_cutoff;
};
    
enum gtk_ppmscale_options
{
  GTK_PPMSCALE_MONO = 1,
  GTK_PPMSCALE_STEREO = 2
};


struct _GtkPpmscaleClass
{
    GtkDrawingAreaClass parent_class;
};

GtkWidget* gtk_ppmscale_new(int db_cutoff, int opts);
void gtk_ppmscale_set_db_cutoff(GtkWidget* w, int new_cutoff);


#ifdef __cplusplus
}
#endif
/* __PPMSCALE_H__ */
#endif
