/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _WORLD_H_
#define _WORLD_H_

int register_world();
void load_shared_objects();
void unload_shared_objects();

void register_sectors(int number);
void register_portals(int number);
void register_portals_indices(int sector_indice);
void register_triangles(int sector_indice);
void register_bonus(int sector_indice);
void load_world_textures();
void load_bonus();

void init_characters();
void reset_player_pos();

void cleanup_bonus();

int count_teleports();
void register_teleports();
void cleanup_teleports();
void load_teleports_geometry();

void cleanup_winning_post();
void register_winning_post();
void load_winning_post_geometry();

#endif
