/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _MANGO_H
#define _MANGO_H

#ifdef WIN32
#   define SHXMAN_DATA "game_data/"
#   define VERSION "0.6.2+"
#endif

// this is just a number I bump when a change in the save code makes
// the old maps no longer loadable.
// The number itself has no importance.
#define COMPAT_NUMBER 2

#define  pi_sur_180 0.0174532925 // un deg = 0.0174 rad
#define  _180_sur_pi 57.29577951 // un rad = 57 deg

#define SHX_GAUCHE 2
#define SHX_DROITE 3
#define SHX_HAUT 4
#define SHX_BAS 5
#define SHX_CENTRE 6

#define SHX_LATERAL 10

#define VITESSE_ROTAT_MARCHE 0.1
#define VITESSE_ROTAT_COURSE 0.007

#define VITESSE_TRANS_MARCHE 0.006
#define VITESSE_TRANS_COURSE 0.01

#define KEY_UP 0
#define KEY_DOWN 1
#define KEY_LEFT 2
#define KEY_RIGHT 3

#define AU_SOL 0
#define AU_PLAFOND 1

#define DIST_MAXI 0.9

#define STATUS_DEAD 3
#define STATUS_WIN 4
#define STATUS_WAITING 5
#define STATUS_PAUSE 10
#define STATUS_INGAME_MENU 11
#define GAME_OVER 20

#ifndef SDL_DISABLE
#define SDL_DISABLE 0
#endif

struct SQUARE
{
  int tex_sol;
  int tex_pla;
  int tex_mur;

  int bonus;	
  int paramBonus;

  int special;
  int paramSpecial;

  char is_ditugomme;
};

struct special_texture_t
{
  int square;
  double pos_x, pos_z;
  GLfloat coordTriangles[4][2]; //4 vertices, and we don't need Y coord

  GLint list;
  GLuint texture;
};

struct special_3d_object_t
{
  GLfloat x, y, z, rotat_z,updown;
  GLint list;
  GLuint texture;
  char go_up;
};

struct game_data_t 
{
  int videoFlags;
  int videoFlags_fs;

  char need_to_restart_map;
  int time_limit;
  int num_lives_beginning;
  int size;
  int size_square;
  int country;
  int start_square;

  int finish_square;
  special_texture_t winning_post;
  special_3d_object_t winning_post_object;

  double warning_radius;

  CHRONOMETRE *game_timer;
  SYNCHRONIZER *game_sync;
  char game_paused;
  char in_ingame_menu;
  int gameEnd;

  SQUARE *map;
  int num_dituboites;

  int num_sectors;
  sector_t *sectors;

  int total_num_portals;
  portal_t *portals;

  int num_huts;
  int num_shmolluxes;
  int *hut_squares;
  hut_t *huts;

  int num_teleports;
  special_texture_t *teleports;

  int current_bonus;
  BONUS **tab_bonus;
  DITUBOITE *dituboite;
  B_SHMIXGOMME *b_shmixgomme;
  B_STOPTEMPS *b_stoptemps;

  GLuint base_tex[36];
  GLfloat mat_amb_diff[4];
  GLfloat bonus_rotat;
  int bonus_up;
  GLfloat bonus_updown;

#ifdef HAVE_SDL_MIXER
  Mix_Chunk **misc_sounds;
#endif

  SDL_Surface *screen;

};

struct player_t
{
  char status;
  int theKeys[4];
  int num_lives;
  int square;
  int run;
  int slide;

  int score;
  int stockBonus[4];
  int paramStocks[4];
  char highlander;

  char sees_minimap;

  int elevation;
  VECTEUR2D u;
  GLfloat rotat_speed[2];
  GLfloat trans_speed[2];
  GLfloat pos_x, pos_y[2], pos_z;
  int map_x, map_z;
  GLfloat x_rot;
  GLfloat y_rot;

  sector_t *mySector;

  int teleporting;

  int selected_stocked_bonus;
};

struct options_t
{
  int  proximity_setting;

  int fullscreen;

  int mouse_smooth;
  int mouse_sens_pre; // pre-smooth sensivity
  int mouse_sens_post; // post-smooth sensivity
  int is_mouse_y;

  int use_sound;
  int sound_volume;
  int music_volume;

  int alternate_controls;
};

struct map_names_t
{
  int num_builtins;
  int num_customs;

  char **builtins;
  char **customs;
};

enum
{
  // bonus
  E_SHMIXGOMME,
  E_VIE,
  E_BOUCLIER,
  E_ARMAGGEDON,
  E_ONDEDECHOC,  //pas pour le hasard  
  E_STOPTEMPS,
  
  E_ULTRAPOINTS,
  E_GLACON,
  E_RAPIDE,
  E_COUPDEBOL,   //pas pour le hasard
  
  // malus : > 10
  E_NUIT,
  E_PERDBONUS,
  E_INVERTTOUCHES,
  E_PLAFOND,
  E_FOG,
  E_MALUSMAP,
  E_ANTIBOITES,
  E_FREEZESHX,
  E_LENT,

  // misc
  E_HASARD,

  NUM_BONUS,
  
  E_DITUBOITE,
  E_RIEN
};

enum {
  SHMIXMAN_G,
  SHMIXMAN_D,
  SHMIXMAN_H,
  SHMIXMAN_B,

  FOYER,

  TEL_D1,
  TEL_D2,
  TEL_D3,
  TEL_D4,
  TEL_D5,

  TEL_A1,
  TEL_A2,
  TEL_A3,
  TEL_A4,
  TEL_A5,

  LIMITE_TEMPS,
  VIES,
  FINISH_POS,

  NUM_SPECIAL
};

void build_special_texture(special_texture_t *teleport, int type);

#endif
