/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "file_utils.h"
#include "map_seeking.h"
#include "menus.h"
#include "sounds.h"

#define MAIN_CAMPAIGN_ 0
#define MAIN_SKIRMISH_ 1
#define MAIN_OPTIONS_ 2
#define MAIN_CREDITS_ 3
#define MAIN_QUIT_ 4

#define MAIN_ARROW_CAMPAIGN_X 85
#define MAIN_ARROW_CAMPAIGN_Y 163
#define MAIN_ARROW_SK_X 85
#define MAIN_ARROW_SK_Y 239
#define MAIN_ARROW_OPTIONS_X 85
#define MAIN_ARROW_OPTIONS_Y 323
#define MAIN_ARROW_CREDITS_X 85
#define MAIN_ARROW_CREDITS_Y 401
#define MAIN_ARROW_QUIT_X 85
#define MAIN_ARROW_QUIT_Y 481

#define MAIN_CAMPAIGN_X1 160
#define MAIN_CAMPAIGN_X2 648
#define MAIN_CAMPAIGN_Y1 152
#define MAIN_CAMPAIGN_Y2 216

#define MAIN_SK_X1 160
#define MAIN_SK_X2 608
#define MAIN_SK_Y1 232
#define MAIN_SK_Y2 288

#define MAIN_OPTIONS_X1 160
#define MAIN_OPTIONS_X2 400
#define MAIN_OPTIONS_Y1 320
#define MAIN_OPTIONS_Y2 368

#define MAIN_CREDITS_X1 160
#define MAIN_CREDITS_X2 372
#define MAIN_CREDITS_Y1 395
#define MAIN_CREDITS_Y2 450

#define MAIN_QUIT_X1 160
#define MAIN_QUIT_X2 288
#define MAIN_QUIT_Y1 475
#define MAIN_QUIT_Y2 530

extern player_t *player;
extern game_data_t *world;
extern map_names_t *map_names;
extern char *filename;

main_menu_t *main_menu;
menu_common_t *menu_shared;

const char *cursor_name = SHXMAN_DATA "menus/cursor.png";
const char *cursor_mask_name = SHXMAN_DATA "menus/cursor_m.png";

int selected_submenu;
int old_selected_submenu=-1;

const char *main_menu_tex_names[N_MAIN_MENU_TEX] =
  {
    SHXMAN_DATA "menus/main/main_0.png",
    SHXMAN_DATA "menus/main/main_1.png",
    SHXMAN_DATA "menus/main/main_2.png",
    SHXMAN_DATA "menus/main/main_3.png"
  };

const char *main_menu_dyn_tex_names[N_MAIN_MENU_DYN_TEX] =
  {
    SHXMAN_DATA "menus/main/arrow.png",
    SHXMAN_DATA "menus/main/arrow_m.png"
  };

void load_menu_main()
{
  int i=0;
  main_menu = new main_menu_t;
  menu_shared = new menu_common_t;

  SDL_Surface *images_main[N_MAIN_MENU_TEX];
  SDL_Surface *images_main_dyn[N_MAIN_MENU_DYN_TEX];

  load_menu_sounds();

  LoadTexture(cursor_name, &menu_shared->t_cursor); 
  LoadTexture(cursor_mask_name, &menu_shared->t_cursor_mask); 
  if (!(menu_shared->tgaFont.Load(SHXMAN_DATA "fonts/font_2.tga")))
    {
      fprintf(stderr, "Error loading font : fonts/font_2.tga");
    }

  glGenTextures(N_MAIN_MENU_TEX, main_menu->tex_menu);
  for (i=0; i<N_MAIN_MENU_TEX; i++)
    {
      images_main[i] = ImageLoad(main_menu_tex_names[i]);

      glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
      glBindTexture(GL_TEXTURE_2D, main_menu->tex_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_main[i]->w, images_main[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_main[i]->pixels);

      SDL_FreeSurface(images_main[i]);
    }

  glGenTextures(N_MAIN_MENU_DYN_TEX, main_menu->tex_dyn_menu);
  for (i=0; i<N_MAIN_MENU_DYN_TEX; i++)
    {
      images_main_dyn[i] = ImageLoad(main_menu_dyn_tex_names[i]);
      
      glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
      glBindTexture(GL_TEXTURE_2D, main_menu->tex_dyn_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_main_dyn[i]->w, images_main_dyn[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_main_dyn[i]->pixels);

      SDL_FreeSurface(images_main_dyn[i]);
    }

  main_menu->mat_amb_diff[0] = 0.937;
  main_menu->mat_amb_diff[1]= 0.937;
  main_menu->mat_amb_diff[2] = 0.937;
  main_menu->mat_amb_diff[3] = 1.0;
}

void cleanup_menu_main()
{
  glDeleteTextures(N_MAIN_MENU_TEX,main_menu->tex_menu);
  glDeleteTextures(N_MAIN_MENU_DYN_TEX,main_menu->tex_dyn_menu);

  cleanup_menu_sounds();

  delete main_menu;
}

void draw_main_menu_static()
{
  GLfloat x = 0, y=600; int i=0;
  glPushMatrix();
  
  for (i=0; i < N_MAIN_MENU_TEX; i++)
    {
      if (i == 2) x+=400;
      if (i==0 || i== 2) y=600; else y=300;

      glBindTexture(GL_TEXTURE_2D,main_menu->tex_menu[i]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-300);
      glTexCoord2f(1, 0);
      glVertex2f(x+400,y-300);
      glTexCoord2f(1, 1);
      glVertex2f(x+400, y);

      glEnd();
    }
}

void draw_cursor()
{
   glPushMatrix();
    
   glEnable(GL_BLEND);
   glDisable(GL_DEPTH_TEST);
   glBlendFunc(GL_DST_COLOR, GL_ZERO);

   glBindTexture(GL_TEXTURE_2D, menu_shared->t_cursor_mask);
   glBegin(GL_QUADS);

   glTexCoord2f(0, 1);
   glVertex2f(menu_shared->mouse_x, 600-menu_shared->mouse_y);
   glTexCoord2f(0, 0);
   glVertex2f(menu_shared->mouse_x, 600-(menu_shared->mouse_y+32));
   glTexCoord2f(1, 0);
   glVertex2f(menu_shared->mouse_x+32, 600-(menu_shared->mouse_y+32));
   glTexCoord2f(1, 1);
   glVertex2f(menu_shared->mouse_x+32, 600-menu_shared->mouse_y);
   
   glEnd();

   glBlendFunc(GL_ONE, GL_ONE);
   
   glBindTexture(GL_TEXTURE_2D, menu_shared->t_cursor);
   glBegin(GL_QUADS);
   
   glTexCoord2f(0, 1);
   glVertex2f(menu_shared->mouse_x, 600-menu_shared->mouse_y);
   glTexCoord2f(0, 0);
   glVertex2f(menu_shared->mouse_x, 600-(menu_shared->mouse_y+32));
   glTexCoord2f(1, 0);
   glVertex2f(menu_shared->mouse_x+32, 600-(menu_shared->mouse_y+32));
   glTexCoord2f(1, 1);
   glVertex2f(menu_shared->mouse_x+32, 600-menu_shared->mouse_y);
   
   glEnd();
   
   //glEnable(GL_DEPTH_TEST);
   glDisable(GL_BLEND);
   glPopMatrix();
}

void draw_main_menu_big_arrow()
{
  GLfloat x=0, y=0;
  switch (selected_submenu)
    {
    case MAIN_CAMPAIGN_:
      x=MAIN_ARROW_CAMPAIGN_X;
      y=MAIN_ARROW_CAMPAIGN_Y;
      break;

    case MAIN_SKIRMISH_:
      x=MAIN_ARROW_SK_X;
      y=MAIN_ARROW_SK_Y;
      break;
      
    case MAIN_OPTIONS_:
      x=MAIN_ARROW_OPTIONS_X;
      y=MAIN_ARROW_OPTIONS_Y;
      break;

    case MAIN_CREDITS_:
      x=MAIN_ARROW_CREDITS_X;
      y=MAIN_ARROW_CREDITS_Y;
      break;

    case MAIN_QUIT_:
      x=MAIN_ARROW_QUIT_X;
      y=MAIN_ARROW_QUIT_Y;
      break;
    }
  glPushMatrix();
  
  glEnable(GL_BLEND);
  glDisable(GL_DEPTH_TEST);
  glBlendFunc(GL_DST_COLOR, GL_ZERO);
  
  glBindTexture(GL_TEXTURE_2D, main_menu->tex_dyn_menu[1]);
  glBegin(GL_QUADS);
   
  glTexCoord2f(0, 1);
  glVertex2f(x, 600-y);
  glTexCoord2f(0, 0);
  glVertex2f(x, 600-(y+64));
  glTexCoord2f(1, 0);
  glVertex2f(x+64, 600-(y+64));
  glTexCoord2f(1, 1);
  glVertex2f(x+64, 600-y);
  
  glEnd();
  
  glBlendFunc(GL_ONE, GL_ONE);
  
  glBindTexture(GL_TEXTURE_2D, main_menu->tex_dyn_menu[0]);
  glBegin(GL_QUADS);
  
  glTexCoord2f(0, 1);
  glVertex2f(x, 600-y);
  glTexCoord2f(0, 0);
  glVertex2f(x, 600-(y+64));
  glTexCoord2f(1, 0);
  glVertex2f(x+64, 600-(y+64));
  glTexCoord2f(1, 1);
  glVertex2f(x+64, 600-y);
  
  glEnd();
  
  glEnd();
  
   //glEnable(GL_DEPTH_TEST);
   glDisable(GL_BLEND);
   glPopMatrix();
}

void draw_main_menu_mouseover()
{
  draw_main_menu_big_arrow();
}

void draw_main_menu()
{
  set_GL_projection (MANGO_2D);
  set_GL_options (MANGO_2D);
  glClear(GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();

  glPushMatrix();
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, main_menu->mat_amb_diff);

  glEnable(GL_TEXTURE_2D);

  /* first we draw static elements of the menu */
  draw_main_menu_static();

  /* draw lighted elements on mouse-over */
  draw_main_menu_mouseover();

  /* then we draw the cursor */
  draw_cursor();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();
  SDL_GL_SwapBuffers();
}

void main_menu_loop()
{
  main_menu->loop_end = 0;
  menu_shared->is_button_down=0;

  while (!(main_menu->loop_end))
  {
    {
      SDL_Event event;
      
      while (SDL_PollEvent(&event))
	{
	  if (event.type == SDL_KEYDOWN)
	    {
	      switch (event.key.keysym.sym)
		{
		case SDLK_ESCAPE:
		  main_menu->loop_end = 1;
		  
		  break;
		  
		default:
		  break;
		}
	    }
	  
	  if (event.type == SDL_KEYDOWN)
	    {
	      
	      switch (event.key.keysym.sym)
		{
		case SDLK_DOWN:
		  menu_shared->lock_mouse=1;
		  old_selected_submenu = selected_submenu;
		  if (selected_submenu < 4) 
		    selected_submenu++;
		  else selected_submenu=0;
		  break;

		case SDLK_UP:
		  menu_shared->lock_mouse=1;
		  old_selected_submenu = selected_submenu;
		  if (selected_submenu > 0) 
		    selected_submenu--;
		  else selected_submenu=4;
		  break;

		case SDLK_RETURN:
		  analyze_main_menu_buttondown(&main_menu->loop_end);
		  break;

		default: break;
		}
	    }

	  if (event.type == SDL_MOUSEMOTION)
	    {
	      menu_shared->lock_mouse=0;
	      old_selected_submenu = selected_submenu;
	    }

	  if (event.type == SDL_MOUSEBUTTONDOWN)
	    {
	      menu_shared->is_button_down=1;
	    }

	  if (event.type == SDL_MOUSEBUTTONUP)
	    {
	      menu_shared->is_button_down=0;
	    }
	}
    }

    SDL_GetMouseState(&menu_shared->mouse_x,&menu_shared->mouse_y);
    if (menu_shared->is_button_down)
      analyze_main_menu_buttondown(&main_menu->loop_end);

    if (menu_shared->lock_mouse == 0)
      analyze_main_menu_hoover();

    draw_main_menu();
  }
}

void analyze_main_menu_hoover()
{
  if ((menu_shared->mouse_x >= MAIN_CAMPAIGN_X1) && (menu_shared->mouse_x < MAIN_CAMPAIGN_X2)
      && (menu_shared->mouse_y >= MAIN_CAMPAIGN_Y1) && (menu_shared->mouse_y < MAIN_CAMPAIGN_Y2))
    {
      old_selected_submenu = selected_submenu;
      selected_submenu = MAIN_CAMPAIGN_;
    }

  else if ((menu_shared->mouse_x >= MAIN_SK_X1) && (menu_shared->mouse_x < MAIN_SK_X2)
      && (menu_shared->mouse_y >= MAIN_SK_Y1) && (menu_shared->mouse_y < MAIN_SK_Y2))
    {
      
      old_selected_submenu = selected_submenu;
      selected_submenu = MAIN_SKIRMISH_;
    }

  else if ((menu_shared->mouse_x >= MAIN_OPTIONS_X1) && (menu_shared->mouse_x < MAIN_OPTIONS_X2)
      && (menu_shared->mouse_y >= MAIN_OPTIONS_Y1) && (menu_shared->mouse_y < MAIN_OPTIONS_Y2))
    {
      old_selected_submenu = selected_submenu;
      selected_submenu = MAIN_OPTIONS_;
    }

  else if ((menu_shared->mouse_x >= MAIN_CREDITS_X1) && (menu_shared->mouse_x < MAIN_CREDITS_X2)
      && (menu_shared->mouse_y >= MAIN_CREDITS_Y1) && (menu_shared->mouse_y < MAIN_CREDITS_Y2))
    {
      old_selected_submenu = selected_submenu;
      selected_submenu = MAIN_CREDITS_;
    }

  else if ((menu_shared->mouse_x >= MAIN_QUIT_X1) && (menu_shared->mouse_x < MAIN_QUIT_X2)
      && (menu_shared->mouse_y >= MAIN_QUIT_Y1) && (menu_shared->mouse_y < MAIN_QUIT_Y2))
    {
      old_selected_submenu = selected_submenu;     
      selected_submenu = MAIN_QUIT_;
    }


//  printf("old:%d, new:%d\n",old_selected_submenu, selected_submenu);

  if ((old_selected_submenu >= 0) && (old_selected_submenu != selected_submenu))
    {
      play_menu_sound(MENU_SOUND_SELECT_SUBMENU);
      old_selected_submenu=selected_submenu;
      //printf("old:%d, new:%d\n",old_selected_submenu, selected_submenu);
    }
}

void analyze_main_menu_buttondown(int *loop_end)
{
  switch (selected_submenu)
    {
    case MAIN_CAMPAIGN_:
      play_menu_sound(MENU_SOUND_OK);
      menu_shared->is_button_down=0;
      campaign_menu_loop();
      break;

    case MAIN_SKIRMISH_:
      play_menu_sound(MENU_SOUND_OK);
      menu_shared->is_button_down=0;
      skirmish_menu_loop();
      break;
      
    case MAIN_OPTIONS_:
      play_menu_sound(MENU_SOUND_OK);
      menu_shared->is_button_down=0;
      options_menu_loop(0);
      break;

    case MAIN_CREDITS_:
      play_menu_sound(MENU_SOUND_OK);
      menu_shared->is_button_down=0;
      credits_menu_loop();
      break;

    case MAIN_QUIT_: 
      play_menu_sound(MENU_SOUND_OK);
      menu_shared->is_button_down=0;
      *loop_end=1;
      break;

    default: break;
    }
}
