/*  The Blue Mango Quest
 *  Copyright (c) Clment 'phneutre' Bourdarias (code)
 *                   email: phneutre@users.sourceforge.net
 *                Guillaume 'GuBuG' Burlet (graphics)
 *                   email: gubug@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>

#ifdef HAVE_SDL_MIXER
# include <SDL/SDL_mixer.h>
#endif

#include <math.h>
#include <string.h>

#include "font.h"

#include "timers.h"
#include "world_geometry.h"
#include "hut.h"
#include "bonus.h"
#include "mango.h"
#include "world_building.h"
#include "texture.h"
#include "sector.h"
#include "map.h"
#include "system_gl.h"
#include "draw_scene_gl.h"
#include "hud.h"
#include "file_utils.h"
#include "map_seeking.h"
#include "menus.h"
#include "sounds.h"


extern player_t *player;
extern game_data_t *world;
extern map_names_t *map_names;
extern char *filename;

extern GLuint t_cursor, t_cursor_mask;
campaign_menu_t *campaign_menu;
extern menu_common_t *menu_shared;

const char *campaign_menu_tex_names[N_CAMPAIGN_MENU_TEX] =
  {
    SHXMAN_DATA "menus/campaign/campaign_0.png",
    SHXMAN_DATA "menus/campaign/campaign_1.png",
    SHXMAN_DATA "menus/campaign/campaign_2.png",
    SHXMAN_DATA "menus/campaign/campaign_3.png"
  };

void load_menu_campaign()
{
  int i=0;
  campaign_menu = new campaign_menu_t;
  SDL_Surface *images_campaign[N_CAMPAIGN_MENU_TEX];

  glGenTextures(N_CAMPAIGN_MENU_TEX, campaign_menu->tex_menu);
  for (i=0; i<N_CAMPAIGN_MENU_TEX; i++)
    {
      images_campaign[i] = ImageLoad(campaign_menu_tex_names[i]);
      
      glBindTexture(GL_TEXTURE_2D, campaign_menu->tex_menu[i]);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		      GL_NEAREST);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
      glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
      
      glTexImage2D(GL_TEXTURE_2D, 0,3, images_campaign[i]->w, images_campaign[i]->h,0,
                      GL_RGB, GL_UNSIGNED_BYTE, images_campaign[i]->pixels);

      SDL_FreeSurface(images_campaign[i]);
    }

  campaign_menu->mat_amb_diff[0] = 0.937;
  campaign_menu->mat_amb_diff[1]= 0.937;
  campaign_menu->mat_amb_diff[2] = 0.937;
  campaign_menu->mat_amb_diff[3] = 1.0;
}

void cleanup_menu_campaign()
{
  glDeleteTextures(N_CAMPAIGN_MENU_TEX,campaign_menu->tex_menu);
  delete campaign_menu;
}

void draw_campaign_menu_static()
{
  GLfloat x = 0, y=600; int i=0;
  glPushMatrix();

  for (i=0; i < N_CAMPAIGN_MENU_TEX; i++)
    {
      if (i == 2) x+=400;
      if (i==0 || i== 2) y=600; else y=300;

      glBindTexture(GL_TEXTURE_2D,campaign_menu->tex_menu[i]);
      glBegin(GL_QUADS);

      glTexCoord2f(0, 1);
      glVertex2f(x, y);
      glTexCoord2f(0, 0);
      glVertex2f(x, y-300);
      glTexCoord2f(1, 0);
      glVertex2f(x+400,y-300);
      glTexCoord2f(1, 1);
      glVertex2f(x+400, y);

      glEnd();
    }
}

void draw_campaign_menu()
{
  set_GL_projection (MANGO_2D);
  set_GL_options (MANGO_2D);

  glClear(GL_COLOR_BUFFER_BIT);// | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();

  glPushMatrix();
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, campaign_menu->mat_amb_diff);

  glEnable(GL_TEXTURE_2D);

  /* first we draw static elements of the menu */
  draw_campaign_menu_static();

  /* then we draw the cursor */
  draw_cursor();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();
  SDL_GL_SwapBuffers();
}

void campaign_menu_loop()
{
  int loop_end = 0;

  while (!(loop_end))
  {
    {
      SDL_Event event;
      
      while (SDL_PollEvent(&event))
	{
	  if (event.type == SDL_KEYDOWN)
	    {
	      switch (event.key.keysym.sym)
		{
		case SDLK_ESCAPE:
		  loop_end = 1;
		  break;
		  
		default:
		  break;
		}
	    }
	  
	  if (event.type == SDL_MOUSEBUTTONDOWN)
	    {
	      menu_shared->is_button_down=1;
	      loop_end = 1;menu_shared->is_button_down=0;
	    }

	  if (event.type == SDL_MOUSEBUTTONUP)
	    {
	      menu_shared->is_button_down=0;
	    }
	}
    }
    SDL_GetMouseState(&menu_shared->mouse_x,&menu_shared->mouse_y);
   
    draw_campaign_menu();
  }
}
