/* mailfilter.hh - source file for the mailfilter program
 * Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef MAILFILTER_HH
#define MAILFILTER_HH

// Constants
#define CMD_LENGTH                     128

// Preferences
#define ALLOW_NON_ALPHANUMERIC           1

// General error codes
#define DNS_LOOKUP_FAILURE            -100
#define AUTHENTICATION_FAILURE        -101
#define SOCKET_COMMUNICATION_FAILURE  -102
#define SOCKET_CONNECTION_FAILURE     -103
#define UNKNOWN_COMMUNICATION_FAILURE -104
#define MALFORMED_HEADER_FAILURE      -105
#define NO_REPLY_FAILURE              -106
#define ALARM_FAILURE                 -107
#define SIGNAL_FAILURE                -108

// POP error codes
#define CMD_LIST_FAILED               -201
#define CMD_TOP_FAILED                -202
#define CMD_QUIT_FAILED               -203
#define CMD_STAT_FAILED               -204
#define CMD_DELE_FAILED               -205

// Start up parameters
#define VALUE_HELP                      1
#define VALUE_VERBOSE                   2
#define VALUE_MAILFILTERRC              3
#define VALUE_LOGFILE                   4
#define VALUE_VERSION                   5

#endif
