// Header.cc - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <vector>
#include <string>
#include "Header.hh"

using namespace std;

namespace msg {


  //! Return the description of a single line
  const string& Line::descr(void) {
    return field;
  }


  //! Set the description of a single line
  void Line::setDescr(const string& newDescr) {
    field = newDescr;
  }


  //! Return the content of a single line
  const string& Line::content(void) {
    return contents;
  }


  //! Set the content of a single line
  void Line::setContent(const string& newCont) {
    contents = newCont;
  }


  //! Default constructors, etc. for Header
  Header::Header() {
  }

  
  Header::~Header() {
  }

  
  //! Return the No. of the message
  int Header::number(void) {
    return nr;
  }


  //! Set the No. of the message
  void Header::setNumber(int newNum) {
    nr = newNum;
  } 


  //! Return the size of the message
  int Header::size(void) {
    return bytes;
  }

  
  //! Set the size of the message
  void Header::setSize(int newSize) {
    bytes = newSize;
  } 
  

  //! Return the message lines of the header
  const vector<Line>& Header::lines(void) {
    return content;
  }
  

  //! Adds a line to the list of already stored message lines
  void Header::addLine(const Line& newLine) {
    content.push_back(newLine);
  }


  //! Set the sender of the message
  void Header::setSender(const string& newSender) {
    sndr = newSender;
  } 
  

  //! Return the sender of the message
  const string& Header::sender(void) {
    return sndr;
  }
  

  //! Set the subject of the message
  void Header::setSubject(const string& newSubj) {
    subj = newSubj;
  } 
  

  //! Return the subject of the message
  const string& Header::subject(void) {
    return subj;
  }

  
  //! Set the date of the message
  void Header::setDate(const string& newDate) {
    dat = newDate;
  } 


  //! Return the date of the message
  const string& Header::date(void) {
    return dat;
  }
  

  //! Set the message-ID of the message
  void Header::setMessageID(const string& newID) {
    msgID = newID;
  } 

 
  //! Return the message-ID of the message
  const string& Header::messageID(void) {
    return msgID;
  }

 
  //! Set the normalized subject of the message
  void Header::setNormalSubject(const string& newSubj) {
    nSubject = newSubj;
  } 
  

  //! Return the normalized subject of the message
  const string& Header::normalSubject(void) {
    return nSubject;
  }


}
