// Feedback.cc - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#include <iostream>
#include <string>
#include <fstream>
#include "mailfilter.hh"
#include "Feedback.hh"

using namespace std;

namespace fb {

  Feedback::Feedback(const string& newLogfile, int newLevel) {
    logfile = newLogfile;
    verboseLevel = newLevel;
    logStream.open(logfile.c_str(), ios::app);

    if (!logStream.is_open())
      throw LogfileAccess();
  }
  

  Feedback::~Feedback() {
    logStream.close();
  }
  
  
  // Log actions and error messages, depending on 'minMode' which gives a minimum verbosity level that is required
  // in order for the messages to show up in the log files. For examples all error messages need a minimum verbosity
  // of 1 to show up in the log files and the user's screen. For further information have a look at the Preferences.hh
  // file.
  void Feedback::message(int minMode, const string& newMessage) {
    if (verboseLevel >= minMode) {
      cout << newMessage;
      
      if (logStream.is_open())
	logStream << newMessage;
      else
	throw LogfileAccess();
    }
  }
  
}
