// Account.hh - source file for the mailfilter program
// Copyright (c) 2000 - 2002  Andreas Bauer <baueran@in.tum.de>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

#ifndef ACCOUNT_HH
#define ACCOUNT_HH

#define POP3 0
#define IMAP 1

#include <string>
#include <vector>
#include "Header.hh"
#include "Feedback.hh"
#include "Connection.hh"
#include "SocketConnection.hh"

using namespace std;

namespace acc {

  class Account {
  public:
    fb::Feedback* report;
    string server;
    int port;
    string user;
    string pass;
    int protocol;
    vector<string> msgIDs;

    // Add more defines for other kinds of connection interfaces, for example:
    //   #ifdef _WIN32
    //      conn::WinSockConnection host;
    //   #endif
    // You get the idea...
#ifndef _WIN32
    conn::SocketConnection host;
#else
    conn::WinSockConnection host;
#endif
    
    virtual int loginHost(void) = 0;                                 // Returns error code why login failed, or 0 on success
    virtual bool logoutHost(void) = 0;                               // Returns FALSE if logout fails
    virtual int removeMessage(int) = 0;                              // Delete a message on the e-mail server

    // Networking functions/wrappers
    int sendHost(const string&);
    string receiveHost(const bool);
    int connectHost(const string&, int, int);
    int disconnectHost(void);

  public:
    Account(fb::Feedback*);
    virtual ~Account() = 0;
    virtual int check(void) = 0;
    const vector<string>& getMessageIDs(void);                       // Get all message IDs of already parsed message headers
    void addMessageIDs(const vector<string>&);                       // Add IDs to the pile of already parsed message headers
  };

}

#endif
