/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file BothValuePlotMethodAttributes.cc
    \brief Implemtation of BothValuePlotMethod Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Wed May  5 10:05:13 2010
*/    

#include "BothValuePlotMethodAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "Translator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


BothValuePlotMethodAttributes::BothValuePlotMethodAttributes():
	markerHeight_(ParameterManager::getDouble("contour_grid_value_marker_height")),
	markerColour_(Translator<string, Colour>().magics("contour_grid_value_marker_colour")),
	markerQuality_(ParameterManager::getString("contour_grid_value_marker_qual")),
	markerIndex_(ParameterManager::getInt("contour_grid_value_marker_index"))
{
} 



BothValuePlotMethodAttributes::~BothValuePlotMethodAttributes()
{
}

    
void BothValuePlotMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(3);
	prefix[0] = "contour_grid_value";
	prefix[1] = "contour_grid_value";
	prefix[2] = "contour";

	setAttribute(prefix, "contour_grid_value_marker_height", markerHeight_, params);
	setAttribute(prefix, "contour_grid_value_marker_colour", markerColour_, params);
	setAttribute(prefix, "contour_grid_value_marker_qual", markerQuality_, params);
	setAttribute(prefix, "contour_grid_value_marker_index", markerIndex_, params);
}

void BothValuePlotMethodAttributes::copy(const BothValuePlotMethodAttributes& other)
{
	markerHeight_ = other.markerHeight_;
	setMarkerColour(other.markerColour_->clone());
	markerQuality_ = other.markerQuality_;
	markerIndex_ = other.markerIndex_;
} 


bool BothValuePlotMethodAttributes::accept(const string& node)
{	
	if ( magCompare(node, "both")  )
		return true;
	return false;
}

void BothValuePlotMethodAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "both") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void BothValuePlotMethodAttributes::print(ostream& out)  const
{
	out << "BothValuePlotMethodAttributes[";
	out << "markerHeight = " << markerHeight_;
	out << ", markerColour = " << *markerColour_;
	out << ", markerQuality = " << markerQuality_;
	out << ", markerIndex = " << markerIndex_;
	out << "]" << "\n";
}


void BothValuePlotMethodAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
	string tab;
	for ( int t = 0; t < tabs; t++) tab = tab + "	";
	
	out << tab << "<" << tag << "\n";
	out << tab << "\tcontour_grid_value_marker_height = \'" << markerHeight_ << "\'\n";
	out << tab << "\tcontour_grid_value_marker_colour = \'" << *markerColour_ << "\'\n";
	out << tab << "\tcontour_grid_value_marker_qual = \'" << markerQuality_ << "\'\n";
	out << tab << "\tcontour_grid_value_marker_index = \'" << markerIndex_ << "\'\n";
	out << tab << ">";


	out << tab << "</" << tag << ">\n";
}

static MagicsParameter<double> contour_grid_value_marker_height("contour_grid_value_marker_height", 0.25, "");
static MagicsParameter<string> contour_grid_value_marker_colour("contour_grid_value_marker_colour", "red", "");
static MagicsParameter<string> contour_grid_value_marker_qual("contour_grid_value_marker_qual", "low", "");
static MagicsParameter<int> contour_grid_value_marker_index("contour_grid_value_marker_index", 3, "");
