/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

// File BasicGraphicsObject.cc
// Magics Team - ECMWF 2004

#include "BasicGraphicsObject.h"
#include "BaseDriver.h"

using namespace magics;

BasicGraphicsObject::BasicGraphicsObject() : 
	parent_(0)
{
}



BasicGraphicsObject::~BasicGraphicsObject() 
{
	
}

void BasicGraphicsObject::print(ostream& out) const
{
	out << "BasicGraphicsObject[";
	out << "]";
}
BasicGraphicsObjectContainer::~BasicGraphicsObjectContainer() 
{
}

void BasicGraphicsObjectContainer::print(ostream& out) const
{
	out << "BasicGraphicsObjectContainer[";
	for (vector<BasicGraphicsObject*>::const_iterator object = objects_.begin(); object!= objects_.end(); ++object) 
		out << **object << endl;
	out << "]";
}


void BasicGraphicsObjectContainer::visit(const BaseDriver& driver) const
{
	for (vector<BasicGraphicsObject*>::const_iterator object = objects_.begin(); object!= objects_.end(); ++object) 
			(*object)->redisplay(driver);
		
}



// Specialisation!
/*
#include <Text.h>
#include <Polyline.h>
#include <BaseDriver.h>
#include <Flag.h>
#include <Arrow.h>

namespace magics
{
template<>
void Text::redisplay(const BaseDriver& driver) const
{
	string text = getText();
	if ( !text.empty() ) {
		NiceText nice;
		MagFont font = font_;
		font.size(getHeight());
		font.colour(colour_);	
    	nice.font(font);
    	nice.text(text);
    	addNiceText(nice);
	}
	const_cast<Text *>(this)->setText("");
	
	driver.redisplay(*this);
}

template<>
void Polyline::redisplay(const BaseDriver& driver) const
{
	if ( box_ == "legend" ) {
		Log::debug() << "Warning---> wrong box!" << endl;
		const_cast<Polyline * >(this)->box_ = "drawing_area";
	}
	driver.redisplay(*this);
}

template <>	
bool Flag::reproject(const Transformation&, GraphicsList& out) const
{
	out.push_back(const_cast<Flag*>(this));

	return true;
}

template <>
bool Arrow::reproject(const Transformation&, GraphicsList& out) const
{

	out.push_back(const_cast<Arrow*>(this));
	
    return true;
}

template <>
bool Polyline::reproject(const Transformation&, GraphicsList& out) const
{
	
	out.push_back(const_cast<Polyline*>(this));
	
    return true;
}
}
*/
