// inc_iostream.h                                 040727/vk

// This is a compatibility header file to select between
// standard templated i/o stream headers (w/o .h extension)
// or old ARM style headers (names with .h extension).
//
// Up to Metview 3.5-export the default was to use ARM style
// headers and macro USE_NEW_IO was needed to use standard
// headers. The default has now been changed to use standard
// headers, and to use ARM headers macro USE_OLD_IOSTREAM
// should be defined.

#ifndef _INC_IOSTREAM_H_
#define _INC_IOSTREAM_H_

#ifdef USE_OLD_IOSTREAM
//-- use old non-templated iostreams

# include <iostream.h>
# include <fstream.h>
# include <strstream.h>
# include <iomanip.h>

 typedef int tOpenMode;

#else
//-- use standard templated streams

# include <iostream>
# include <fstream>
# include <sstream>
# include <strstream>
# include <iomanip>

 using std::istream;
 using std::ostream;
 using std::ifstream;
 using std::ofstream;
 using std::istrstream;
 using std::ostrstream;
 using std::istringstream;
 using std::ostringstream;
 using std::cin;
 using std::cout;
 using std::cerr;
 using std::endl;
 using std::ends;
 using std::flush;
 using std::ios;
 using std::streambuf;
 using std::setfill;
 using std::setw;

// using std:: ;

 typedef ios::openmode tOpenMode;

#endif
// ! USE_NEW_IO


// we need to repeat this from mars.h because fstream
// includes cstdio which redefines these functions and kills the
// support for >2GB files (on some filesystems). We can detect this by
// checking whether fopen() has been undefined.

#if !defined(fopen)
  #ifdef LARGE_FILES_SUPPORT
    #ifdef linux
      #define fopen(a,b)   (FILE*)fopen64(a,b)
    #else
      #define fopen(a,b)   fopen64(a,b)
    #endif
    #define fseek(a,b,c) fseeko64(a,b,c)
    #define ftell(a)     ftello64(a)
    #define fsetpos(a,b) fsetpos64(a,b,c)
    #define fgetpos(a,b) fgetpos64(a,b)
    #define lseek(a,b,c) lseek64(a,b,c)
    #define lstat(a,b)   lstat64(a,b)
    #define fstat(a,b)   fstat64(a,b)
    #define stat         stat64
  #endif
#endif

// end of repeat from mars.h



#endif
// _INC_IOSTREAM_H_
