/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file AxisMethod.cc
    \brief Implementation of the Template class AxisMethod.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/



#include "AxisMethod.h"

using namespace magics;

AxisMethod::AxisMethod() 
{
}


AxisMethod::~AxisMethod() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AxisMethod::print(ostream& out)  const
{
	out << "AxisMethod[";
	out << "]";
}

void LogarithmicAxisMethod::prepare(double min, double max,  AxisItems& items) const
{
	
	
	
	vector<double> steps;
	vector<double> ticks;
	
	ticks.push_back(5);
	ticks.push_back(2);
	ticks.push_back(1);
	
	
	double wmax = std::max(min, max);
	double wmin = std::min(min, max);
	
     double log = int(log10(wmax));
	
	
	 while (log >= 0) {   
	        double factor = pow(10, log);     
	        
	        for (vector<double>::iterator n = ticks.begin(); n != ticks.end(); ++n) {
	            steps.push_back(factor*(*n));
	        }
	        log--;
	    }
	

	
	for ( vector<double>::const_iterator step = steps.begin(); step != steps.end(); ++step) {
		if (wmin <= *step && *step <= wmax) {
			items.push_back(new AxisItem(*step));
		}	
	}
}

void AxisMethod::prepare(double min, double max, AxisItems& items) const
{
	double inc;
	int nb = 7;
	double step;
	double log, ws;

	double wmax = std::max(min, max);
	double wmin = std::min(min, max);
	
	if (interval_ == int_MAX ) {
	
		while (nb < 20) {
			step = (wmax-wmin)/nb;
			log = log10(step);
			ws = pow(10., int(log));
			inc = ceil(step/ws)*ws;
			Log::dev() << "Automatic method ---> increment = " << inc << " ---> try base=" << inc/ws << endl;
			
			 if ( wmax-wmin/inc > 5 && (inc/ws == 1 || inc/ws == 2 || inc/ws == 3 || inc/ws == 5 || inc/ws == 10) ) {
				Log::dev() << "Automatic method ---> increment " << inc << " OK! " << endl;
				break;
			}
			nb++;
			
		}
	}
	
	else {
		inc = interval_;
	}
	std::set<double> list;
	//list.insert(value(min));
	//ist.insert(value(max));
	
	
    if ( min < max ) {
		double first = floor(min/inc) *inc;
		double last  = 0.;    
		for (double val = first;  val <= max; val+=inc) {
			if (val >= min && val <=max) {
				list.insert(value(val));
        		last = val;
			}
		}
		list.insert(value(last+inc));
		
	}
	else {
		double first = floor(min/inc) *inc;    
		double last  = 0.;  
		for (double val = first;  val >= max; val-=inc) {
			if (val >= wmin && val <= wmax) {
				list.insert(value(val));       		
        		last = val;
			}
		}
		list.insert(value(last-inc));
	}
    
    for (std::set<double>::iterator i = list.begin(); i != list.end(); ++i)
    	addItem(items,*i);
}

void AxisMethod::updateX(const Transformation& transformation)
{
	double min = transformation.getMinX();
	double max = transformation.getMaxX();
	setMin(min);
	setMax(max);
}

void AxisMethod::updateY(const Transformation& transformation)
{
	double min = transformation.getMinY();
	double max = transformation.getMaxY();
	setMin(min);
	setMax(max);
}
