/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQSymbol.h
    \brief Definition of MgQSymbol
    \author Graphics Section, ECMWF

    Started: Feb 2010
*/

#include "MgQSymbol.h"

//====================================
//
//  Item
//
//====================================

bool MgQSymbolItem::equal(const QString& id,const float size)
{
	return id == id_ && size == size_;
} 

//====================================
//
//  Manager
//
//====================================

MgQSymbolManager::~MgQSymbolManager()
{	
	foreach(MgQSymbolItem *item, symbols_)
	{		
		delete item;
	}
}

MgQSymbolItem* MgQSymbolManager::getSymbol(const QString& id,const float size)
{	
	foreach(MgQSymbolItem *item, symbols_) 
	{
		if( item->equal(id,size) == true)
		{
			return item;
		}
	}
	
	return 0;		
}


MgQSymbolItem* MgQSymbolManager::addSymbol(const QString& id,const float size)
{
	MgQSymbolItem *sym = getSymbol(id,size);
	
	if(sym) 
	{
		return sym;
	}
	else
	{	
		sym=new MgQSymbolItem(id,size);
		symbols_.push_back(sym);
	}
	
	return sym;
}

void MgQSymbolManager::deleteSymbol(const QString& id,const float size)	
{	
	foreach(MgQSymbolItem *item, symbols_)
	{
		if( item->equal(id,size) == true)
		{
			delete item;
			return;
		}	
	}
}	