/******************************** LICENSE ********************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 ******************************** LICENSE ********************************/

/*!
    \file MgQLayerNode.h
    \brief Definition of MgQLayerNode.
    \author Graphics Section, ECMWF

    Started: February 2010
*/

#ifndef _MgQLayerNode_H
#define _MgQLayerNode_H

#include <Layer.h>
#include "MgQBaseNode.h"

using magics::Layer;
	
class QGraphicsScene;
class QImage;
class QPainter;

class MgQLayoutNode;

class MgQLayerNode : public MgQBaseNode
{
public:
	MgQLayerNode(QString,const Layer &,MgQLayoutNode *);
	~MgQLayerNode() {};
	
	const Layer& layer() {return layer_;};
	void  setLayerAlpha(float);
	void  setLayerVisibility(bool);	
	float layerAlpha() const; 
	bool  layerVisibility() const;
	void  updateLayer(const MgQLayerNode*);
	MgQBaseNode* rootNode() {return rootNode_;}
	

	void paint(QPainter *, const QStyleOptionGraphicsItem *,
                QWidget *widget=0);

protected:
	void addContentsToAlphaScene();
	void addContentsBackToScene();

	const Layer& layer_;

	MgQBaseNode* rootNode_;
	bool rootNodeIsChild_;

	MgQLayoutNode* layout_;

	QGraphicsScene *alphaScene_;
	QImage *alphaDevice_;
	QPainter* alphaPainter_;
};



#endif
