/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file InputMatrixInterpretor.h
    \brief Implementation of the Template class InputMatrixInterpretor.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 16-Sep-2005
    
    Changes:
    
*/

#include "InputMatrixInterpretor.h"
#include "InputMatrix.h"

using namespace magics;

InputMatrixInterpretor::InputMatrixInterpretor() 
{
	mappers_["upper_left"] = &InputMatrixInterpretor::upperLeft;
	mappers_["lower_left"] = &InputMatrixInterpretor::lowerLeft;
	mappers_["upper_right"] = &InputMatrixInterpretor::upperRight;
	mappers_["lower_right"] = &InputMatrixInterpretor::lowerRight;     
	mappers_["upper_left_transposed"] = &InputMatrixInterpretor::upperLeftTransposed;
	mappers_["lower_left_transposed"] = &InputMatrixInterpretor::lowerLeftTransposed;
	mappers_["upper_right_transposed"] = &InputMatrixInterpretor::upperRightTransposed;
	mappers_["lower_right_transposed"] = &InputMatrixInterpretor::lowerRightTransposed;
}

InputMatrixInterpretor::~InputMatrixInterpretor() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void InputMatrixInterpretor::print(ostream& out)  const
{
	out << "InputMatrixInterpretor[";
	out << "]";
}


InputMatrixRegularInterpretor::InputMatrixRegularInterpretor() 
{    
}

InputMatrixRegularInterpretor::~InputMatrixRegularInterpretor() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void InputMatrixRegularInterpretor::print(ostream& out)  const
{
	out << "InputMatrixRegularInterpretor[";
	out << "]";
}

void InputMatrixRegularInterpretor::interpret(Matrix& in, const InputMatrix<GeoPoint>& info)
{
	std::map<string, Mapper>::iterator mapper = mappers_.find(lowerCase(info.getMapping()));

	if ( mapper == mappers_.end() )
		Log::warning() << "unknow input matrix mapping " << info.getMapping() << endl;
	else 
		(this->*mapper->second)();

	int nblon =  in.columns();
	double lon = longitude_;
	
	for (int i = 0; i < nblon; i++) {		
		in.columnsAxis().push_back(lon);
		lon += longitude_step_;		
	}

	int nblat =  in.rows();
	double lat = latitude_;
	
	for (int i = 0; i < nblat; i++) {		
		in.rowsAxis().push_back(lat);
		lat += latitude_step_;
	}
	in.setMapsAxis();
	Log::dev()<< in << endl;
}


void InputMatrixRegularInterpretor::interpret(Matrix& in, const InputMatrix<UserPoint>& info)
{
	double y = y_first_;
	double step = (y_last_ - y_first_)/(in.rows()-1);
	for (int i = 0; i < in.rows(); i++) {
			Log::dev() << y << endl;
			in.rowsAxis().push_back(y);
			y += step;
	}

	double x = x_first_;
	step = (x_last_ - x_first_)/(in.columns()-1);
	for (int i = 0; i < in.columns(); i++) {
			Log::dev() << x << endl;
			in.columnsAxis().push_back(x);
			x += step;
	}

	in.setMapsAxis();
}


InputMatrixIrregularInterpretor::InputMatrixIrregularInterpretor() 
{    
}

InputMatrixIrregularInterpretor::~InputMatrixIrregularInterpretor() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void InputMatrixIrregularInterpretor::print(ostream& out)  const
{
	out << "InputMatrixIrregularInterpretor[";
	out << "]";
}

void InputMatrixIrregularInterpretor::interpret(Matrix& in, const InputMatrix<GeoPoint>& info)
{
	std::map<string, Mapper>::iterator mapper = mappers_.find(lowerCase(info.getMapping()));

	if ( mapper == mappers_.end() )
		Log::warning() << "unknow input matrix mapping " << info.getMapping() << endl;
	else 
		(this->*mapper->second)();
	
	for (vector<double>::iterator y = latitudes_.begin(); y != latitudes_.end(); ++y) {
			Log::dev() << *y << endl;
			in.rowsAxis().push_back(*y);
	}

	for (vector<double>::iterator x = longitudes_.begin(); x != longitudes_.end(); ++x) {
			Log::dev() << *x << endl;
			in.rowsAxis().push_back(*x);					
	}

	in.setMapsAxis();
}


void InputMatrixIrregularInterpretor::interpret(Matrix& in, const InputMatrix<UserPoint>& info)
{
	std::map<string, Mapper>::iterator mapper = mappers_.find(lowerCase(info.getMapping()));

	if ( mapper == mappers_.end() )
		Log::warning() << "unknow input matrix mapping " << info.getMapping() << endl;
	else 
		(this->*mapper->second)();

	for (vector<double>::iterator y = y_.begin(); y != y_.end(); ++y) {
		Log::dev() << *y << endl;
		in.rowsAxis().push_back(*y);
	}

	for (vector<double>::iterator x = x_.begin(); x != x_.end(); ++x) {
			Log::dev() << *x << endl;
			in.rowsAxis().push_back(*x);					
	}

	in.setMapsAxis();
}


void InputMatrixInterpretor::upperLeft()
{
}

void InputMatrixInterpretor::lowerLeft()
{
}

void InputMatrixInterpretor::upperRight()
{
}

void InputMatrixInterpretor::lowerRight()   
{
}

  
void InputMatrixInterpretor::upperLeftTransposed()
{
}

void InputMatrixInterpretor::lowerLeftTransposed()
{
}

void InputMatrixInterpretor::upperRightTransposed()
{
}

void InputMatrixInterpretor::lowerRightTransposed()
{
}
