.TH "ZIP_SOURCE_FUNCTION" "3" "November 13, 2014" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_function\fR
\- create data source from function
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_function\fR(\fIzip_t\ *archive\fR, \fIzip_source_callback\ fn\fR, \fIvoid\ *userdata\fR);
.PD
.PP
\fIzip_source_t *\fR
.PD 0
.HP 4n
\fBzip_source_function_create\fR(\fIzip_source_callback\ fn\fR, \fIvoid\ *userdata\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The functions
\fBzip_source_function\fR()
and
\fBzip_source_function_create\fR()
creates a zip source from the user-provided function
\fIfn\fR,
which must be of the following type:
.PP
\fItypedef zip_int64_t\fR
\fB\fR(*\fPzip_source_callback\fR)\fP\fR(\fIvoid\ *userdata\fR, \fIvoid\ *data\fR, \fIzip_uint64_t\ len\fR, \fIzip_source_cmd_t\ cmd\fR)
.PP
\fIarchive\fR
or
\fIerror\fR
are used for reporting errors and can be
\fRNULL\fR.
.PP
When called by the library, the first argument is the
\fIuserdata\fR
argument supplied to the function.
The next two arguments are a buffer
\fIdata\fR
of size
\fIlen\fR
when data is passed in or expected to be returned, or else
\fRNULL\fR
and 0.
The last argument,
\fIcmd\fR,
specifies which action the function should perform.
.PP
Depending on the uses, there are three useful sets of commands to be supported by a
\fBzip_source_callback\fR():
.TP 24n
read source
Providing streamed data (for file data added to archives).
Must support
\fRZIP_SOURCE_OPEN\fR,
\fRZIP_SOURCE_READ\fR,
\fRZIP_SOURCE_CLOSE\fR,
\fRZIP_SOURCE_STAT\fR,
and
\fRZIP_SOURCE_ERROR\fR.
.TP 24n
seekable read source
Same as previous, but from a source allowing reading from arbitrary
offsets (also for read-only zip archive).
Must additionally support
\fRZIP_SOURCE_SEEK\fR,
\fRZIP_SOURCE_TELL\fR,
and
\fRZIP_SOURCE_SUPPORTS\fR.
.TP 24n
read/write source
Same as previous, but additionally allowing writing (also for writable
zip archives).
Must additionally support
\fRZIP_SOURCE_BEGIN_WRITE\fR,
\fRZIP_SOURCE_COMMIT_WRITE\fR,
\fRZIP_SOURCE_ROLLBACK_WRITE\fR,
\fRZIP_SOURCE_SEEK_WRITE\fR,
\fRZIP_SOURCE_TELL_WRITE\fR,
and
\fRZIP_SOURCE_REMOVE\fR.
.SS "\fRZIP_SOURCE_BEGIN_WRITE\fR"
Prepare the source for writing.
Use this to create any temporary file(s).
.SS "\fRZIP_SOURCE_CLOSE\fR"
Reading is done.
.SS "\fRZIP_SOURCE_COMMIT_WRITE\fR"
Finish writing to the source.
Replace the original data with the newly written data.
Clean up temporary files or internal buffers.
Subsequently opening and reading from the source should return the
newly written data.
.SS "\fRZIP_SOURCE_ERROR\fR"
Get error information.
\fIdata\fR
points to an array of two ints, which should be filled with the libzip
error code and the corresponding system error code for the error that
occurred.
See
zip_errors(3)
for details on the error codes.
If the source stores error information in a zip_error_t, use
zip_error_to_data(3)
and return its return value.
Otherwise, return 2 * sizeof(int).
.SS "\fRZIP_SOURCE_FREE\fR"
Clean up and free all resources, including
\fIstate\fR.
The callback function will not be called again.
.SS "\fRZIP_SOURCE_OPEN\fR"
Prepare for reading.
.SS "\fRZIP_SOURCE_READ\fR"
Read data into the buffer
\fIdata\fR
of size
\fIlen\fR.
Return the number of bytes placed into
\fIdata\fR
on success.
.SS "\fRZIP_SOURCE_REMOVE\fR"
Remove the underlying file.
This is called if a zip archive is empty when closed.
.SS "\fRZIP_SOURCE_ROLLBACK_WRITE\fR"
Abort writing to the source.
Discard written data.
Clean up temporary files or internal buffers.
Subsequently opening and reading from the source should return the
original data.
.SS "\fRZIP_SOURCE_SEEK\fR"
Specify position to read next byte from, like
fseek(3).
Use
ZIP_SOURCE_GET_ARGS(3)
to decode the arguments into the following struct:
.nf
.sp
.RS 0n
struct zip_source_args_seek {
    zip_int64_t offset;
    int whence;
};
.RE
.fi
.PP
If the size of the source's data is known, use
zip_source_seek_compute_offset(3)
to validate the arguments and compute the new offset.
.SS "\fRZIP_SOURCE_SEEK_WRITE\fR"
Specify position to write next byte to, like
fseek(3).
See
\fRZIP_SOURCE_SEEK\fR
for details.
.SS "\fRZIP_SOURCE_STAT\fR"
Get meta information for the input data.
\fIdata\fR
points to an allocated
\fIstruct zip_stat\fR,
which should be initialized using
zip_stat_init(3)
and then filled in.
Information only available after the source has been read (e.g. size)
can be omitted in an earlier call.
Return sizeof(struct zip_stat) on success.
\fINOTE\fR:
\fBzip_source_function\fR()
may be called with this argument even after being called with
\fRZIP_SOURCE_CLOSE\fR.
.SS "\fRZIP_SOURCE_SUPPORTS\fR"
Return bitmap specifying which commands are supported.
Use
zip_source_make_command_bitmap(3).
If this command is not implemented, the source is assumed to be a
read source without seek support.
.SS "\fRZIP_SOURCE_TELL\fR"
Return the current read offset in the source, like
ftell(3).
.SS "\fRZIP_SOURCE_TELL_WRITE\fR"
Return the current write offset in the source, like
ftell(3).
.SS "\fRZIP_SOURCE_WRITE\fR"
Write data to the source.
Return number of bytes written.
.SS "Return Values"
Commands should return \-1 on error.
\fRZIP_SOURCE_ERROR\fR
will be called to retrieve the error code.
On success, commands return 0, unless specified otherwise in the
description above.
.SS "Calling Conventions"
The library will always issue
\fRZIP_SOURCE_OPEN\fR
before issuing
\fRZIP_SOURCE_READ\fR,
\fRZIP_SOURCE_SEEK\fR,
or
\fRZIP_SOURCE_TELL\fR.
When it no longer wishes to read from this source, it will issue
\fRZIP_SOURCE_CLOSE\fR.
If the library wishes to read the data again, it will issue
\fRZIP_SOURCE_OPEN\fR
a second time.
If the function is unable to provide the data again, it should
return \-1.
.PP
\fRZIP_SOURCE_BEGIN_WRITE\fR
will be called before
\fRZIP_SOURCE_WRITE\fR,
\fRZIP_SOURCE_SEEK_WRITE\fR,
or
\fRZIP_SOURCE_TELL_WRITE\fR.
When writing is complete, either
\fRZIP_SOURCE_COMMIT_WRITE\fR
or
\fRZIP_SOURCE_ROLLBACK_WRITE\fR
will be called.
.PP
\fRZIP_SOURCE_STAT\fR
can be issued at any time.
.PP
\fRZIP_SOURCE_ERROR\fR
will only be issued in response to the function
returning \-1.
.PP
\fRZIP_SOURCE_FREE\fR
will be the last command issued;
if
\fRZIP_SOURCE_OPEN\fR
was called and succeeded,
\fRZIP_SOURCE_CLOSE\fR
will be called before
\fRZIP_SOURCE_FREE\fR,
and similarly for
\fRZIP_SOURCE_BEGIN_WRITE\fR
and
\fRZIP_SOURCE_COMMIT_WRITE\fR
or
\fRZIP_SOURCE_ROLLBACK_WRITE\fR.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIarchive\fR
or
\fIerror\fR
is set to indicate the error (unless
it is
\fRNULL\fR).
.SH "ERRORS"
\fBzip_source_function\fR()
fails if:
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source(3),
zip_stat_init(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
