// The template module. 
// parses the <xmltemplate> container, and and fills a template with the
// provided data.
//  This code is (c) 1999 Martin Baehr, and can be used, modified and
//  redistributed freely under the terms of the GNU General Public License,
//  version 2.


constant cvs_version="$Id: xmltemplate.pike,v 1.3 2000/07/17 07:38:34 pit Exp $";

#include <module.h>
#include <stdio.h>
inherit "xmlutils";

static private string doc() {
  return "documentation pending";
}

array register_module() {
  return ({ MODULE_PARSER, "XML.Template",
			   "Defines the <tt>&lt;xmltemplate&gt;&lt;/xmltemplate&gt;</tt> "
			   "container, <br>Help can be displayed with "
			   "<tt>&lt;xmltemplate help&gt;&lt;/xmltemplate&gt;</tt>"+doc()
			   ,0,1 });
}

void create() {
  defvar("template_location", "NONE/", "XML Template search path", TYPE_DIR
	 , "The directory where your templates are stored");
}


string xmltemplate(array data, mapping attributes, object id) {
  string file_contents;
  file_contents=read_file(attributes->file);
  if(!file_contents || sizeof(file_contents)<1) {
    file_contents=read_file(QUERY(template_location)+attributes->file);
    if(!file_contents || sizeof(file_contents)<1) {
      return "Failed to open file: " +attributes->file+")\n";
    }
  }
  return template(file_contents, data, attributes, id);
}


string template(string file_contents, array data, mapping attributes, object id) {
  mapping tags = ([]);
  int i;
  
  for(i=0; i<sizeof(data); i++) {
    if(mappingp(data[i])) {
      if(data[i]->data && sizeof(data[i]->data)>1) {
	file_contents = template(file_contents, data[i]->data, attributes, id);
      }
      tags += ([ data[i]->name:itag_template ]);
    }
  }
  return parse_html(file_contents, tags, ([]), data, id);
}


string itag_template(string tag_name, mapping attributes, array data, object id) {
  string out="";
  int i;
  for(i=0; i<sizeof(data); i++) {
    if(mappingp(data[i]))
      if(data[i]->name==tag_name) {
        if(data[i]->data && sizeof(data[i]->data)>1) {
          out = data_to_xml(data[i]->data, id);
        } else {
	  out = data[i]->data[0];
	}
    }
  }
  return out;
}

string container_template(string container_name, mapping arguments, string contents, object id, mapping defines) {
  array result;
  string out = "";
  mapping temp;
  string index;
  
  if(arguments->parse_rxml)
    contents = parse_rxml(contents, id);

  // spider.XML ist fuer html tags (nicht container) fehlerhaft
  contents=replace(contents, 
		   ({ "<br>",   "<BR>",   "<p>",   "<P>",   "<HR>",   "<hr>"     }),
		   ({ "||br||", "||br||", "||p||", "||p||", "||hr||", "||hr||"   })
		   );
  
  result = spider.XML()->parse(make_xml_container("xmltemplate", arguments, contents), callback);
  out += xmltemplate(result, arguments, id);
  
  //object x=Stdio.File();
  //x->open("/home/pit/roxdevel","wc");
  //foreach(indices(id->conf), index) {
  //  x->write(sprintf("%s-> %O<hr>\n", index, id->conf[index]));
  //}
  //x->write(sprintf("%O", result));
  //x->close();
    
  out=out / "||br||" * "<br>";
  out=out / "||p||"  * "<p>";
  out=out / "||hr||"  * "<hr>";
  
  return out;
}

string null_container(string container_name, mapping arguments, string contents, object id, mapping defines) {
  return "";
}

mapping query_container_callers() {
  return ([ "xmltemplate":container_template,
	    "xmltemplateinfo" : null_container 
	   ]);
}

void unload(object o) {
  m_delete(master()->programs,search(master()->programs,object_program(o)));
  destruct(o);
}






//foreach(indices(id->conf), index) {
//  out += sprintf("%s: %O<hr>\n", index, id->conf[index]);
//}
