#include "osl/misc/carray.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
using namespace osl;

class CArrayTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( CArrayTest );
  CPPUNIT_TEST(testCallConstructor);
  CPPUNIT_TEST(testPlayerAccess);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCallConstructor();
  void testPlayerAccess();
};

CPPUNIT_TEST_SUITE_REGISTRATION(CArrayTest);

void CArrayTest::testPlayerAccess()
{
  CArray<int, 2> array = {{ 100, 200 }};
  CPPUNIT_ASSERT_EQUAL(100, array[BLACK]);
  CPPUNIT_ASSERT_EQUAL(200, array[WHITE]);
}

namespace
{
  struct Count
  {
    static int count;
    Count()
    {
      ++count;
    }
  };
  int Count::count = 0;
}

void CArrayTest::testCallConstructor()
{
  CPPUNIT_ASSERT_EQUAL(0, Count::count);
  CArray<Count,4> a;
  CPPUNIT_ASSERT_EQUAL(4, Count::count);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
