#include "osl/game_playing/alphaBetaPlayer.h"
#include "osl/game_playing/gameState.h"
#include "osl/eval/progressEval.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::game_playing;

class AlphaBetaPlayerTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(AlphaBetaPlayerTest);
  CPPUNIT_TEST(testResign);
  CPPUNIT_TEST(testWin);
  CPPUNIT_TEST_SUITE_END();
public:
  void testResign();
  void testWin();
};

CPPUNIT_TEST_SUITE_REGISTRATION(AlphaBetaPlayerTest);

static void load()
{
  static bool loaded = osl::eval::ProgressEval::setUp();
  CPPUNIT_ASSERT(loaded);
}

const int seconds = 5;
void AlphaBetaPlayerTest::testResign()
{
  load();
  const SimpleState state(CsaString(
			 "P1 *  *  *  * -OU *  *  *  * \n"
			 "P2 *  *  *  * +KI *  *  *  * \n"
			 "P3 *  *  *  * +FU *  *  *  * \n"
			 "P4 *  *  *  *  *  *  *  *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  *  *  * \n"
			 "P7 *  *  *  *  *  *  *  *  * \n"
			 "P8 *  *  *  *  *  *  *  *  * \n"
			 "P9 *  *  *  * +OU *  *  *  * \n"
			 "P-00AL\n"
			 "-\n").getInitialState());
  const GameState gs(state);
  AlphaBeta2ProgressEvalPlayer player;
  const MoveWithComment best_move = player.selectBestMove(gs, 1500, seconds, 0);
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), best_move.move);
}

void AlphaBetaPlayerTest::testWin()
{
  load();
  const SimpleState state(CsaString(
			 "P1 *  *  *  * -OU *  *  *  * \n"
			 "P2 *  *  *  *  *  *  *  *  * \n"
			 "P3 *  *  *  * +FU *  *  *  * \n"
			 "P4 *  *  *  *  *  *  *  *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  *  *  * \n"
			 "P7 *  *  *  *  *  *  *  *  * \n"
			 "P8 *  *  *  *  *  *  *  *  * \n"
			 "P9 *  *  *  * +OU *  *  *  * \n"
			 "P+00KI\n"
			 "P-00AL\n"
			 "+\n").getInitialState());
  const GameState gs(state);
  AlphaBeta2ProgressEvalPlayer player;
  const MoveWithComment best_move = player.selectBestMove(gs, 1500, seconds, 0);
  const Move expected(Position(5,2), GOLD, BLACK);
  CPPUNIT_ASSERT_EQUAL(expected, best_move.move);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
