/* kingPieceTable.h
 */
#ifndef ENDGAME_KINGPIECETABLE_H
#define ENDGAME_KINGPIECETABLE_H

#include "osl/piece.h"
#include "osl/misc/carray2d.h"

namespace osl
{
  namespace state
  {
    class SimpleState;
  }
  namespace container
  {
    class PieceValues;
  }
  namespace eval
  {
    namespace endgame
    {
      /**
       * 玉と他の駒の関係を保持
       */
      class KingPieceTable
      {
      protected:
	CArray2d<int,Position::SIZE*2,Position::SIZE*PTYPE_SIZE> data;
	KingPieceTable() {}
      public:
	static int otherIndex(Position other, Ptype ptype)
	{
	  return other.index()*PTYPE_SIZE + ptype;
	}
	static int kingIndex(Position king, Player defense)
	{
	  return king.index()*2+playerToIndex(defense);
	}
	int& valueOf(Position king, Player defense, Position other, Ptype ptype)
	{
	  return data[kingIndex(king,defense)][otherIndex(other,ptype)];
	}
	int valueOf(Position king, Player defense, Position other, Ptype ptype) const
	{
	  return data[kingIndex(king,defense)][otherIndex(other, ptype)];
	}
      };
    } // namespace endgame
  } // namespace endgame
} // namespace osl


#endif /* ENDGAME_KINGPIECETABLE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
