/* boardBitEffect.h
 */
#ifndef _BOARD_BIT_EFFECT_H
#define _BOARD_BIT_EFFECT_H
#include "osl/applyDoUndoXMove.h"
#include "osl/boardBitMask.h"
namespace osl
{
  namespace effect
  {
    /**
     * 91マスの盤上の駒の有無を91ビットで表現するState.
     * 2つの位置の間がすべて空白かを高速に判定可能
     * 64bitプロセッサあるいはSSE2命令があるプロセッサで特に有効
     * 現在は使われていない
     */
    template<class State>
    class BoardBitEffect : public State{
      typedef BoardBitEffect<State> BoardBitState;
      friend class ApplyDoUndoSimpleMove<BLACK,BoardBitState>;
      friend class ApplyDoUndoCaptureMove<BLACK,BoardBitState>;
      friend class ApplyDoUndoDropMove<BLACK,BoardBitState>;
      friend class ApplyDoUndoSimpleMove<WHITE,BoardBitState>;
      friend class ApplyDoUndoCaptureMove<WHITE,BoardBitState>;
      friend class ApplyDoUndoDropMove<WHITE,BoardBitState>;
    public:
      BoardBitMask emptyMask;
      typedef BoardBitEffect effect_state_t;
      template<typename OrigState>
      explicit BoardBitEffect(OrigState& st) :State(st),emptyMask(st){
      }
      /**
       * 引数なしのコンストラクタも一応定義しておく
       */
      explicit BoardBitEffect() {
      }
    };

    template<Player P,typename BaseState>
    struct ApplyDoUndoSimpleMove<P,BoardBitEffect<BaseState> >
    {
      typedef BoardBitEffect<BaseState> state_t;
      template <typename F>
      static void doUndoSimpleMove(state_t& s, 
				   Position from, Position to, int promoteMask,F& func){
	BoardBitMask oldMask=s.emptyMask;
	s.emptyMask^=(boardBitMaskTable.getMask(from)^boardBitMaskTable.getMask(to));
	ApplyDoUndoSimpleMove<P,BaseState>::doUndoSimpleMove(s,from,to,promoteMask,func);
	s.emptyMask=oldMask;
      }
    };
  
    template<Player P,typename BaseState>
    struct ApplyDoUndoDropMove<P,BoardBitEffect<BaseState> >
    {
      typedef BoardBitEffect<BaseState> state_t;
      template <typename F>
      static void doUndoDropMove(state_t& s, 
				 Position to, Ptype ptype,F& func){
	BoardBitMask oldMask=s.emptyMask;
	s.emptyMask^=boardBitMaskTable.getMask(to);
	ApplyDoUndoDropMove<P,BaseState>::doUndoDropMove(s,to,ptype,func);
	s.emptyMask=oldMask;
      }
    };

    template<Player P,typename BaseState>
    struct ApplyDoUndoCaptureMove<P,BoardBitEffect<BaseState> >
    {
      typedef BoardBitEffect<BaseState> state_t;
      template <typename F>
      static void doUndoCaptureMove(state_t& s,
				    Position from,Position to, Piece p1, int promoteMask,F& func){
	BoardBitMask oldMask=s.emptyMask;
	s.emptyMask^=boardBitMaskTable.getMask(from);
	ApplyDoUndoCaptureMove<P,BaseState>::doUndoCaptureMove(s,from,to,p1,promoteMask,func);
	s.emptyMask=oldMask;
      }
    };
  
  } // namespace effect
} // namespace osl

#endif // _BOARD_BIT_EFFECT_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
