/***************************************************************************
 $RCSfile: inetaddress.h,v $
 -------------------
 cvs         : $Id: inetaddress.h,v 1.6 2002/09/20 09:01:25 cstim Exp $
 begin       : Wed Dec 12 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : martin@aquamaniac.de
 */


/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef C_INEDADDRESS_H
#define C_INEDADDRESS_H

#include <string>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>

#include <openhbci/error.h>


namespace HBCI {

/**
 * @short This class represents a platform independent internet address.
 *
 * @author Martin Preuss<martin@aquamaniac.de>
 */
class InetAddress {
    friend class Socket;
private:
    sockaddr_in _inaddr;
    string _name;

public:
    /**
     * Creates an empty internet address (0.0.0.0)
     * @author Martin Preuss<martin@aquamaniac.de>
     */
    InetAddress();

    /**
     * Creates a representation of the given internet address.
     * If the given address is not in 3-dot-format then it
     * will be treaten as the host name, which will be looked up.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @param addr 3-dot-format address (like "1.2.3.4") or host name
     */
    InetAddress(string addr);

    ~InetAddress();

    /**
     * Returns the string representation of this address in 3-dot-format.
     * @author Martin Preuss<martin@aquamaniac.de>
     */
    string address() const;

    /**
     * Returns the host name for this address. This name is retreived via
     * a lookup (depending on your system this might be a dns lookup)
     * @author Martin Preuss<martin@aquamaniac.de>
     */
    string name() const;
};


} /* namespace HBCI */


#endif








