/***************************************************************************
 $RCSfile: standingorder.cpp,v $
 -------------------
 cvs         : $Id: standingorder.cpp,v 1.9 2003/06/14 11:06:23 aquamaniac Exp $
 begin       : The Jun 18 2002
 copyright   : (C) 2002 by Fabian Kaiser
 email       : openhbci@derzach.de


 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "standingorder.h"

#include "assert.h"
#include "error.h"
#include "pointer.h"
#include "date.h"
#include "value.h"
#include "hbcistring.h"
#include "bpdjob.h"
#include "auth.h"
#include "interactor.h"
#include "hbci.h"
#include "bankparams.h"
#include "bankimpl.h"
#include <accountimpl.h>

namespace HBCI {

const int StandingOrder::EXECUTE_WEEKLY = 0;
const int StandingOrder::EXECUTE_MONTHLY = 1;


StandingOrder::StandingOrder()
  :_ourCountryCode(280)
  ,_otherCountryCode(280)
  ,_transactionCode(0)
{
}


StandingOrder::StandingOrder(const string &s,
			     Pointer<Account> account)
  :_ourCountryCode(280)
  ,_otherCountryCode(280)
  ,_transactionCode(0)
{
  _jobId = s;
  Pointer<Bank> bank = account.ref().bank();

  setOurAccountId(account.ref().accountId());
  setOurSuffix(account.ref().accountSuffix());
  setOurCountryCode(bank.ref().countryCode());
  setOurBankCode(bank.ref().bankCode());
}


StandingOrder::StandingOrder(Pointer<Account> account){
	Pointer<Bank> bank = account.ref().bank();

	setOurAccountId(account.ref().accountId());
	setOurSuffix(account.ref().accountSuffix());
	setOurCountryCode(bank.ref().countryCode());
	setOurBankCode(bank.ref().bankCode());

}

bool 
StandingOrder::operator==(const StandingOrder &otherOrder) const{
  return (_jobId == otherOrder._jobId &&
	  _ourAccountId == otherOrder._ourAccountId &&
	  _ourSuffix == otherOrder._ourSuffix &&
	  _ourBankCode == otherOrder._ourBankCode &&
	  _otherAccountId == otherOrder._otherAccountId &&
	  _otherSuffix == otherOrder._otherSuffix &&
	  _otherBankCode == otherOrder._otherBankCode &&

	  _value == otherOrder._value &&
	  _period == otherOrder._period &&
	  _cycle == otherOrder._cycle &&
	  _execDay == otherOrder._execDay);
}

const string &StandingOrder::jobIdentification() const {
  return _jobId;
}


void StandingOrder::setJobIdentification(const string &s) {
  _jobId = s;
}

const string &StandingOrder::ourAccountId() const {
    return _ourAccountId;
}

void StandingOrder::setOurAccountId(const string &s) {
    _ourAccountId = s;
    modOurAccount = true;
}


const string &StandingOrder::ourSuffix() const {
    return _ourSuffix;
}

void StandingOrder::setOurSuffix(const string &s) {
    _ourSuffix = s;
    modOurAccount = true;
}


const string &StandingOrder::ourBankCode() const {
    return _ourBankCode;
}


void StandingOrder::setOurBankCode(const string &s) {
    _ourBankCode = s;
    modOurAccount = true;
}


int StandingOrder::ourCountryCode() const {
    return _ourCountryCode;
}


void StandingOrder::setOurCountryCode(int c) {
    _ourCountryCode = c;
    modOurAccount = true;
}

const string &StandingOrder::otherAccountId() const {
    return _otherAccountId;
}

void StandingOrder::setOtherAccountId(const string &s) {
    _otherAccountId = s;
    modOtherAccount = true;
}


const string &StandingOrder::otherSuffix() const {
    return _otherSuffix;
}

void StandingOrder::setOtherSuffix(const string &s) {
    _otherSuffix = s;
    modOtherAccount = true;
}


const string &StandingOrder::otherBankCode() const {
    return _otherBankCode;
}


void StandingOrder::setOtherBankCode(const string &s) {
    _otherBankCode = s;
    modOtherAccount = true;
}


int StandingOrder::otherCountryCode() const {
    return _otherCountryCode;
}


void StandingOrder::setOtherCountryCode(int c) {
    _otherCountryCode = c;
    modOtherAccount = true;
}

const list<string> &StandingOrder::otherName() const {
    return _otherName;
}

void StandingOrder::addOtherName(const string &s) {
    _otherName.push_back(s);
}


const Value &StandingOrder::value() const {
    return _value;
}


void StandingOrder::setValue(const Value &v) {
    _value = v;
    modValue = true;
}


const list<string> &StandingOrder::description() const {
  return _description;
}


void StandingOrder::addDescription(const string &s) {
    _description.push_back(s);
    modDescription = true;
}


int StandingOrder::transactionCode() const {
    return _transactionCode;
}


void StandingOrder::setTransactionCode(int c) {
    _transactionCode = c;
    modTransactionCode = true;
}


const Date &StandingOrder::firstExecutionDate() const {
    return _firstExecution;
}


void StandingOrder::setFirstExecutionDate(const Date &ex) {
    _firstExecution = ex;
    modDetails = true;
}


const Date &StandingOrder::lastExecutionDate() const {
    return _lastExecution;
}


void StandingOrder::setLastExecutionDate(const Date &ex) {
    _lastExecution = ex;
    modDetails = true;
}


const Date &StandingOrder::executionDate() const {
    return _execDate;
}


void StandingOrder::setExecutionDate(const Date &ex) {
    _execDate = ex;
    modExecDate = true;
}


int StandingOrder::cycle() const {
    return _cycle;
}


void StandingOrder::setCycle(int v) {/* Default value: v=1 */
    _cycle = v;
    modDetails = true;
}


int StandingOrder::period() const {
    return _period;
}


void StandingOrder::setPeriod(int c) {/* Default value: c=EXECUTE_MONTHLY */
    _period = c;
    modDetails = true;
}


int StandingOrder::execDay() const {
    return _execDay;
}


void StandingOrder::setExecDay(int d) {/* Default value: d=1 */
    _execDay = d;
    modDetails = true;
}

} // namespace HBCI

void list_HBCI_StO_delete(list_HBCI_StO *l)
{
    delete l;
}
void list_HBCI_StO_iter_delete(list_HBCI_StO_iter *l)
{
    delete l;
}
int list_HBCI_StO_size(const list_HBCI_StO *l)
{
    assert(l);
    return l->size();
}
list_HBCI_StO_iter* 
list_HBCI_StO_begin(const list_HBCI_StO *l)
{
    assert(l);
    return new list_HBCI_StO_iter(l->begin());
}
list_HBCI_StO_iter* 
list_HBCI_StO_end(const list_HBCI_StO *l)
{
    assert(l);
    return new list_HBCI_StO_iter(l->end());
}
const HBCI_StandingOrder *
list_HBCI_StO_iter_get(const list_HBCI_StO_iter *l)
{
    assert(l);
    return (**l).ptr();
}
void
list_HBCI_StO_iter_next(list_HBCI_StO_iter *l)
{
    assert(l);
    l->operator++();
}
int list_HBCI_StO_iter_equal(const list_HBCI_StO_iter *l1, 
			     const list_HBCI_StO_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_StO_foreach (const list_HBCI_StO *list, 
			     list_HBCI_StO_cb func,
			     void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_StO_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}



HBCI_StandingOrder * HBCI_StandingOrder_new()
{
    return new HBCI_StandingOrder();
}
void HBCI_StandingOrder_delete(HBCI_StandingOrder *t)
{
    delete t;
}

int HBCI_StandingOrder_ourCountryCode(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->ourCountryCode();
}
void 
HBCI_StandingOrder_setOurCountryCode(HBCI_StandingOrder *t, int i)
{
    assert(t);
    t->setOurCountryCode(i);
}
const char * HBCI_StandingOrder_ourBankCode(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->ourBankCode().c_str();
}
void 
HBCI_StandingOrder_setOurBankCode(HBCI_StandingOrder *t, const char *code)
{
    assert(t);
    t->setOurBankCode(string(code ? code : ""));
}
const char * HBCI_StandingOrder_ourAccountId(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->ourAccountId().c_str();
}
void 
HBCI_StandingOrder_setOurAccountId(HBCI_StandingOrder *t, const char *id)
{
    assert(t);
    t->setOurAccountId(string(id ? id : ""));
}
const char * HBCI_StandingOrder_ourSuffix(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->ourSuffix().c_str();
}
void 
HBCI_StandingOrder_setOurSuffix(HBCI_StandingOrder *t, const char *id)
{
    assert(t);
    t->setOurSuffix(string(id ? id : ""));
}
const HBCI_Value* HBCI_StandingOrder_value(const HBCI_StandingOrder *t)
{
    assert(t);
    return &(t->value());
}
void 
HBCI_StandingOrder_setValue(HBCI_StandingOrder *t, const HBCI_Value *v)
{
    assert(t);
    assert(v);
    t->setValue(*v);
}
int HBCI_StandingOrder_transactionCode(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->transactionCode();
}
void 
HBCI_StandingOrder_setTransactionCode(HBCI_StandingOrder *t, int c)
{
    assert(t);
    t->setTransactionCode(c);
}
const list_string* HBCI_StandingOrder_description(const HBCI_StandingOrder *t)
{
    assert(t);
    return &(t->description());
}
void 
HBCI_StandingOrder_addDescription(HBCI_StandingOrder *t, const char *s)
{
    assert(t);
    t->addDescription(string(s ? s : ""));
}
int HBCI_StandingOrder_otherCountryCode(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->otherCountryCode();
}
void 
HBCI_StandingOrder_setOtherCountryCode(HBCI_StandingOrder *t, int i)
{
    assert(t);
    t->setOtherCountryCode(i);
}
const char * HBCI_StandingOrder_otherBankCode(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->otherBankCode().c_str();
}
void 
HBCI_StandingOrder_setOtherBankCode(HBCI_StandingOrder *t, const char *s)
{
    assert(t);
    t->setOtherBankCode(string(s ? s : ""));
}
const char * HBCI_StandingOrder_otherAccountId(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->otherAccountId().c_str();
}
void 
HBCI_StandingOrder_setOtherAccountId(HBCI_StandingOrder *t, const char *s)
{
    assert(t);
    t->setOtherAccountId(string(s ? s : ""));
}
const char * HBCI_StandingOrder_otherSuffix(const HBCI_StandingOrder *t)
{
    assert(t);
    return t->otherSuffix().c_str();
}
void 
HBCI_StandingOrder_setOtherSuffix(HBCI_StandingOrder *t, const char *id)
{
    assert(t);
    t->setOtherSuffix(string(id ? id : ""));
}
const list_string* HBCI_StandingOrder_otherName(const HBCI_StandingOrder *t)
{
    assert(t);
    return &(t->otherName());
}
void 
HBCI_StandingOrder_addOtherName(HBCI_StandingOrder *t, const char *s)
{
    assert(t);
    t->addOtherName(string(s ? s : ""));
}





const char *
HBCI_StandingOrder_jobIdentification(const HBCI_StandingOrder *h)
{
    assert(h);
    return h->jobIdentification().c_str();
}
void HBCI_StandingOrder_setJobIdentification(HBCI_StandingOrder *h,
					     const char *s)
{
    assert(h);
    h->setJobIdentification(string(s ? s : ""));
}
const HBCI_Date *
HBCI_StandingOrder_firstExecutionDate(const HBCI_StandingOrder *h)
{
    assert(h);
    return &(h->firstExecutionDate());
}
void 
HBCI_StandingOrder_setFirstExecutionDate(HBCI_StandingOrder *h, 
					 const HBCI_Date *ex)
{
    assert(h);
    assert(ex);
    h->setFirstExecutionDate(*ex);
}
const HBCI_Date *
HBCI_StandingOrder_lastExecutionDate(const HBCI_StandingOrder *h)
{
    assert(h);
    return &(h->lastExecutionDate());
}
void 
HBCI_StandingOrder_setLastExecutionDate(HBCI_StandingOrder *h,
					const HBCI_Date *ex)
{
    assert(h);
    assert(ex);
    h->setLastExecutionDate(*ex);
}
const HBCI_Date *
HBCI_StandingOrder_executionDate(const HBCI_StandingOrder *h)
{
    assert(h);
    return &(h->executionDate());
}
void 
HBCI_StandingOrder_setExecutionDate(HBCI_StandingOrder *h, 
				    const HBCI_Date *ex)
{
    assert(h);
    assert(ex);
    h->setExecutionDate(*ex);
}
int HBCI_StandingOrder_cycle(const HBCI_StandingOrder *h)
{
    assert(h);
    return h->cycle();
}
void HBCI_StandingOrder_setCycle(HBCI_StandingOrder *h,
				 int v)
{
    assert(h);
    h->setCycle(v);
}
int HBCI_StandingOrder_period(const HBCI_StandingOrder *h)
{
    assert(h);
    return h->period();
}
void HBCI_StandingOrder_setPeriod(HBCI_StandingOrder *h,
				  int c)
{
    assert(h);
    h->setPeriod(c);
}
int HBCI_StandingOrder_execDay(const HBCI_StandingOrder *h)
{
    assert(h);
    return h->execDay();
}
void HBCI_StandingOrder_setExecDay(HBCI_StandingOrder *h, 
				   int d)
{
    assert(h);
    h->setExecDay(d);
}
