/***************************************************************************
 $RCSfile: medium.cpp,v $
                             -------------------
    cvs         : $Id: medium.cpp,v 1.19 2003/06/07 20:33:43 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#include <string>
#include "medium.h"
#include "hbcistring.h"
#include "deskey.h"

#include <openssl/bn.h>
#include <openssl/ripemd.h>


namespace HBCI {

Medium::Medium(const Hbci *hbci)
    :_hbci(hbci)
    ,_version(0)
{
  //fprintf(stderr," Medium::Medium() (%8x)\n",
  //        (unsigned int )this);
}


Medium::~Medium(){
  //fprintf(stderr,"Destroying medium.\n");
}

/*
void Medium::clear(){
  _owner=0; 
}
*/

string Medium::ripe(const string &source) {
  string result;
  unsigned char hash[20];

  RIPEMD160((unsigned char*) source.data(), source.length(),
	    (unsigned char*) &hash);

  for (int i=0; i<20; i++)
    result += hash[i];

  return result;
}


string Medium::encrypt(const string &src, const string &key){
  DESKey deskey;

  // set data and keydata for deskey
  deskey.setKeyString(key);
  deskey.setData(src);
  // encrypt the plain text
  deskey.encrypt();
  // get the data

  return deskey.getData();
}


string Medium::decrypt(const string &src,const string &key){
  DESKey deskey;

  // set data and keydata for deskey
  deskey.setKeyString(key);
  deskey.setData(src);
  // encrypt the plain text
  deskey.decrypt();
  // get the data
  return deskey.getData();
}



Error Medium::getProperty(const string &propertyName,
			  string &propertyValue){
    return Error("HBCI_Medium_mountMedium",
		 ERROR_LEVEL_NORMAL,
		 HBCI_ERROR_CODE_UNKNOWN_PROPERTY,
		 ERROR_ADVISE_DONTKNOW,
		 "Unknown property",
		 propertyName);
}


Error Medium::setProperty(const string &propertyName,
			  const string &propertyValue){
    return Error("HBCI_Medium_mountMedium",
		 ERROR_LEVEL_NORMAL,
		 HBCI_ERROR_CODE_UNKNOWN_PROPERTY,
		 ERROR_ADVISE_DONTKNOW,
		 "Unknown property",
		 propertyName);
}


} // namespace HBCI


HBCI_Error *HBCI_Medium_mountMedium(HBCI_Medium *h,
				    const char *pin)
{
    assert(h);
    HBCI::Error err;

    try {
      err=h->mountMedium(( (pin) ? string(pin) : ""));
	if (err.isOk())
	    return 0;
	return new HBCI_Error(err);
    }
    catch (HBCI_Error err) {
	return new HBCI_Error (err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_Medium_mountMedium: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_Medium_mountMedium",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}

HBCI_Error *HBCI_Medium_unmountMedium(HBCI_Medium *h, const char *pin)
{
    assert(h);
    try {
	h->unmountMedium( (pin) ? string(pin) : "");
	return 0;
    }
    catch (HBCI_Error err) {
	return new HBCI_Error (err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_Medium_unmountMedium: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_Medium_unmountMedium",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}
int HBCI_Medium_isMounted(HBCI_Medium *h)
{
    assert(h);
    return h->isMounted();
}
char *HBCI_Medium_mediumId(const HBCI_Medium *h)
{
    assert(h);
    return hbci_strdup(h->mediumId());
}
const char *HBCI_Medium_mediumName(const HBCI_Medium *h)
{
    assert(h);
    return h->mediumName().c_str();
}
int HBCI_Medium_securityMode(const HBCI_Medium *h)
{
    assert(h);
    return h->securityMode();
}
HBCI_Error * HBCI_Medium_selectContext(HBCI_Medium *h,
				       int country,
				       const char *instcode,
				       const char *userid)
{
  HBCI::Error err;

  assert (h);
  err=h->selectContext (country,
			string(instcode ? instcode : ""),
			string(userid ? userid : ""));
  if (err.isOk())
    return 0;
  else
    return new HBCI_Error(err);
}
extern HBCI_Error * HBCI_Medium_getContext(const HBCI_Medium *h,
					   int num,
					   int *countrycode,
					   char **instcode,
					   char **userid,
					   char **server)
{
  assert(h);
  assert(countrycode);
  assert(instcode);
  assert(userid);
  assert(server);
  string instcode_str;
  string userid_str;
  string server_str;
  HBCI::Error err;

  err = h->getContext(num, *countrycode,
		      instcode_str, userid_str, server_str);
  if (err.isOk()) {
    *instcode = hbci_strdup (instcode_str);
    *userid = hbci_strdup (userid_str);
    *server = hbci_strdup (server_str);
    return 0;
  }
  return new HBCI_Error(err);
}




