/***************************************************************************
 $RCSfile: balance.cpp,v $
 -------------------
 cvs         : $Id: balance.cpp,v 1.4 2003/06/13 21:50:00 aquamaniac Exp $
 begin       : Tue Jun 12 2002
 copyright   : (C) 2002 by Martin Preuss
 email       : openhbci@aquamaniac.de


 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include <string>
#include "hbcistring.h"
#include "value.h"
#include "date.h"
#include "balance.h"
#include "assert.h"

namespace HBCI {

Balance::Balance():
    _debit(true)
{
}


Balance::~Balance(){
}


void Balance::dump() {
    if (_value.isValid())
	fprintf(stderr, "Value      : %f %s\n",
		_debit?(-_value.getValue()):_value.getValue(),
		_value.getCurrency().c_str());
    if (_date.isValid())
	fprintf(stderr, "Date       : %02d/%02d/%04d\n",
		_date.day(),_date.month(),_date.year());
    fprintf(stderr, "Time       : %02d:%02d:%02d\n",
	    _time.hour(),_time.minute(),_time.second());
}
} // namespace HBCI

int HBCI_Balance_isDebit(const HBCI_Balance *b)
{
    assert(b);
    return b->isDebit();
}
const HBCI_Value *HBCI_Balance_value(const HBCI_Balance *b)
{
    assert(b);
    return &(b->value());
}
const HBCI_Date *HBCI_Balance_date(const HBCI_Balance *b)
{
    assert(b);
    return &(b->date());
}
const HBCI_Time *HBCI_Balance_time(const HBCI_Balance *b)
{
    assert(b);
    return &(b->time());
}



namespace HBCI {

AccountBalance::AccountBalance(){
}


AccountBalance::~AccountBalance(){
}


void AccountBalance::dump() {
    fprintf(stderr, "Currency   : %s\n",_currency.c_str());
    fprintf(stderr, "Booked Balance:\n");
    _bookedBalance.dump();
    fprintf(stderr, "Noted Balance:\n");
    _notedBalance.dump();
    if (_bankLine.isValid())
        fprintf(stderr, "Credit Line: %f %s\n",
               _bankLine.getValue(),_bankLine.getCurrency().c_str());
    if (_disposable.isValid())
        fprintf(stderr, "Disposeable: %f %s\n",
               _disposable.getValue(),_disposable.getCurrency().c_str());
    if (_disposed.isValid())
        fprintf(stderr, "Disposed   : %f %s\n",
               _disposed.getValue(),_disposed.getCurrency().c_str());
    if (_date.isValid())
        fprintf(stderr, "Date       : %02d.%02d.%04d\n",
                _date.day(),_date.month(),_date.year());
    fprintf(stderr, "Time       : %02d:%02d:%02d\n",
            _time.hour(),_time.minute(),_time.second());
}

} // namespace HBCI

const char* 
HBCI_AccountBalance_currency(const HBCI_AccountBalance *b)
{
    assert(b);
    return b->currency().c_str();
}
const HBCI_Balance*
HBCI_AccountBalance_bookedBalance(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->bookedBalance());
}
const HBCI_Balance*
HBCI_AccountBalance_notedBalance(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->notedBalance());
}
const HBCI_Value*
HBCI_AccountBalance_bankLine(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->bankLine());
}
const HBCI_Value*
HBCI_AccountBalance_disposable(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->disposable());
}
const HBCI_Value*
HBCI_AccountBalance_disposed(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->disposed());
}
const HBCI_Date *
HBCI_AccountBalance_date(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->date());
}
const HBCI_Time *
HBCI_AccountBalance_time(const HBCI_AccountBalance *b)
{
    assert(b);
    return &(b->time());
}

