/***************************************************************************
 $RCSfile: directory.cpp,v $
                             -------------------
    cvs         : $Id: directory.cpp,v 1.3 2002/12/10 20:48:27 aquamaniac Exp $
    begin       : Tue Dec 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include <string>

#include "file.h"
#include "directory.h"

#ifndef PATH_MAX
# define PATH_MAX 256
#endif


namespace HBCI {

Directory::Directory(string name):_name(name),_dirh(DIR_NO_DIRHANDLE){
}


Directory::~Directory(){
    if (_dirh!=DIR_NO_DIRHANDLE)
        closedir(_dirh);
}


Error Directory::createDirectory(int mode){
    if (mkdir(_name.c_str(),mode))
        return Error("Directory::createDirectory()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       strerror(errno),
                       "at mkdir()");
    return Error();
}


Error Directory::openDirectory(){
    _dirh=opendir(_name.c_str());
    if (_dirh==DIR_NO_DIRHANDLE)
        return Error("Directory::openDirectory()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       strerror(errno),
                       "at opendir()");
    return Error();
}


Error Directory::readEntry(string &entry){
    struct dirent *d;

    d=readdir(_dirh);
    if (!d)
        return Error("Directory::readEntry()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       strerror(errno),
                       "at readdir()");
    entry=d->d_name;
    return Error();
}


Error Directory::closeDirectory(){
    int result;

    if (_dirh==DIR_NO_DIRHANDLE)
        return Error();
    result=closedir(_dirh);
    _dirh=0;
    if (result)
        return Error("Directory::closeDirectory()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       strerror(errno),
                       "at closedir()");
    return Error();
}


string Directory::workingDirectory(){
    char buffer[PATH_MAX];

    if (!getcwd(buffer,sizeof(buffer)))
        throw Error("Directory::workingDirectory()",
                      ERROR_LEVEL_NORMAL,
                      0,
                      ERROR_ADVISE_DONTKNOW,
                      strerror(errno),
                      "at getcwd()");
    return buffer;
}


Error Directory::setWorkingDirectory(string name){
    if (chdir(name.c_str()))
        return Error("Directory::setWorkingDirectory()",
                       ERROR_LEVEL_NORMAL,
                       0,
                       ERROR_ADVISE_DONTKNOW,
                       strerror(errno),
                       "at chdir()");
    return Error();
}


string Directory::homeDirectory(){
    struct passwd *p;

    p=getpwuid(getuid());
    if (!p)
        throw Error("Directory::homeDirectory()",
                      ERROR_LEVEL_NORMAL,
                      0,
                      ERROR_ADVISE_DONTKNOW,
                      strerror(errno),
                      "at getpwuid()");
    return p->pw_dir;
}

} /* namespace HBCI */
