MODULE VO:LEDPrefs;

(*
    Copyright (C) 2000  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT ISD := VO:Dlg:ImgSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       F   := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:LED,
       T   := VO:Text,
       TA  := VO:Tab,
       VI  := VO:VecImage;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                image : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="LED";

    d.SetPrefs(L.prefs);
    
    d.image:=V.CreateIntModel();
  END Init;


  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    frame  : F.FrameGroup;
    combo  : ISD.ImgSelCombo;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=F.CreateFrameGroup();
    frame.SetTextLabel("Image");

      combo:=ISD.CreateImgSelCombo();
      combo.SetModel(d.image);
    frame.SetObject(combo);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.Refresh^;

    p.image.SetLongint(L.prefs.image);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    L.prefs.image:=p.image.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;


  BEGIN
    p.LoadPrefs^(top);

    IF top.GetStringEntry("image",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        L.prefs.image:=pos;
      ELSE
        p.ErrorWrongData("image",buffer);
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("image",VI.images[L.prefs.image]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:LEDPrefs.