MODULE VO:TableViewPrefs;

(*
    Copyright (C) 2000  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       T   := VO:Text,
       TA  := VO:Tab,
       TV  := VO:TableView;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                focusFrame : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="TableView";

    d.SetPrefs(TV.prefs);

    d.focusFrame:=V.CreateIntModel();
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : FSD.FrmSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Frames");

      label:=L.CreateLabel();

      combo:=FSD.CreateFrmSelCombo();
      combo.SetModel(d.focusFrame);
      label.AddTextLabel("focus frame",combo);
    frame.SetObject(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.focusFrame.SetLongint(TV.prefs.focusFrame);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    TV.prefs.focusFrame:=p.focusFrame.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("focusFrame",top,TV.prefs.focusFrame);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("focusFrame",F.internalFrames[TV.prefs.focusFrame]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:TableViewPrefs.