MODULE VO:MenuPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       M   := VO:Menu,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                menuFrame,
                stripFrame : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Menu";

    d.SetPrefs(M.prefs);
           
    d.menuFrame:=V.CreateIntModel();
    d.stripFrame:=V.CreateIntModel();
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : FSD.FrmSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Frames");

      label:=L.CreateLabel();

        combo:=FSD.CreateFrmSelCombo();
        combo.SetModel(d.menuFrame);
      label.AddTextLabel("Menu",combo);

        combo:=FSD.CreateFrmSelCombo();
        combo.SetModel(d.stripFrame);
      label.AddTextLabel("Menustrip",combo);
    frame.SetObject(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.menuFrame.SetLongint(M.prefs.menuFrame);
    d.stripFrame.SetLongint(M.prefs.stripFrame);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    M.prefs.menuFrame:=p.menuFrame.GetLongint();
    M.prefs.stripFrame:=p.stripFrame.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("menuFrame",top,M.prefs.menuFrame);
    F.LoadFrame("stripFrame",top,M.prefs.stripFrame);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("menuFrame",F.internalFrames[M.prefs.menuFrame]);
    block.AddItemValue("stripFrame",F.internalFrames[M.prefs.stripFrame]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:MenuPrefs.