MODULE VO:HeaderPrefs;

(*
    Copyright (C) 2000  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,

       FSD := VO:Dlg:FrmSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       H   := VO:Header,
       L   := VO:Label,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                headerFrame : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Header";

    d.SetPrefs(H.prefs);

    NEW(d.headerFrame);
    d.headerFrame.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : FSD.FrmSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Frames");

      label:=L.CreateLabel();

      combo:=FSD.CreateFrmSelCombo();
      combo.SetModel(d.headerFrame);
      label.AddTextLabel("header frame",combo);
    frame.SetObject(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.headerFrame.SetLongint(H.prefs.headerFrame);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    H.prefs.headerFrame:=p.headerFrame.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("headerFrame",top,H.prefs.headerFrame);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("headerFrame",F.internalFrames[H.prefs.headerFrame]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:HeaderPrefs.