MODULE VO:Base:DisplayPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VO:Base:Display,

       V   := VO:Model:Value,

       PG  := VO:Prefs:GUI,
       PP  := VO:Prefs:Parser,

       C   := VO:ColorArea,
       G   := VO:Object,
       LA  := VO:Label,
       ST  := VO:String,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  DisplayItem*     = POINTER TO DisplayItemDesc;
  DisplayItemDesc* = RECORD (PG.PrefsItemDesc)
                     END;

VAR
  prefs : DisplayItem;

  PROCEDURE (d : DisplayItem) Init*;

  BEGIN
    d.Init^;
    d.name:="Display";
  END Init;

  PROCEDURE (d : DisplayItem) GetObject*():G.Object;

  VAR
    tab    : TA.Tab;
    label  : LA.Label;
    area   : C.ColorArea;
    string : ST.String;
    model  : V.ValueModel;
    x      : LONGINT;

  BEGIN
    NEW(tab);
    tab.Init;
    tab.SetFlags({G.horizontalFlex,G.verticalFlex});

      NEW(label);
      label.Init;
      label.SetFlags({G.horizontalFlex,G.verticalFlex});

      FOR x:=0 TO LEN(D.colorNames)-1 DO
        NEW(model);
        model.Init;
        model.SetString(D.prefs.colors[x]);

          area:=C.CreateColorArea();
          area.SetFlags({G.horizontalFlex,G.verticalFlex});
          area.SetColor(D.GetColorEntry(D.colorNames[x]));
        label.AddTextLabel(D.colorNames[x],area);
      END;

    tab.AddTab(T.MakeCenterText("Colors"),label);

      NEW(label);
      label.Init;
      label.SetFlags({G.horizontalFlex,G.verticalFlex});

      FOR x:=0 TO LEN(D.fontNames)-1 DO
        NEW(model);
        model.Init;
        model.SetString(D.prefs.fonts[x]);

        NEW(string);
        string.Init;
        string.Disable(TRUE);
        string.SetFlags({G.horizontalFlex});
        string.SetModel(model);

        label.AddTextLabel(D.fontNames[x],string);
      END;

    tab.AddTab(T.MakeCenterText("Fonts"),label);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : DisplayItem) Refresh*;

  BEGIN

  END Refresh;

  PROCEDURE (p : DisplayItem) LoadPrefs*(top : PP.Item);

  VAR
    x   : LONGINT;
    sub : PP.Item;

  BEGIN
    sub:=top.GetEntry("Colors");
    IF sub#NIL THEN
      FOR x:=0 TO D.colorCount-1 DO
        IF sub.GetStringEntry(D.colorNames[x],D.prefs.colors[x]) THEN END;
      END;
    END;
    sub:=top.GetEntry("Fonts");
    IF sub#NIL THEN
      FOR x:=0 TO D.fontCount-1 DO
        IF sub.GetStringEntry(D.fontNames[x],D.prefs.fonts[x]) THEN END;
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : DisplayItem) SavePrefs*(block : PP.BlockItem);

  VAR
    block2,
    block3   : PP.BlockItem;
    x        : LONGINT;

  BEGIN
    NEW(block2);
    block2.Init;

    block.AddItem(block2);

    block2.SetName("Colors");
    FOR x:=0 TO D.colorCount-1 DO
      block2.AddItemValue(D.colorNames[x],D.prefs.colors[x]);
    END;

    NEW(block3);
    block3.Init;
    block3.SetName("Fonts");
    block2.next:=block3;
    FOR x:=0 TO D.fontCount-1 DO
      block3.AddItemValue(D.fontNames[x],D.prefs.fonts[x]);
    END;
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:Base:DisplayPrefs.