MODULE VO:SliderPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT F   := VO:Base:Frame,
       Z   := VO:Base:Size,

       ISD := VO:Dlg:ImgSel,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       FG  := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       S   := VO:Slider,
       T   := VO:Text,
       TA  := VO:Tab,
       VI  := VO:VecImage;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                hImage,
                vImage  : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Slider";

    d.SetPrefs(S.prefs);

    NEW(d.hImage);
    d.hImage.Init;
    NEW(d.vImage);
    d.vImage.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    combo  : ISD.ImgSelCombo;
    frame  : FG.FrameGroup;
    label  : L.Label;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=FG.CreateFrameGroup();
    frame.SetTextLabel("Image");

      label:=L.CreateLabel();

        combo:=ISD.CreateImgSelCombo();
        combo.SetModel(d.hImage);
      label.AddTextLabel("horizontal",combo);

        combo:=ISD.CreateImgSelCombo();
        combo.SetModel(d.vImage);
      label.AddTextLabel("vertical",combo);
    frame.SetObject(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.Refresh^;

    p.hImage.SetLongint(S.prefs.hKnob);
    p.vImage.SetLongint(S.prefs.vKnob);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    S.prefs.hKnob:=p.hImage.GetLongint();
    S.prefs.vKnob:=p.vImage.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;


  BEGIN
    p.LoadPrefs^(top);

    F.LoadFrame("boxFrame",top,S.prefs.boxFrame);

    IF top.GetStringEntry("hImage",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.hKnob:=pos;
      ELSE
        p.ErrorWrongData("hImage",buffer);
      END;
    END;
    IF top.GetStringEntry("vImage",buffer) THEN
      pos:=VI.GetImageEntry(buffer);
      IF pos>=0 THEN
        S.prefs.vKnob:=pos;
      ELSE
        p.ErrorWrongData("vImage",buffer);
      END;
    END;

    S.prefs.fill:=top.GetBoolEntry("fill",S.prefs.fill);

    Z.LoadSize("hSpace",top,S.prefs.hSpace);
    Z.LoadSize("vSpace",top,S.prefs.vSpace);
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    block.AddItemValue("hImage",VI.images[S.prefs.hKnob]);
    block.AddItemValue("vImage",VI.images[S.prefs.vKnob]);
    block.AddItemValue("boxFrame",F.internalFrames[S.prefs.boxFrame]);
    block.AddItemBool("fill",S.prefs.fill);
    Z.SaveSize("hSpace",block,S.prefs.hSpace);
    Z.SaveSize("vSpace",block,S.prefs.vSpace);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:SliderPrefs.