(**
   Implements horizontal and vertical scrollers.

  TODO
  * Support for prior, next, home, end
**)

MODULE VO:Scroller;

(*
    Implements a scroll gadget.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT A  := VO:Base:Adjustment,
       E  := VO:Base:Event,
       F  := VO:Base:Frame,
       O  := VO:Base:Object,

       B  := VO:Button,
       G  := VO:Object,
       K  := VO:Knob,
       PA := VO:Panel,
       V  := VO:VecImage;


CONST
(*  repeatTimeOut = 75000;*) (* Time between button repeat *)

TYPE
  Prefs*     = POINTER TO PrefsDesc;

  (**
    In this class all preferences stuff of the cycle is stored.
  **)


  PrefsDesc* = RECORD (G.PrefsDesc)
                 up*,
                 down*,
                 left*,
                 right* : LONGINT;
               END;

  Scroller*     = POINTER TO ScrollerDesc;
  ScrollerDesc* = RECORD (G.GadgetDesc)
                    panel      : PA.Panel;
                    knob       : K.Knob;
                    adjustment : A.Adjustment;
                    vert       : BOOLEAN;
                  END;
VAR
  prefs* : Prefs;

  PROCEDURE (p : Prefs) Init*;

  BEGIN
    p.Init^;

    p.frame:=F.none;
    p.up:=V.w95Up;
    p.down:=V.w95Down;
    p.left:=V.w95Left;
    p.right:=V.w95Right;
  END Init;


  PROCEDURE (s : Scroller) Init*;

  BEGIN
    s.Init^;

    s.SetPrefs(prefs);

    s.SetFlags({G.canFocus});

    s.vert:=TRUE;

    s.adjustment:=NIL;

    s.panel:=NIL;

    NEW(s.knob);
    s.knob.Init;
    s.knob.SetFlags({G.horizontalFlex,G.verticalFlex});
  END Init;

  PROCEDURE (s : Scroller) Set*(vert : BOOLEAN);

  BEGIN
    s.vert:=vert;

    s.knob.Set(vert);
  END Set;

  PROCEDURE (s : Scroller) SetOffset*(offset : LONGINT);

  BEGIN
    s.knob.SetOffset(offset);
  END SetOffset;

  PROCEDURE (s : Scroller) SetModel*(model : O.Model);

  BEGIN
    IF s.adjustment#NIL THEN
      s.UnattachModel(s.adjustment.GetTopModel());
      s.UnattachModel(s.adjustment.GetVisibleModel());
      s.UnattachModel(s.adjustment.GetTotalModel())
    END;
    IF (model#NIL) & (model IS A.Adjustment) THEN
      s.adjustment:=model(A.Adjustment);
      s.AttachModel(s.adjustment.GetTopModel());
      s.AttachModel(s.adjustment.GetVisibleModel());
      s.AttachModel(s.adjustment.GetTotalModel());
    END;

    s.knob.SetModel(model);
  END SetModel;

  (**
    This function is used to check if an argument to SetModel
    was successfully accepted.
   **)

  PROCEDURE (s : Scroller) ModelAccepted * (m : O.Model):BOOLEAN;

  BEGIN
    RETURN m=s.adjustment
  END ModelAccepted;


  PROCEDURE (s : Scroller) CalcSize*;

    PROCEDURE CreateButton(action : LONGINT):B.Button;

    VAR
      button    : B.Button;
      image     : V.VecImage;
      converter : O.ActionConverter;

    BEGIN
      NEW(button);
      button.Init;
      button.SetType(B.image);
      IF s.vert THEN
        button.SetFlags({G.horizontalFlex});
      ELSE
        button.SetFlags({G.verticalFlex});
      END;
      button.SetPulse(TRUE);

      NEW(image);
      image.Init;
      image.SetFlags({G.horizontalFlex,G.verticalFlex});
      IF action=K.decAction THEN
        IF s.vert THEN
          image.Set(s.prefs(Prefs).up);
        ELSE
          image.Set(s.prefs(Prefs).left);
        END;
      ELSE
        image.SetFlags({G.horizontalFlex,G.verticalFlex});
        IF s.vert THEN
          image.Set(s.prefs(Prefs).down);
        ELSE
          image.Set(s.prefs(Prefs).right);
        END;
      END;
      button.SetImage(image);

      NEW(converter);
      converter.destination:=s.knob;
      converter.action:=action;
      button.AddHandler(converter,B.pressedMsg);

      RETURN button;
    END CreateButton;

  BEGIN
    NEW(s.panel);
    s.panel.Init;
    s.panel.SetParent(s);

    IF s.vert THEN
      s.panel.Set(PA.vertical);
      s.panel.SetFlags({G.verticalFlex});
    ELSE
      s.panel.Set(PA.horizontal);
      s.panel.SetFlags({G.horizontalFlex});
    END;

    s.panel.Add(CreateButton(K.decAction));
    s.panel.Add(CreateButton(K.incAction));

    s.panel.Add(s.knob);

    s.panel.Add(CreateButton(K.decAction));
    s.panel.Add(CreateButton(K.incAction));

    s.panel.CalcSize;

    s.minWidth:=s.panel.oMinWidth;
    s.minHeight:=s.panel.oMinHeight;

    s.width:=s.panel.oWidth;
    s.height:=s.panel.oHeight;

    s.CalcSize^;
  END CalcSize;



  PROCEDURE (s : Scroller) HandleMouseEvent*(event : E.MouseEvent;
                                             VAR grab : G.Object):BOOLEAN;

  BEGIN
    IF ~s.visible OR s.disabled THEN
      RETURN FALSE;
    ELSE
      RETURN s.panel.HandleMouseEvent(event,grab);
    END;
  END HandleMouseEvent;

(*
  PROCEDURE (s : Scroller) Receive*(message : O.Message);

  BEGIN
    WITH
      message : B.PressedMsg DO
      IF message.source=s.minus THEN
        IF s.adjustment.GetTop()+s.corr>1 THEN
          s.adjustment.DecTop;
        END;
      ELSE
        IF s.adjustment.GetTop()+s.corr<=s.adjustment.GetTotal()+s.corr-s.adjustment.GetVisible() THEN
          s.adjustment.IncTop;
        END;
      END;
    ELSE
      s.Receive^(message);
    END;
  END Receive;
*)

  PROCEDURE (s : Scroller) Draw*(x,y,w,h : LONGINT);

  BEGIN
    s.Draw^(x,y,w,h);

    IF ~s.Intersect(x,y,w,h) THEN
      RETURN;
    END;

    s.panel.MoveResize(s.x,s.y,s.width,s.height);
    s.panel.Move(s.panel.oX,s.panel.oY);
    s.panel.Draw(x,y,w,h);

    IF s.disabled THEN
      s.DrawDisabled;
    END;
  END Draw;


  PROCEDURE (s : Scroller) Hide*;

  BEGIN
    IF s.visible THEN
      s.panel.Hide;
      s.Hide^;
    END;
  END Hide;

(*  PROCEDURE (s : Scroller) Resync*(model : O.Model; msg : O.ResyncMsg);

  BEGIN
    IF s.visible & ~s.disabled THEN
      s.DrawKnob;
    END;
  END Resync;*)

  PROCEDURE CreateScroller*():Scroller;

  VAR
    scroller : Scroller;

  BEGIN
    NEW(scroller);
    scroller.Init;

    RETURN scroller;
  END CreateScroller;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:Scroller.