use NetAddr::IP;

my %w = ('broadcast'	=> [ '255.255.255.255', '255.255.255.255' ],
	 'default'	=> [ '0.0.0.0', '0.0.0.0' ],
	 'loopback'	=> [ '127.0.0.1', '255.0.0.0' ],
	 '10.'		=> [ '10.0.0.0', '255.0.0.0' ],
	 '11.11.'	=> [ '11.11.0.0', '255.255.0.0' ],
	 '12.12.12.'	=> [ '12.12.12.0', '255.255.255.0' ],
	 '13.13.13.13'	=> [ '13.13.13.13', '255.255.255.255' ],
	 '0-127'	=> [ '0.0.0.0', '128.0.0.0' ],
	 '128-255'	=> [ '128.0.0.0', '128.0.0.0' ],
	 '0-63'		=> [ '0.0.0.0', '192.0.0.0' ],
	 '128-191'	=> [ '128.0.0.0', '192.0.0.0' ],
	 '10.128.0-127'	=> [ '10.128.0.0', '255.255.128.0' ],
	 '10.10.10/24'	=> [ '10.10.10.0', '255.255.255.0' ],
	 '10.10/16'	=> [ '10.10.0.0', '255.255.0.0' ],
	 '10.10.10'	=> [ '10.10.0.10', '255.255.255.255' ],
	 );

$| = 1;

print '1..', (2 * scalar keys %w), "\n";

my $count = 1;

for my $a (keys %w) {
    my $ip = new NetAddr::IP $a;

    if ($ip->addr eq $w{$a}->[0]) {
	print "ok ", $count++, "\n";
    }
    else {
	print "not ok ", $count++, "\n";
    }

    if ($ip->mask eq $w{$a}->[1]) {
	print "ok ", $count++, "\n";
    }
    else {
	print "not ok ", $count++, "\n";
    }
}
