/*  $Id: tlesson.c,v 1.5 2004/10/05 08:17:39 marcusva Exp $
 *  
 *  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2004 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "lingoteach.h"
#include <stdio.h>
#include <string.h>

#define FOK() fprintf(stdout,"Ok\n")


int 
main (int argc, char *argv[])
{
     lingConfig *settings = NULL;
     lingLesson *lessons[] = { NULL };
     lingLesson *less = NULL;
     lingLesson *list = NULL;
     char *path = NULL;
     int i = 0;
     int j = 0;
     
     if (argc < 6)
     {
	  fprintf (stdout, "Usage: %s name lang_dtd, lesson_dtd "
			   "languagefile lessons\n", argv[0]);
	  return -1;
     }

     /* get the settings */
     settings = ling_conf_init_config (argv[1], argv[4], argv[2], argv[3]);
     if (settings == NULL)
     {
	  fprintf (stdout, "Error: settings not initialized!\n");
	  return -1;
     }

     /* add lessons */
     j = 0;
     fprintf (stdout, "%i Lessons given...\n\n", argc - 5);
     fprintf (stdout, "Testing ling_lesson_create_lesson()...");
     for (i = 3; i < argc; i++, j++)
     {
	  lessons[j] = ling_lesson_create (argv[i], settings);
	  if (lessons[j] == NULL)
	  {
	       fprintf (stdout, "Error: could not add file %s!\n", argv[i]);
	       return -1;
	  }
     }
     FOK ();

     /* add lessons to a list */
     list = lessons[0];
     fprintf (stdout, "Testing ling_lesson_add_lesson ()...");
     for (i = 3; i < argc; i++)
     {
	  list = ling_lesson_add (list, lessons[i - 3]);
	  if (list == NULL)
	  {
	       fprintf (stdout, "Error: could not append lesson %s!\n", 
			argv[i]);
	       return -1;
	  }
     }
     FOK();
     
     /* Dump list */
     less = list;
     fprintf (stdout, "Dumping list...\n");
     while (less != NULL)
     {
	  fprintf (stdout, "%s, %s\n", less->type, less->sound);
	  less = less->next;
     }

     /* check the paths */
     less = list;
     i = 3;
     fprintf (stdout, "Testing ling_lesson_return_path ()... ");
     while (less != NULL && i < argc)
     {
	  path = ling_lesson_get_path (less);
	  if (strcmp (path, argv[i]) != 0)
	  {
	       fprintf (stdout, "Error: Path mismatch: %s <-> %s!\n",
			path, argv[i]);
	       return -1;
	  }
	  less = less->next;
	  i++;
     }
     fprintf (stdout, "All paths OK.\n");
     fprintf (stdout, "All lesson tests OK.\n");
     fprintf (stdout, "Cleaning up...");
     ling_conf_free_config (settings);
     FOK ();

     return 0;
}
