/* multiplexer.c generated by valac 0.14.2, the Vala compiler
 * generated from multiplexer.vala, do not modify */

/*
 * This file is part of libgsm0710mux
 *
 * (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */
/*===========================================================================*/

#include <glib.h>
#include <glib-object.h>
#include <gsm/gsm0710.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <fsotransport.h>
#include <errno.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MULTIPLEXER (multiplexer_get_type ())
#define MULTIPLEXER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTIPLEXER, Multiplexer))
#define MULTIPLEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTIPLEXER, MultiplexerClass))
#define IS_MULTIPLEXER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTIPLEXER))
#define IS_MULTIPLEXER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTIPLEXER))
#define MULTIPLEXER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTIPLEXER, MultiplexerClass))

typedef struct _Multiplexer Multiplexer;
typedef struct _MultiplexerClass MultiplexerClass;
#define _multiplexer_unref0(var) ((var == NULL) ? NULL : (var = (multiplexer_unref (var), NULL)))
typedef struct _MultiplexerPrivate MultiplexerPrivate;

#define GSM0710MUX_TYPE_MANAGER (gsm0710mux_manager_get_type ())
#define GSM0710MUX_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManager))
#define GSM0710MUX_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManagerClass))
#define GSM0710MUX_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSM0710MUX_TYPE_MANAGER))
#define GSM0710MUX_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSM0710MUX_TYPE_MANAGER))
#define GSM0710MUX_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSM0710MUX_TYPE_MANAGER, Gsm0710muxManagerClass))

typedef struct _Gsm0710muxManager Gsm0710muxManager;
typedef struct _Gsm0710muxManagerClass Gsm0710muxManagerClass;

#define TYPE_CHANNEL (channel_get_type ())
#define CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHANNEL, Channel))
#define CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHANNEL, ChannelClass))
#define IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHANNEL))
#define IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHANNEL))
#define CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHANNEL, ChannelClass))

typedef struct _Channel Channel;
typedef struct _ChannelClass ChannelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gsm0710_context_free0(var) ((var == NULL) ? NULL : (var = (gsm0710_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _gsm0710mux_channel_info_unref0(var) ((var == NULL) ? NULL : (var = (gsm0710mux_channel_info_unref (var), NULL)))

#define GSM0710MUX_TYPE_CHANNEL_INFO (gsm0710mux_channel_info_get_type ())
#define GSM0710MUX_CHANNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfo))
#define GSM0710MUX_CHANNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfoClass))
#define GSM0710MUX_IS_CHANNEL_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSM0710MUX_TYPE_CHANNEL_INFO))
#define GSM0710MUX_IS_CHANNEL_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSM0710MUX_TYPE_CHANNEL_INFO))
#define GSM0710MUX_CHANNEL_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSM0710MUX_TYPE_CHANNEL_INFO, Gsm0710muxChannelInfoClass))

typedef struct _Gsm0710muxChannelInfo Gsm0710muxChannelInfo;
typedef struct _Gsm0710muxChannelInfoClass Gsm0710muxChannelInfoClass;
typedef struct _Gsm0710muxChannelInfoPrivate Gsm0710muxChannelInfoPrivate;
typedef struct _Gsm0710muxManagerPrivate Gsm0710muxManagerPrivate;
#define _channel_unref0(var) ((var == NULL) ? NULL : (var = (channel_unref (var), NULL)))
typedef struct _multiplexer_allocChannelData multiplexer_allocChannelData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecMultiplexer ParamSpecMultiplexer;

struct _Multiplexer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MultiplexerPrivate * priv;
};

struct _MultiplexerClass {
	GTypeClass parent_class;
	void (*finalize) (Multiplexer *self);
};

struct _MultiplexerPrivate {
	Gsm0710muxManager* manager;
	gchar* portname;
	gchar* porttype;
	gint portspeed;
	FsoFrameworkLogger* logger;
	struct gsm0710_context* ctx;
	guint pingwatch;
	GTimer* idle_wakeup_timer;
	guint idle_wakeup_threshold;
	guint idle_wakeup_waitms;
	GTimer* send_pause_timer;
	guint send_pause_threshold;
	Channel** vc;
	gint vc_length1;
	gint _vc_size_;
	FsoFrameworkTransport* transport;
};

typedef enum  {
	GSM0710MUX_MUXER_ERROR_CHANNEL_TAKEN,
	GSM0710MUX_MUXER_ERROR_INVALID_CHANNEL,
	GSM0710MUX_MUXER_ERROR_INVALID_TRANSPORT,
	GSM0710MUX_MUXER_ERROR_NO_SESSION,
	GSM0710MUX_MUXER_ERROR_NO_CHANNEL,
	GSM0710MUX_MUXER_ERROR_SESSION_ALREADY_OPEN,
	GSM0710MUX_MUXER_ERROR_SESSION_OPEN_ERROR
} Gsm0710muxMuxerError;
#define GSM0710MUX_MUXER_ERROR gsm0710mux_muxer_error_quark ()
struct _Gsm0710muxChannelInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	Gsm0710muxChannelInfoPrivate * priv;
	gchar* consumer;
	gint number;
	FsoFrameworkTransport* transport;
};

struct _Gsm0710muxChannelInfoClass {
	GTypeClass parent_class;
	void (*finalize) (Gsm0710muxChannelInfo *self);
};

struct _Gsm0710muxManager {
	GObject parent_instance;
	Gsm0710muxManagerPrivate * priv;
	guint channel_ack_timeout;
};

struct _Gsm0710muxManagerClass {
	GObjectClass parent_class;
};

struct _multiplexer_allocChannelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Multiplexer* self;
	Gsm0710muxChannelInfo* info;
	gint result;
	FsoFrameworkLogger* _tmp0_;
	Gsm0710muxChannelInfo* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	Gsm0710muxChannelInfo* _tmp8_;
	gint _tmp9_;
	gint i;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	Channel** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	Channel* _tmp16_;
	Gsm0710muxChannelInfo* _tmp17_;
	gint _tmp18_;
	Channel** _tmp19_;
	gint _tmp19__length1;
	Gsm0710muxChannelInfo* _tmp20_;
	gint _tmp21_;
	Channel* _tmp22_;
	Gsm0710muxChannelInfo* _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _tmp29_;
	GError* _tmp30_;
	struct gsm0710_context* _tmp31_;
	Gsm0710muxChannelInfo* _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	gboolean ok;
	FsoFrameworkLogger* _tmp35_;
	gboolean _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	Gsm0710muxChannelInfo* _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GError* _tmp49_;
	GError* _tmp50_;
	Channel** _tmp51_;
	gint _tmp51__length1;
	Gsm0710muxChannelInfo* _tmp52_;
	gint _tmp53_;
	Gsm0710muxChannelInfo* _tmp54_;
	Gsm0710muxManager* _tmp55_;
	guint _tmp56_;
	Channel* _tmp57_;
	Channel* _tmp58_;
	Channel** _tmp59_;
	gint _tmp59__length1;
	Gsm0710muxChannelInfo* _tmp60_;
	gint _tmp61_;
	Channel* _tmp62_;
	gboolean _tmp63_;
	Channel** _tmp64_;
	gint _tmp64__length1;
	Gsm0710muxChannelInfo* _tmp65_;
	gint _tmp66_;
	Channel* _tmp67_;
	gchar* _tmp68_;
	gchar* path;
	FsoFrameworkLogger* _tmp69_;
	Gsm0710muxChannelInfo* _tmp70_;
	gint _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gboolean _tmp78_;
	Gsm0710muxChannelInfo* _tmp79_;
	gint _tmp80_;
	FsoFrameworkLogger* _tmp81_;
	Gsm0710muxChannelInfo* _tmp82_;
	gint _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_;
	Channel** _tmp89_;
	gint _tmp89__length1;
	Gsm0710muxChannelInfo* _tmp90_;
	gint _tmp91_;
	Channel* _tmp92_;
	GError* _tmp93_;
	GError * _inner_error_;
};

struct _ParamSpecMultiplexer {
	GParamSpec parent_instance;
};


static gpointer multiplexer_parent_class = NULL;
extern gboolean gsm0710mux_manager_leave_mux_alone;

gboolean at_command_fwd (struct gsm0710_context* ctx, const gchar* command);
gpointer multiplexer_ref (gpointer instance);
void multiplexer_unref (gpointer instance);
GParamSpec* param_spec_multiplexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_multiplexer (GValue* value, gpointer v_object);
void value_take_multiplexer (GValue* value, gpointer v_object);
gpointer value_get_multiplexer (const GValue* value);
GType multiplexer_get_type (void) G_GNUC_CONST;
gboolean multiplexer_at_command (Multiplexer* self, const gchar* command);
gint read_fwd (struct gsm0710_context* ctx, void* data, gint len);
gint multiplexer_read (Multiplexer* self, void* data, gint len);
gboolean write_fwd (struct gsm0710_context* ctx, void* data, gint len);
gboolean multiplexer_write (Multiplexer* self, void* data, gint len);
void deliver_data_fwd (struct gsm0710_context* ctx, gint channel, void* data, gint len);
void multiplexer_deliver_data (Multiplexer* self, gint channel, void* data, gint len);
void deliver_status_fwd (struct gsm0710_context* ctx, gint channel, gint status);
void multiplexer_deliver_status (Multiplexer* self, gint channel, gint serial_status);
void debug_message_fwd (struct gsm0710_context* ctx, const gchar* msg);
void multiplexer_debug_message (Multiplexer* self, const gchar* msg);
void open_channel_fwd (struct gsm0710_context* ctx, gint channel);
void multiplexer_open_channel (Multiplexer* self, gint channel);
void close_channel_fwd (struct gsm0710_context* ctx, gint channel);
void multiplexer_close_channel (Multiplexer* self, gint channel);
void terminate_fwd (struct gsm0710_context* ctx);
void multiplexer_terminate (Multiplexer* self);
void response_to_test_fwd (struct gsm0710_context* ctx, gchar* data, int data_length1);
void multiplexer_response_to_test (Multiplexer* self, gchar* data, int data_length1);
GType gsm0710mux_manager_get_type (void) G_GNUC_CONST;
gpointer channel_ref (gpointer instance);
void channel_unref (gpointer instance);
GParamSpec* param_spec_channel (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_channel (GValue* value, gpointer v_object);
void value_take_channel (GValue* value, gpointer v_object);
gpointer value_get_channel (const GValue* value);
GType channel_get_type (void) G_GNUC_CONST;
#define MULTIPLEXER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MULTIPLEXER, MultiplexerPrivate))
enum  {
	MULTIPLEXER_DUMMY_PROPERTY
};
Multiplexer* multiplexer_new (gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager);
Multiplexer* multiplexer_construct (GType object_type, gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager);
static gboolean _at_command_fwd_gsm0710at_command_t (struct gsm0710_context* ctx, const gchar* command);
static gint _read_fwd_gsm0710read_t (struct gsm0710_context* ctx, void* data, gint len);
static gboolean _write_fwd_gsm0710write_t (struct gsm0710_context* ctx, void* data, gint len);
static void _deliver_data_fwd_gsm0710deliver_data_t (struct gsm0710_context* ctx, gint channel, void* data, gint len);
static void _deliver_status_fwd_gsm0710deliver_status_t (struct gsm0710_context* ctx, gint channel, gint status);
static void _debug_message_fwd_gsm0710debug_message_t (struct gsm0710_context* ctx, const gchar* msg);
static void _open_channel_fwd_gsm0710open_channel_t (struct gsm0710_context* ctx, gint channel);
static void _close_channel_fwd_gsm0710close_channel_t (struct gsm0710_context* ctx, gint channel);
static void _terminate_fwd_gsm0710terminate_t (struct gsm0710_context* ctx);
static void _response_to_test_fwd_gsm0710response_to_test_t (struct gsm0710_context* ctx, gchar* data, int data_length1);
#define CONST_LIBGSM0710MUX_CONFIG_SECTION "libgsm0710mux"
#define CONST_LIBGSM0710MUX_LOGGING_DOMAIN "libgsm0710mux"
gchar* multiplexer_repr (Multiplexer* self);
static gchar* _multiplexer_repr_repr_delegate (gpointer self);
gboolean multiplexer_initSession (Multiplexer* self);
gboolean multiplexer_openTransport (Multiplexer* self);
void multiplexer_closeSession (Multiplexer* self);
void channel_close (Channel* self);
static void multiplexer_allocChannel_data_free (gpointer _data);
gpointer gsm0710mux_channel_info_ref (gpointer instance);
void gsm0710mux_channel_info_unref (gpointer instance);
GParamSpec* gsm0710mux_param_spec_channel_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gsm0710mux_value_set_channel_info (GValue* value, gpointer v_object);
void gsm0710mux_value_take_channel_info (GValue* value, gpointer v_object);
gpointer gsm0710mux_value_get_channel_info (const GValue* value);
GType gsm0710mux_channel_info_get_type (void) G_GNUC_CONST;
GQuark gsm0710mux_muxer_error_quark (void);
void multiplexer_allocChannel (Multiplexer* self, Gsm0710muxChannelInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_);
gint multiplexer_allocChannel_finish (Multiplexer* self, GAsyncResult* _res_, GError** error);
static gboolean multiplexer_allocChannel_co (multiplexer_allocChannelData* _data_);
void multiplexer_wakeupIfNecessary (Multiplexer* self);
static gboolean _multiplexer_allocChannel_co_gsource_func (gpointer self);
Channel* channel_new (Multiplexer* multiplexer, Gsm0710muxChannelInfo* info, GSourceFunc ackCallback, void* ackCallback_target, guint ackTimeout);
Channel* channel_construct (GType object_type, Multiplexer* multiplexer, Gsm0710muxChannelInfo* info, GSourceFunc ackCallback, void* ackCallback_target, guint ackTimeout);
gboolean channel_isAcked (Channel* self);
gchar* channel_path (Channel* self);
void multiplexer_releaseChannel (Multiplexer* self, const gchar* name, GError** error);
gchar* channel_name (Channel* self);
void gsm0710mux_manager_channelsHaveBeenClosed (Gsm0710muxManager* self, gint num);
void multiplexer_setStatus (Multiplexer* self, gint channel, const gchar* status, GError** error);
gint multiplexer_stringToSerialStatus (Multiplexer* self, const gchar* status);
void multiplexer_setWakeupThreshold (Multiplexer* self, guint seconds, guint waitms, GError** error);
void multiplexer_setSendPauseThreshold (Multiplexer* self, guint ms);
void multiplexer_testCommand (Multiplexer* self, guint8* data, int data_length1);
void multiplexer_onReadFromTransport (Multiplexer* self, FsoFrameworkTransport* transport);
static void _multiplexer_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
void multiplexer_onHupFromTransport (Multiplexer* self, FsoFrameworkTransport* transport);
static void _multiplexer_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
gchar* multiplexer_serialStatusToString (Multiplexer* self, gint status);
void multiplexer_clearPingResponseTimeout (Multiplexer* self);
static void multiplexer_sleepIfNecessary (Multiplexer* self);
void multiplexer_submit_data (Multiplexer* self, gint channel, void* data, gint len);
void multiplexer_channel_closed (Multiplexer* self, gint channel);
void multiplexer_remove_channel (Multiplexer* self, gint channel);
void const_hexdump (gboolean write, void* data, gint len, FsoFrameworkLogger* logger);
void channel_deliverData (Channel* self, void* data, gint len);
gchar* channel_acked (Channel* self);
void channel_setSerialStatus (Channel* self, gint newstatus);
static void multiplexer_finalize (Multiplexer* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _multiplexer_ref0 (gpointer self) {
	return self ? multiplexer_ref (self) : NULL;
}


gboolean at_command_fwd (struct gsm0710_context* ctx, const gchar* command) {
	gboolean result = FALSE;
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (ctx != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = command;
	_tmp4_ = multiplexer_at_command (m, _tmp3_);
	result = _tmp4_;
	_multiplexer_unref0 (m);
	return result;
}


gint read_fwd (struct gsm0710_context* ctx, void* data, gint len) {
	gint result = 0;
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	void* _tmp3_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	g_return_val_if_fail (ctx != NULL, 0);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = len;
	_tmp5_ = multiplexer_read (m, _tmp3_, _tmp4_);
	result = _tmp5_;
	_multiplexer_unref0 (m);
	return result;
}


gboolean write_fwd (struct gsm0710_context* ctx, void* data, gint len) {
	gboolean result = FALSE;
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	void* _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = len;
	_tmp5_ = multiplexer_write (m, _tmp3_, _tmp4_);
	result = _tmp5_;
	_multiplexer_unref0 (m);
	return result;
}


void deliver_data_fwd (struct gsm0710_context* ctx, gint channel, void* data, gint len) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	gint _tmp3_;
	void* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = channel;
	_tmp4_ = data;
	_tmp5_ = len;
	multiplexer_deliver_data (m, _tmp3_, _tmp4_, _tmp5_);
	_multiplexer_unref0 (m);
}


void deliver_status_fwd (struct gsm0710_context* ctx, gint channel, gint status) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = channel;
	_tmp4_ = status;
	multiplexer_deliver_status (m, _tmp3_, _tmp4_);
	_multiplexer_unref0 (m);
}


void debug_message_fwd (struct gsm0710_context* ctx, const gchar* msg) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	const gchar* _tmp3_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = msg;
	multiplexer_debug_message (m, _tmp3_);
	_multiplexer_unref0 (m);
}


void open_channel_fwd (struct gsm0710_context* ctx, gint channel) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	gint _tmp3_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = channel;
	multiplexer_open_channel (m, _tmp3_);
	_multiplexer_unref0 (m);
}


void close_channel_fwd (struct gsm0710_context* ctx, gint channel) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	gint _tmp3_;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = channel;
	multiplexer_close_channel (m, _tmp3_);
	_multiplexer_unref0 (m);
}


void terminate_fwd (struct gsm0710_context* ctx) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	multiplexer_terminate (m);
	_multiplexer_unref0 (m);
}


void response_to_test_fwd (struct gsm0710_context* ctx, gchar* data, int data_length1) {
	struct gsm0710_context* _tmp0_;
	void* _tmp1_;
	Multiplexer* _tmp2_;
	Multiplexer* m;
	gchar* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = ctx;
	_tmp1_ = _tmp0_->user_data;
	_tmp2_ = _multiplexer_ref0 (MULTIPLEXER (_tmp1_));
	m = _tmp2_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	multiplexer_response_to_test (m, _tmp3_, _tmp3__length1);
	_multiplexer_unref0 (m);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _at_command_fwd_gsm0710at_command_t (struct gsm0710_context* ctx, const gchar* command) {
	gboolean result;
	result = at_command_fwd (ctx, command);
	return result;
}


static gint _read_fwd_gsm0710read_t (struct gsm0710_context* ctx, void* data, gint len) {
	gint result;
	result = read_fwd (ctx, data, len);
	return result;
}


static gboolean _write_fwd_gsm0710write_t (struct gsm0710_context* ctx, void* data, gint len) {
	gboolean result;
	result = write_fwd (ctx, data, len);
	return result;
}


static void _deliver_data_fwd_gsm0710deliver_data_t (struct gsm0710_context* ctx, gint channel, void* data, gint len) {
	deliver_data_fwd (ctx, channel, data, len);
}


static void _deliver_status_fwd_gsm0710deliver_status_t (struct gsm0710_context* ctx, gint channel, gint status) {
	deliver_status_fwd (ctx, channel, status);
}


static void _debug_message_fwd_gsm0710debug_message_t (struct gsm0710_context* ctx, const gchar* msg) {
	debug_message_fwd (ctx, msg);
}


static void _open_channel_fwd_gsm0710open_channel_t (struct gsm0710_context* ctx, gint channel) {
	open_channel_fwd (ctx, channel);
}


static void _close_channel_fwd_gsm0710close_channel_t (struct gsm0710_context* ctx, gint channel) {
	close_channel_fwd (ctx, channel);
}


static void _terminate_fwd_gsm0710terminate_t (struct gsm0710_context* ctx) {
	terminate_fwd (ctx);
}


static void _response_to_test_fwd_gsm0710response_to_test_t (struct gsm0710_context* ctx, gchar* data, int data_length1) {
	response_to_test_fwd (ctx, data, data_length1);
}


static gchar* _multiplexer_repr_repr_delegate (gpointer self) {
	gchar* result;
	result = multiplexer_repr (self);
	return result;
}


Multiplexer* multiplexer_construct (GType object_type, gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager) {
	Multiplexer* self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	Gsm0710muxManager* _tmp7_;
	Gsm0710muxManager* _tmp8_;
	struct gsm0710_context* _tmp9_;
	gint _tmp10_ = 0;
	gboolean _tmp11_;
	struct gsm0710_context* _tmp12_;
	gint _tmp13_;
	struct gsm0710_context* _tmp14_;
	gint _tmp15_;
	struct gsm0710_context* _tmp16_;
	gint _tmp17_;
	struct gsm0710_context* _tmp18_;
	struct gsm0710_context* _tmp19_;
	struct gsm0710_context* _tmp20_;
	struct gsm0710_context* _tmp21_;
	struct gsm0710_context* _tmp22_;
	struct gsm0710_context* _tmp23_;
	struct gsm0710_context* _tmp24_;
	struct gsm0710_context* _tmp25_;
	struct gsm0710_context* _tmp26_;
	struct gsm0710_context* _tmp27_;
	struct gsm0710_context* _tmp28_;
	FsoFrameworkSmartKeyFile* _tmp29_;
	FsoFrameworkLogger* _tmp30_ = NULL;
	FsoFrameworkLogger* _tmp31_;
	FsoFrameworkLogger* _tmp32_;
	gboolean _tmp33_ = FALSE;
	g_return_val_if_fail (porttype != NULL, NULL);
	g_return_val_if_fail (portname != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	self = (Multiplexer*) g_type_create_instance (object_type);
	_tmp0_ = porttype;
	g_assert (_tmp0_ != NULL);
	_tmp1_ = portname;
	g_assert (_tmp1_ != NULL);
	_tmp2_ = porttype;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->porttype);
	self->priv->porttype = _tmp3_;
	_tmp4_ = portname;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->portname);
	self->priv->portname = _tmp5_;
	_tmp6_ = portspeed;
	self->priv->portspeed = _tmp6_;
	_tmp7_ = manager;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp8_;
	_tmp9_ = gsm0710_context_new ();
	_gsm0710_context_free0 (self->priv->ctx);
	self->priv->ctx = _tmp9_;
	_tmp11_ = advanced;
	if (_tmp11_) {
		_tmp10_ = 1;
	} else {
		_tmp10_ = 0;
	}
	_tmp12_ = self->priv->ctx;
	_tmp13_ = _tmp10_;
	_tmp12_->mode = _tmp13_;
	_tmp14_ = self->priv->ctx;
	_tmp15_ = framesize;
	_tmp14_->frame_size = _tmp15_;
	_tmp16_ = self->priv->ctx;
	_tmp17_ = portspeed;
	_tmp16_->port_speed = _tmp17_;
	_tmp18_ = self->priv->ctx;
	_tmp18_->user_data = self;
	_tmp19_ = self->priv->ctx;
	_tmp19_->at_command = _at_command_fwd_gsm0710at_command_t;
	_tmp20_ = self->priv->ctx;
	_tmp20_->read = _read_fwd_gsm0710read_t;
	_tmp21_ = self->priv->ctx;
	_tmp21_->write = _write_fwd_gsm0710write_t;
	_tmp22_ = self->priv->ctx;
	_tmp22_->deliver_data = _deliver_data_fwd_gsm0710deliver_data_t;
	_tmp23_ = self->priv->ctx;
	_tmp23_->deliver_status = _deliver_status_fwd_gsm0710deliver_status_t;
	_tmp24_ = self->priv->ctx;
	_tmp24_->debug_message = _debug_message_fwd_gsm0710debug_message_t;
	_tmp25_ = self->priv->ctx;
	_tmp25_->open_channel = _open_channel_fwd_gsm0710open_channel_t;
	_tmp26_ = self->priv->ctx;
	_tmp26_->close_channel = _close_channel_fwd_gsm0710close_channel_t;
	_tmp27_ = self->priv->ctx;
	_tmp27_->terminate = _terminate_fwd_gsm0710terminate_t;
	_tmp28_ = self->priv->ctx;
	_tmp28_->response_to_test = _response_to_test_fwd_gsm0710response_to_test_t;
	_tmp29_ = fso_framework_theConfig;
	_tmp30_ = fso_framework_logger_createFromKeyFile (_tmp29_, CONST_LIBGSM0710MUX_CONFIG_SECTION, CONST_LIBGSM0710MUX_LOGGING_DOMAIN);
	_g_object_unref0 (self->priv->logger);
	self->priv->logger = _tmp30_;
	_tmp31_ = self->priv->logger;
	fso_framework_logger_setReprDelegate (_tmp31_, _multiplexer_repr_repr_delegate, self);
	_tmp32_ = self->priv->logger;
	_tmp33_ = fso_framework_logger_debug (_tmp32_, "Created");
	g_assert (_tmp33_);
	return self;
}


Multiplexer* multiplexer_new (gboolean advanced, gint framesize, const gchar* porttype, const gchar* portname, gint portspeed, Gsm0710muxManager* manager) {
	return multiplexer_construct (TYPE_MULTIPLEXER, advanced, framesize, porttype, portname, portspeed, manager);
}


gchar* multiplexer_repr (Multiplexer* self) {
	gchar* result = NULL;
	gchar _tmp0_ = '\0';
	struct gsm0710_context* _tmp1_;
	gint _tmp2_;
	gchar _tmp3_;
	struct gsm0710_context* _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	struct gsm0710_context* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->ctx;
	_tmp2_ = _tmp1_->mode;
	if (_tmp2_ == 1) {
		_tmp0_ = 'A';
	} else {
		_tmp0_ = 'B';
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = self->priv->ctx;
	_tmp5_ = _tmp4_->frame_size;
	_tmp6_ = self->priv->portname;
	_tmp7_ = self->priv->ctx;
	_tmp8_ = _tmp7_->port_speed;
	_tmp9_ = g_strdup_printf ("<%c%d %s@%d>", (gint) _tmp3_, _tmp5_, _tmp6_, _tmp8_);
	result = _tmp9_;
	return result;
}


gboolean multiplexer_initSession (Multiplexer* self) {
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Gsm0710muxManager* _tmp4_;
	gboolean _tmp5_;
	FsoFrameworkTransport* _tmp11_;
	struct gsm0710_context* _tmp12_;
	struct gsm0710_context* _tmp13_;
	FsoFrameworkTransport* _tmp14_;
	FsoFrameworkTransport* _tmp15_;
	gboolean ok = FALSE;
	struct gsm0710_context* _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "InitSession()");
	g_assert (_tmp1_);
	_tmp2_ = multiplexer_openTransport (self);
	if (!_tmp2_) {
		FsoFrameworkLogger* _tmp3_;
		_tmp3_ = self->priv->logger;
		fso_framework_logger_error (_tmp3_, "Can't open the transport");
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->manager;
	_tmp5_ = gsm0710mux_manager_leave_mux_alone;
	if (_tmp5_) {
		FsoFrameworkLogger* _tmp6_;
		FsoFrameworkTransport* _tmp7_;
		struct gsm0710_context* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean ok;
		FsoFrameworkTransport* _tmp10_;
		_tmp6_ = self->priv->logger;
		fso_framework_logger_warning (_tmp6_, "Assuming device is already in MUX mode...");
		_tmp7_ = self->priv->transport;
		fso_framework_transport_flush (_tmp7_);
		_tmp8_ = self->priv->ctx;
		_tmp9_ = gsm0710_startup (_tmp8_, FALSE);
		ok = _tmp9_;
		_tmp10_ = self->priv->transport;
		fso_framework_transport_drain (_tmp10_);
		result = ok;
		return result;
	}
	_tmp11_ = self->priv->transport;
	fso_framework_transport_flush (_tmp11_);
	_tmp12_ = self->priv->ctx;
	gsm0710_shutdown (_tmp12_);
	_tmp13_ = self->priv->ctx;
	gsm0710_shutdown (_tmp13_);
	_tmp14_ = self->priv->transport;
	fso_framework_transport_drain (_tmp14_);
	_tmp15_ = self->priv->transport;
	fso_framework_transport_flush (_tmp15_);
	_tmp16_ = self->priv->ctx;
	_tmp17_ = _tmp16_->mode;
	if (_tmp17_ == 0) {
		gboolean _tmp18_ = FALSE;
		struct gsm0710_context* _tmp19_;
		gboolean _tmp20_ = FALSE;
		_tmp18_ = multiplexer_at_command (self, "AT+CMUX=0\r\n");
		if (!_tmp18_) {
			result = FALSE;
			return result;
		}
		_tmp19_ = self->priv->ctx;
		_tmp20_ = gsm0710_startup (_tmp19_, FALSE);
		ok = _tmp20_;
	} else {
		struct gsm0710_context* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = self->priv->ctx;
		_tmp22_ = gsm0710_startup (_tmp21_, TRUE);
		ok = _tmp22_;
	}
	result = ok;
	return result;
}


void multiplexer_closeSession (Multiplexer* self) {
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp15_ = FALSE;
	struct gsm0710_context* _tmp16_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "closeSession()");
	g_assert (_tmp1_);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gboolean _tmp6_ = FALSE;
				Channel** _tmp7_;
				gint _tmp7__length1;
				gboolean _tmp11_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < GSM0710_MAX_CHANNELS)) {
					break;
				}
				_tmp7_ = self->priv->vc;
				_tmp7__length1 = self->priv->vc_length1;
				if (_tmp7_ != NULL) {
					Channel** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					Channel* _tmp10_;
					_tmp8_ = self->priv->vc;
					_tmp8__length1 = self->priv->vc_length1;
					_tmp9_ = i;
					_tmp10_ = _tmp8_[_tmp9_];
					_tmp6_ = _tmp10_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp11_ = _tmp6_;
				if (_tmp11_) {
					Channel** _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					Channel* _tmp14_;
					_tmp12_ = self->priv->vc;
					_tmp12__length1 = self->priv->vc_length1;
					_tmp13_ = i;
					_tmp14_ = _tmp12_[_tmp13_];
					channel_close (_tmp14_);
				}
			}
		}
	}
	_tmp16_ = self->priv->ctx;
	if (_tmp16_ != NULL) {
		gboolean _tmp17_;
		_tmp17_ = gsm0710mux_manager_leave_mux_alone;
		_tmp15_ = !_tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp18_ = _tmp15_;
	if (_tmp18_) {
		struct gsm0710_context* _tmp19_;
		_tmp19_ = self->priv->ctx;
		gsm0710_shutdown (_tmp19_);
	}
}


static void multiplexer_allocChannel_data_free (gpointer _data) {
	multiplexer_allocChannelData* _data_;
	_data_ = _data;
	_gsm0710mux_channel_info_unref0 (_data_->info);
	_multiplexer_unref0 (_data_->self);
	g_slice_free (multiplexer_allocChannelData, _data_);
}


static gpointer _gsm0710mux_channel_info_ref0 (gpointer self) {
	return self ? gsm0710mux_channel_info_ref (self) : NULL;
}


void multiplexer_allocChannel (Multiplexer* self, Gsm0710muxChannelInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	multiplexer_allocChannelData* _data_;
	Multiplexer* _tmp0_;
	Gsm0710muxChannelInfo* _tmp1_;
	Gsm0710muxChannelInfo* _tmp2_;
	_data_ = g_slice_new0 (multiplexer_allocChannelData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, multiplexer_allocChannel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, multiplexer_allocChannel_data_free);
	_tmp0_ = _multiplexer_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = info;
	_tmp2_ = _gsm0710mux_channel_info_ref0 (_tmp1_);
	_data_->info = _tmp2_;
	multiplexer_allocChannel_co (_data_);
}


gint multiplexer_allocChannel_finish (Multiplexer* self, GAsyncResult* _res_, GError** error) {
	gint result;
	multiplexer_allocChannelData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static gboolean _multiplexer_allocChannel_co_gsource_func (gpointer self) {
	gboolean result;
	result = multiplexer_allocChannel_co (self);
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean multiplexer_allocChannel_co (multiplexer_allocChannelData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->logger;
	_data_->_tmp1_ = _data_->info;
	_data_->_tmp2_ = _data_->_tmp1_->number;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_strdup_printf ("%i", _data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strconcat ("allocChannel() requested for channel ", _data_->_tmp4_, NULL);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = fso_framework_logger_debug (_data_->_tmp0_, _data_->_tmp6_);
	g_assert (_data_->_tmp7_);
	_g_free0 (_data_->_tmp6_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp8_ = _data_->info;
	_data_->_tmp9_ = _data_->_tmp8_->number;
	if (_data_->_tmp9_ == 0) {
		{
			_data_->i = 1;
			{
				_data_->_tmp10_ = TRUE;
				while (TRUE) {
					_data_->_tmp11_ = _data_->_tmp10_;
					if (!_data_->_tmp11_) {
						_data_->_tmp12_ = _data_->i;
						_data_->i = _data_->_tmp12_ + 1;
					}
					_data_->_tmp10_ = FALSE;
					_data_->_tmp13_ = _data_->i;
					if (!(_data_->_tmp13_ < GSM0710_MAX_CHANNELS)) {
						break;
					}
					_data_->_tmp14_ = _data_->self->priv->vc;
					_data_->_tmp14__length1 = _data_->self->priv->vc_length1;
					_data_->_tmp15_ = _data_->i;
					_data_->_tmp16_ = _data_->_tmp14_[_data_->_tmp15_];
					if (_data_->_tmp16_ == NULL) {
						_data_->_tmp17_ = _data_->info;
						_data_->_tmp18_ = _data_->i;
						_data_->_tmp17_->number = _data_->_tmp18_;
						break;
					}
				}
			}
		}
	} else {
		_data_->_tmp19_ = _data_->self->priv->vc;
		_data_->_tmp19__length1 = _data_->self->priv->vc_length1;
		_data_->_tmp20_ = _data_->info;
		_data_->_tmp21_ = _data_->_tmp20_->number;
		_data_->_tmp22_ = _data_->_tmp19_[_data_->_tmp21_];
		if (_data_->_tmp22_ != NULL) {
			_data_->_tmp23_ = _data_->info;
			_data_->_tmp24_ = _data_->_tmp23_->number;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = g_strdup_printf ("%i", _data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = g_strconcat ("Channel ", _data_->_tmp26_, " is already taken.", NULL);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp29_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_CHANNEL_TAKEN, _data_->_tmp28_);
			_data_->_tmp30_ = _data_->_tmp29_;
			_g_free0 (_data_->_tmp28_);
			_g_free0 (_data_->_tmp26_);
			_data_->_inner_error_ = _data_->_tmp30_;
			if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	multiplexer_wakeupIfNecessary (_data_->self);
	_data_->_tmp31_ = _data_->self->priv->ctx;
	_data_->_tmp32_ = _data_->info;
	_data_->_tmp33_ = _data_->_tmp32_->number;
	_data_->_tmp34_ = FALSE;
	_data_->_tmp34_ = gsm0710_open_channel (_data_->_tmp31_, _data_->_tmp33_);
	_data_->ok = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->self->priv->logger;
	_data_->_tmp36_ = _data_->ok;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = bool_to_string (_data_->_tmp36_);
	_data_->_tmp38_ = _data_->_tmp37_;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = g_strconcat ("0710 open channel returned ", _data_->_tmp38_, NULL);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = FALSE;
	_data_->_tmp41_ = fso_framework_logger_debug (_data_->_tmp35_, _data_->_tmp40_);
	g_assert (_data_->_tmp41_);
	_g_free0 (_data_->_tmp40_);
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp42_ = _data_->ok;
	if (!_data_->_tmp42_) {
		_data_->_tmp43_ = _data_->info;
		_data_->_tmp44_ = _data_->_tmp43_->number;
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = g_strdup_printf ("%i", _data_->_tmp44_);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = g_strconcat ("Modem does not provide channel ", _data_->_tmp46_, ".", NULL);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_CHANNEL, _data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		_g_free0 (_data_->_tmp48_);
		_g_free0 (_data_->_tmp46_);
		_data_->_inner_error_ = _data_->_tmp50_;
		if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp51_ = _data_->self->priv->vc;
	_data_->_tmp51__length1 = _data_->self->priv->vc_length1;
	_data_->_tmp52_ = _data_->info;
	_data_->_tmp53_ = _data_->_tmp52_->number;
	_data_->_tmp54_ = _data_->info;
	_data_->_tmp55_ = _data_->self->priv->manager;
	_data_->_tmp56_ = _data_->_tmp55_->channel_ack_timeout;
	_data_->_tmp57_ = channel_new (_data_->self, _data_->_tmp54_, _multiplexer_allocChannel_co_gsource_func, _data_, _data_->_tmp56_);
	_channel_unref0 (_data_->_tmp51_[_data_->_tmp53_]);
	_data_->_tmp51_[_data_->_tmp53_] = _data_->_tmp57_;
	_data_->_tmp58_ = _data_->_tmp51_[_data_->_tmp53_];
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp59_ = _data_->self->priv->vc;
	_data_->_tmp59__length1 = _data_->self->priv->vc_length1;
	_data_->_tmp60_ = _data_->info;
	_data_->_tmp61_ = _data_->_tmp60_->number;
	_data_->_tmp62_ = _data_->_tmp59_[_data_->_tmp61_];
	_data_->_tmp63_ = FALSE;
	_data_->_tmp63_ = channel_isAcked (_data_->_tmp62_);
	if (_data_->_tmp63_) {
		_data_->_tmp64_ = _data_->self->priv->vc;
		_data_->_tmp64__length1 = _data_->self->priv->vc_length1;
		_data_->_tmp65_ = _data_->info;
		_data_->_tmp66_ = _data_->_tmp65_->number;
		_data_->_tmp67_ = _data_->_tmp64_[_data_->_tmp66_];
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = channel_path (_data_->_tmp67_);
		_data_->path = _data_->_tmp68_;
		_data_->_tmp69_ = _data_->self->priv->logger;
		_data_->_tmp70_ = _data_->info;
		_data_->_tmp71_ = _data_->_tmp70_->number;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = g_strdup_printf ("%i", _data_->_tmp71_);
		_data_->_tmp73_ = _data_->_tmp72_;
		_data_->_tmp74_ = _data_->path;
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = string_to_string (_data_->_tmp74_);
		_data_->_tmp76_ = NULL;
		_data_->_tmp76_ = g_strconcat ("0710 channel ", _data_->_tmp73_, " opened and connected to ", _data_->_tmp75_, NULL);
		_data_->_tmp77_ = _data_->_tmp76_;
		_data_->_tmp78_ = FALSE;
		_data_->_tmp78_ = fso_framework_logger_debug (_data_->_tmp69_, _data_->_tmp77_);
		g_assert (_data_->_tmp78_);
		_g_free0 (_data_->_tmp77_);
		_g_free0 (_data_->_tmp73_);
		_data_->_tmp79_ = _data_->info;
		_data_->_tmp80_ = _data_->_tmp79_->number;
		_data_->result = _data_->_tmp80_;
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp81_ = _data_->self->priv->logger;
	_data_->_tmp82_ = _data_->info;
	_data_->_tmp83_ = _data_->_tmp82_->number;
	_data_->_tmp84_ = NULL;
	_data_->_tmp84_ = g_strdup_printf ("%i", _data_->_tmp83_);
	_data_->_tmp85_ = _data_->_tmp84_;
	_data_->_tmp86_ = NULL;
	_data_->_tmp86_ = g_strconcat ("0710 timeout while waiting for channel ", _data_->_tmp85_, " status signal", NULL);
	_data_->_tmp87_ = _data_->_tmp86_;
	_data_->_tmp88_ = FALSE;
	_data_->_tmp88_ = fso_framework_logger_debug (_data_->_tmp81_, _data_->_tmp87_);
	g_assert (_data_->_tmp88_);
	_g_free0 (_data_->_tmp87_);
	_g_free0 (_data_->_tmp85_);
	_data_->_tmp89_ = _data_->self->priv->vc;
	_data_->_tmp89__length1 = _data_->self->priv->vc_length1;
	_data_->_tmp90_ = _data_->info;
	_data_->_tmp91_ = _data_->_tmp90_->number;
	_channel_unref0 (_data_->_tmp89_[_data_->_tmp91_]);
	_data_->_tmp89_[_data_->_tmp91_] = NULL;
	_data_->_tmp92_ = _data_->_tmp89_[_data_->_tmp91_];
	_data_->_tmp93_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_CHANNEL, "Modem does not provide this channel.");
	_data_->_inner_error_ = _data_->_tmp93_;
	if (_data_->_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void multiplexer_releaseChannel (Multiplexer* self, const gchar* name, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	Channel** _tmp6_;
	gint _tmp6__length1;
	gint closed;
	gint _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("releaseChannel() requested for ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = fso_framework_logger_debug (_tmp0_, _tmp4_);
	g_assert (_tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->vc;
	_tmp6__length1 = self->priv->vc_length1;
	if (_tmp6_ == NULL) {
		FsoFrameworkLogger* _tmp7_;
		_tmp7_ = self->priv->logger;
		fso_framework_logger_warning (_tmp7_, "Channel array has already been destroyed");
		return;
	}
	closed = 0;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				gboolean _tmp12_ = FALSE;
				Channel** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				Channel* _tmp15_;
				gboolean _tmp22_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				if (!(_tmp11_ < GSM0710_MAX_CHANNELS)) {
					break;
				}
				_tmp13_ = self->priv->vc;
				_tmp13__length1 = self->priv->vc_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				if (_tmp15_ != NULL) {
					Channel** _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
					Channel* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp16_ = self->priv->vc;
					_tmp16__length1 = self->priv->vc_length1;
					_tmp17_ = i;
					_tmp18_ = _tmp16_[_tmp17_];
					_tmp19_ = channel_name (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = name;
					_tmp12_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
					_g_free0 (_tmp20_);
				} else {
					_tmp12_ = FALSE;
				}
				_tmp22_ = _tmp12_;
				if (_tmp22_) {
					Channel** _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					Channel* _tmp25_;
					gint _tmp26_;
					_tmp23_ = self->priv->vc;
					_tmp23__length1 = self->priv->vc_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_];
					channel_close (_tmp25_);
					_tmp26_ = closed;
					closed = _tmp26_ + 1;
				}
			}
		}
	}
	_tmp27_ = closed;
	if (_tmp27_ > 0) {
		Gsm0710muxManager* _tmp28_;
		gint _tmp29_;
		_tmp28_ = self->priv->manager;
		_tmp29_ = closed;
		gsm0710mux_manager_channelsHaveBeenClosed (_tmp28_, _tmp29_);
	} else {
		GError* _tmp30_;
		_tmp30_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_CHANNEL, "Could not find any channel with that name.");
		_inner_error_ = _tmp30_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void multiplexer_setStatus (Multiplexer* self, gint channel, const gchar* status, GError** error) {
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	Channel** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	Channel* _tmp9_;
	const gchar* _tmp11_;
	gint _tmp12_ = 0;
	gint v24;
	struct gsm0710_context* _tmp13_;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = channel;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("setStatus() requested for channel ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = fso_framework_logger_debug (_tmp0_, _tmp5_);
	g_assert (_tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = self->priv->vc;
	_tmp7__length1 = self->priv->vc_length1;
	_tmp8_ = channel;
	_tmp9_ = _tmp7_[_tmp8_];
	if (_tmp9_ == NULL) {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (GSM0710MUX_MUXER_ERROR, GSM0710MUX_MUXER_ERROR_NO_CHANNEL, "Could not find channel with that index.");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == GSM0710MUX_MUXER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = status;
	_tmp12_ = multiplexer_stringToSerialStatus (self, _tmp11_);
	v24 = _tmp12_;
	multiplexer_wakeupIfNecessary (self);
	_tmp13_ = self->priv->ctx;
	_tmp14_ = channel;
	gsm0710_set_status (_tmp13_, _tmp14_, v24);
}


void multiplexer_setWakeupThreshold (Multiplexer* self, guint seconds, guint waitms, GError** error) {
	guint _tmp0_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = seconds;
	if (_tmp0_ == ((guint) 0)) {
		_g_timer_destroy0 (self->priv->idle_wakeup_timer);
		self->priv->idle_wakeup_timer = NULL;
	} else {
		GTimer* _tmp1_;
		_tmp1_ = self->priv->idle_wakeup_timer;
		if (_tmp1_ == NULL) {
			GTimer* _tmp2_;
			GTimer* _tmp3_;
			_tmp2_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->idle_wakeup_timer);
			self->priv->idle_wakeup_timer = _tmp2_;
			_tmp3_ = self->priv->idle_wakeup_timer;
			g_timer_start (_tmp3_);
		}
	}
	_tmp4_ = seconds;
	self->priv->idle_wakeup_threshold = _tmp4_;
	_tmp5_ = waitms;
	self->priv->idle_wakeup_waitms = _tmp5_;
}


void multiplexer_setSendPauseThreshold (Multiplexer* self, guint ms) {
	guint _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ms;
	if (_tmp0_ == ((guint) 0)) {
		_g_timer_destroy0 (self->priv->send_pause_timer);
		self->priv->send_pause_timer = NULL;
	} else {
		GTimer* _tmp1_;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->send_pause_timer);
		self->priv->send_pause_timer = _tmp1_;
	}
	_tmp2_ = ms;
	self->priv->send_pause_threshold = _tmp2_;
}


void multiplexer_testCommand (Multiplexer* self, guint8* data, int data_length1) {
	struct gsm0710_context* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_debug ("multiplexer.vala:351: muxer: testCommand");
	multiplexer_wakeupIfNecessary (self);
	_tmp0_ = self->priv->ctx;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	gsm0710_send_test (_tmp0_, _tmp1_, _tmp2__length1);
}


static void _multiplexer_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	multiplexer_onReadFromTransport (self, transport);
}


static void _multiplexer_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	multiplexer_onHupFromTransport (self, transport);
}


gboolean multiplexer_openTransport (Multiplexer* self) {
	gboolean result = FALSE;
	FsoFrameworkTransport* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	FsoFrameworkTransport* _tmp4_ = NULL;
	FsoFrameworkTransport* _tmp5_;
	FsoFrameworkTransport* _tmp6_;
	FsoFrameworkTransport* _tmp7_;
	FsoFrameworkTransport* _tmp8_;
	FsoFrameworkTransport* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->transport;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = self->priv->porttype;
	_tmp2_ = self->priv->portname;
	_tmp3_ = self->priv->portspeed;
	_tmp4_ = fso_framework_transport_create (_tmp1_, _tmp2_, (guint) _tmp3_, TRUE, TRUE);
	_g_object_unref0 (self->priv->transport);
	self->priv->transport = _tmp4_;
	_tmp5_ = self->priv->transport;
	if (_tmp5_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->transport;
	fso_framework_transport_setDelegates (_tmp6_, _multiplexer_onReadFromTransport_fso_framework_transport_func, self, _multiplexer_onHupFromTransport_fso_framework_transport_func, self);
	_tmp7_ = self->priv->transport;
	fso_framework_transport_setBuffered (_tmp7_, FALSE);
	_tmp8_ = self->priv->transport;
	fso_framework_transport_open (_tmp8_);
	_tmp9_ = self->priv->transport;
	_tmp10_ = fso_framework_transport_isOpen (_tmp9_);
	result = _tmp10_;
	return result;
}


gchar* multiplexer_serialStatusToString (Multiplexer* self, gint status) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* sb;
	gint _tmp1_;
	gint _tmp3_;
	gint _tmp5_;
	gint _tmp7_;
	gint _tmp9_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	_tmp1_ = status;
	if ((_tmp1_ & GSM0710_FC) == ((gint) GSM0710_FC)) {
		GString* _tmp2_;
		_tmp2_ = sb;
		g_string_append (_tmp2_, "FC ");
	}
	_tmp3_ = status;
	if ((_tmp3_ & GSM0710_RTC) == ((gint) GSM0710_RTC)) {
		GString* _tmp4_;
		_tmp4_ = sb;
		g_string_append (_tmp4_, "DSR ");
	}
	_tmp5_ = status;
	if ((_tmp5_ & GSM0710_RTR) == ((gint) GSM0710_RTR)) {
		GString* _tmp6_;
		_tmp6_ = sb;
		g_string_append (_tmp6_, "CTS ");
	}
	_tmp7_ = status;
	if ((_tmp7_ & GSM0710_RING) == ((gint) GSM0710_RING)) {
		GString* _tmp8_;
		_tmp8_ = sb;
		g_string_append (_tmp8_, "RING ");
	}
	_tmp9_ = status;
	if ((_tmp9_ & GSM0710_DCD) == ((gint) GSM0710_DCD)) {
		GString* _tmp10_;
		_tmp10_ = sb;
		g_string_append (_tmp10_, "DCD ");
	}
	_tmp11_ = sb;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (sb);
	return result;
}


gint multiplexer_stringToSerialStatus (Multiplexer* self, const gchar* status) {
	gint result = 0;
	gint v24;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** bits;
	gint bits_length1;
	gint _bits_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (status != NULL, 0);
	v24 = 0;
	_tmp0_ = status;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	bits = _tmp2_;
	bits_length1 = _vala_array_length (_tmp1_);
	_bits_size_ = bits_length1;
	_tmp3_ = bits;
	_tmp3__length1 = bits_length1;
	{
		gchar** bit_collection = NULL;
		gint bit_collection_length1 = 0;
		gint _bit_collection_size_ = 0;
		gint bit_it = 0;
		bit_collection = _tmp3_;
		bit_collection_length1 = _tmp3__length1;
		for (bit_it = 0; bit_it < _tmp3__length1; bit_it = bit_it + 1) {
			gchar* _tmp4_;
			gchar* bit = NULL;
			_tmp4_ = g_strdup (bit_collection[bit_it]);
			bit = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = bit;
				if (g_strcmp0 (_tmp5_, "DTR") == 0) {
					gint _tmp6_;
					_tmp6_ = v24;
					v24 = _tmp6_ | GSM0710_RTC;
				} else {
					const gchar* _tmp7_;
					_tmp7_ = bit;
					if (g_strcmp0 (_tmp7_, "RTS") == 0) {
						gint _tmp8_;
						_tmp8_ = v24;
						v24 = _tmp8_ | GSM0710_RTR;
					}
				}
				_g_free0 (bit);
			}
		}
	}
	result = v24;
	bits = (_vala_array_free (bits, bits_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void multiplexer_clearPingResponseTimeout (Multiplexer* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pingwatch;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->pingwatch;
		g_source_remove (_tmp1_);
	}
}


static void multiplexer_sleepIfNecessary (Multiplexer* self) {
	GTimer* _tmp0_;
	guint _tmp1_;
	GTimer* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble timediff;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->send_pause_timer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->send_pause_threshold;
	_tmp2_ = self->priv->send_pause_timer;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	timediff = _tmp1_ - _tmp3_;
	_tmp4_ = timediff;
	if (_tmp4_ > ((gdouble) 0)) {
		FsoFrameworkLogger* _tmp5_;
		gdouble _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gdouble _tmp10_;
		_tmp5_ = self->priv->logger;
		_tmp6_ = timediff;
		_tmp7_ = g_strdup_printf ("Attempting to send too fast, sleeping %.2f seconds", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = fso_framework_logger_debug (_tmp5_, _tmp8_);
		g_assert (_tmp9_);
		_g_free0 (_tmp8_);
		_tmp10_ = timediff;
		g_usleep ((gulong) (_tmp10_ * 1000));
	}
}


void multiplexer_wakeupIfNecessary (Multiplexer* self) {
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->idle_wakeup_timer;
	if (_tmp0_ != NULL) {
		GTimer* _tmp1_;
		gdouble _tmp2_ = 0.0;
		gdouble elapsed;
		gdouble _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->idle_wakeup_timer;
		_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
		elapsed = _tmp2_;
		_tmp3_ = elapsed;
		_tmp4_ = self->priv->idle_wakeup_threshold;
		if (_tmp3_ > ((gdouble) _tmp4_)) {
			FsoFrameworkLogger* _tmp5_;
			gdouble _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			gboolean _tmp9_ = FALSE;
			gchar* _tmp10_ = NULL;
			gchar* wakeup;
			gint wakeup_length1;
			gint _wakeup_size_;
			struct gsm0710_context* _tmp11_;
			gchar* _tmp12_;
			gint _tmp12__length1;
			gchar* _tmp13_;
			gint _tmp13__length1;
			guint _tmp14_;
			_tmp5_ = self->priv->logger;
			_tmp6_ = elapsed;
			_tmp7_ = g_strdup_printf ("Channel has been idle for %.2f seconds, waking up", _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = fso_framework_logger_debug (_tmp5_, _tmp8_);
			g_assert (_tmp9_);
			_g_free0 (_tmp8_);
			_tmp10_ = g_new0 (gchar, 7);
			_tmp10_[0] = 'W';
			_tmp10_[1] = 'A';
			_tmp10_[2] = 'K';
			_tmp10_[3] = 'E';
			_tmp10_[4] = 'U';
			_tmp10_[5] = 'P';
			_tmp10_[6] = '!';
			wakeup = _tmp10_;
			wakeup_length1 = 7;
			_wakeup_size_ = wakeup_length1;
			_tmp11_ = self->priv->ctx;
			_tmp12_ = wakeup;
			_tmp12__length1 = wakeup_length1;
			_tmp13_ = wakeup;
			_tmp13__length1 = wakeup_length1;
			gsm0710_send_test (_tmp11_, _tmp12_, _tmp13__length1);
			_tmp14_ = self->priv->idle_wakeup_waitms;
			g_usleep ((gulong) (1000 * _tmp14_));
			wakeup = (g_free (wakeup), NULL);
		}
	}
}


void multiplexer_onReadFromTransport (Multiplexer* self, FsoFrameworkTransport* transport) {
	struct gsm0710_context* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transport != NULL);
	_tmp0_ = self->priv->ctx;
	gsm0710_ready_read (_tmp0_);
}


void multiplexer_onHupFromTransport (Multiplexer* self, FsoFrameworkTransport* transport) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transport != NULL);
	_tmp0_ = self->priv->logger;
	fso_framework_logger_error (_tmp0_, "HUP from modem transport; closing session");
	multiplexer_closeSession (self);
}


void multiplexer_submit_data (Multiplexer* self, gint channel, void* data, gint len) {
	struct gsm0710_context* _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	multiplexer_sleepIfNecessary (self);
	multiplexer_wakeupIfNecessary (self);
	_tmp0_ = self->priv->ctx;
	_tmp1_ = channel;
	_tmp2_ = data;
	_tmp3_ = len;
	gsm0710_write_data (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
}


void multiplexer_channel_closed (Multiplexer* self, gint channel) {
	struct gsm0710_context* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	multiplexer_wakeupIfNecessary (self);
	_tmp0_ = self->priv->ctx;
	_tmp1_ = channel;
	gsm0710_close_channel (_tmp0_, _tmp1_);
}


void multiplexer_remove_channel (Multiplexer* self, gint channel) {
	Channel** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	Channel* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->vc;
	_tmp0__length1 = self->priv->vc_length1;
	_tmp1_ = channel;
	_channel_unref0 (_tmp0_[_tmp1_]);
	_tmp0_[_tmp1_] = NULL;
	_tmp2_ = _tmp0_[_tmp1_];
}


gint multiplexer_read (Multiplexer* self, void* data, gint len) {
	gint result = 0;
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	void* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	FsoFrameworkTransport* _tmp6_;
	void* _tmp7_;
	gint _tmp8_;
	gint _tmp9_ = 0;
	gint numread;
	void* _tmp10_;
	FsoFrameworkLogger* _tmp11_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->logger;
	_tmp1_ = len;
	_tmp2_ = data;
	_tmp3_ = g_strdup_printf ("0710 -> should read max %d bytes to %p", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = fso_framework_logger_debug (_tmp0_, _tmp4_);
	g_assert (_tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->transport;
	_tmp7_ = data;
	_tmp8_ = len;
	_tmp9_ = fso_framework_transport_read (_tmp6_, _tmp7_, _tmp8_);
	numread = _tmp9_;
	_tmp10_ = data;
	_tmp11_ = self->priv->logger;
	const_hexdump (FALSE, _tmp10_, numread, _tmp11_);
	result = numread;
	return result;
}


gboolean multiplexer_write (Multiplexer* self, void* data, gint len) {
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GTimer* _tmp5_;
	void* _tmp7_;
	gint _tmp8_;
	FsoFrameworkLogger* _tmp9_;
	GTimer* _tmp10_;
	FsoFrameworkTransport* _tmp12_;
	void* _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	gint numsent;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->logger;
	_tmp1_ = len;
	_tmp2_ = g_strdup_printf ("0710 -> should write %d bytes", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = fso_framework_logger_debug (_tmp0_, _tmp3_);
	g_assert (_tmp4_);
	_g_free0 (_tmp3_);
	_tmp5_ = self->priv->idle_wakeup_timer;
	if (_tmp5_ != NULL) {
		GTimer* _tmp6_;
		_tmp6_ = self->priv->idle_wakeup_timer;
		g_timer_reset (_tmp6_);
	}
	_tmp7_ = data;
	_tmp8_ = len;
	_tmp9_ = self->priv->logger;
	const_hexdump (TRUE, _tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = self->priv->send_pause_timer;
	if (_tmp10_ != NULL) {
		GTimer* _tmp11_;
		_tmp11_ = self->priv->send_pause_timer;
		g_timer_reset (_tmp11_);
	}
	_tmp12_ = self->priv->transport;
	_tmp13_ = data;
	_tmp14_ = len;
	_tmp15_ = fso_framework_transport_write (_tmp12_, _tmp13_, _tmp14_);
	numsent = _tmp15_;
	result = numsent > 0;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean multiplexer_at_command (Multiplexer* self, const gchar* command) {
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_ = NULL;
	gchar* response;
	gint response_length1;
	gint _response_size_;
	FsoFrameworkTransport* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_ = 0;
	gint numread;
	FsoFrameworkLogger* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	_tmp0_ = self->priv->logger;
	_tmp1_ = command;
	_tmp2_ = g_strdup_printf ("0710 -> should send at_command '%s'", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = fso_framework_logger_debug (_tmp0_, _tmp3_);
	g_assert (_tmp4_);
	_g_free0 (_tmp3_);
	_tmp5_ = g_new0 (gchar, 1024);
	response = _tmp5_;
	response_length1 = 1024;
	_response_size_ = response_length1;
	_tmp6_ = self->priv->transport;
	_tmp7_ = command;
	_tmp8_ = command;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = fso_framework_transport_writeAndRead (_tmp6_, _tmp7_, (gint) _tmp10_, response, response_length1, 5000);
	numread = _tmp11_;
	_tmp12_ = self->priv->logger;
	_tmp13_ = g_strescape ((const gchar*) response, "");
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("Got %u bytes back w/ content = %s", (guint) numread, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = fso_framework_logger_debug (_tmp12_, _tmp16_);
	g_assert (_tmp17_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp18_ = string_contains ((const gchar*) response, "OK");
	result = _tmp18_;
	response = (g_free (response), NULL);
	return result;
}


void multiplexer_deliver_data (Multiplexer* self, gint channel, void* data, gint len) {
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	Channel** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	Channel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = len;
	_tmp2_ = channel;
	_tmp3_ = g_strdup_printf ("0710 -> deliver %d bytes for channel %d", _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	fso_framework_logger_debug (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->vc;
	_tmp5__length1 = self->priv->vc_length1;
	_tmp6_ = channel;
	_tmp7_ = _tmp5_[_tmp6_];
	if (_tmp7_ == NULL) {
		FsoFrameworkLogger* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->logger;
		_tmp9_ = fso_framework_logger_debug (_tmp8_, "Should deliver bytes for unknown channel: ignoring");
		g_assert (_tmp9_);
	} else {
		Channel** _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		Channel* _tmp12_;
		void* _tmp13_;
		gint _tmp14_;
		_tmp10_ = self->priv->vc;
		_tmp10__length1 = self->priv->vc_length1;
		_tmp11_ = channel;
		_tmp12_ = _tmp10_[_tmp11_];
		_tmp13_ = data;
		_tmp14_ = len;
		channel_deliverData (_tmp12_, _tmp13_, _tmp14_);
	}
	multiplexer_clearPingResponseTimeout (self);
}


void multiplexer_deliver_status (Multiplexer* self, gint channel, gint serial_status) {
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* status;
	FsoFrameworkLogger* _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Channel** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	Channel* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = serial_status;
	_tmp1_ = multiplexer_serialStatusToString (self, _tmp0_);
	status = _tmp1_;
	_tmp2_ = self->priv->logger;
	_tmp3_ = serial_status;
	_tmp4_ = status;
	_tmp5_ = channel;
	_tmp6_ = g_strdup_printf ("0710 -> deliver status %d = '%s' for channel %d", _tmp3_, _tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = fso_framework_logger_debug (_tmp2_, _tmp7_);
	g_assert (_tmp8_);
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->vc;
	_tmp9__length1 = self->priv->vc_length1;
	_tmp10_ = channel;
	_tmp11_ = _tmp9_[_tmp10_];
	if (_tmp11_ == NULL) {
		FsoFrameworkLogger* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = self->priv->logger;
		_tmp13_ = fso_framework_logger_debug (_tmp12_, ":::should deliver status for unknown channel: ignoring");
		g_assert (_tmp13_);
	} else {
		Channel** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		Channel* _tmp16_;
		gboolean _tmp17_ = FALSE;
		Channel** _tmp23_;
		gint _tmp23__length1;
		gint _tmp24_;
		Channel* _tmp25_;
		gint _tmp26_;
		_tmp14_ = self->priv->vc;
		_tmp14__length1 = self->priv->vc_length1;
		_tmp15_ = channel;
		_tmp16_ = _tmp14_[_tmp15_];
		_tmp17_ = channel_isAcked (_tmp16_);
		if (!_tmp17_) {
			Channel** _tmp18_;
			gint _tmp18__length1;
			gint _tmp19_;
			Channel* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp18_ = self->priv->vc;
			_tmp18__length1 = self->priv->vc_length1;
			_tmp19_ = channel;
			_tmp20_ = _tmp18_[_tmp19_];
			_tmp21_ = channel_acked (_tmp20_);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp22_);
		}
		_tmp23_ = self->priv->vc;
		_tmp23__length1 = self->priv->vc_length1;
		_tmp24_ = channel;
		_tmp25_ = _tmp23_[_tmp24_];
		_tmp26_ = serial_status;
		channel_setSerialStatus (_tmp25_, _tmp26_);
	}
	multiplexer_clearPingResponseTimeout (self);
	_g_free0 (status);
}


void multiplexer_debug_message (Multiplexer* self, const gchar* msg) {
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = msg;
	_tmp2_ = g_strdup_printf ("0710 -> say '%s", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = fso_framework_logger_debug (_tmp0_, _tmp3_);
	g_assert (_tmp4_);
	_g_free0 (_tmp3_);
}


void multiplexer_open_channel (Multiplexer* self, gint channel) {
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	FsoFrameworkLogger* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = channel;
	_tmp2_ = g_strdup_printf ("0710 -> open channel %d", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = fso_framework_logger_debug (_tmp0_, _tmp3_);
	g_assert (_tmp4_);
	_g_free0 (_tmp3_);
	_tmp5_ = self->priv->logger;
	fso_framework_logger_error (_tmp5_, "Unhandled modem side open channel command");
}


void multiplexer_close_channel (Multiplexer* self, gint channel) {
	FsoFrameworkLogger* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* message;
	gint message_length1;
	gint _message_size_;
	gint _tmp5_;
	Channel** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	Channel* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = channel;
	_tmp2_ = g_strdup_printf ("0710 -> close channel %d", _tmp1_);
	_tmp3_ = _tmp2_;
	fso_framework_logger_debug (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_new0 (gchar, 13);
	_tmp4_[0] = '\r';
	_tmp4_[1] = '\n';
	_tmp4_[2] = '!';
	_tmp4_[3] = 'S';
	_tmp4_[4] = 'H';
	_tmp4_[5] = 'U';
	_tmp4_[6] = 'T';
	_tmp4_[7] = 'D';
	_tmp4_[8] = 'O';
	_tmp4_[9] = 'W';
	_tmp4_[10] = 'N';
	_tmp4_[11] = '\r';
	_tmp4_[12] = '\n';
	message = _tmp4_;
	message_length1 = 13;
	_message_size_ = message_length1;
	_tmp5_ = channel;
	multiplexer_deliver_data (self, _tmp5_, message, message_length1);
	_tmp6_ = self->priv->vc;
	_tmp6__length1 = self->priv->vc_length1;
	_tmp7_ = channel;
	_channel_unref0 (_tmp6_[_tmp7_]);
	_tmp6_[_tmp7_] = NULL;
	_tmp8_ = _tmp6_[_tmp7_];
	message = (g_free (message), NULL);
}


void multiplexer_terminate (Multiplexer* self) {
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->logger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "0710 -> terminate");
	g_assert (_tmp1_);
}


void multiplexer_response_to_test (Multiplexer* self, gchar* data, int data_length1) {
	GString* _tmp0_;
	GString* b;
	gchar* _tmp1_;
	gint _tmp1__length1;
	FsoFrameworkLogger* _tmp4_;
	gchar* _tmp5_;
	gint _tmp5__length1;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = data;
	_tmp1__length1 = data_length1;
	{
		gchar* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp1_;
		c_collection_length1 = _tmp1__length1;
		for (c_it = 0; c_it < _tmp1__length1; c_it = c_it + 1) {
			gchar c = '\0';
			c = c_collection[c_it];
			{
				GString* _tmp2_;
				gchar _tmp3_;
				_tmp2_ = b;
				_tmp3_ = c;
				g_string_append_printf (_tmp2_, "%c", (gint) _tmp3_);
			}
		}
	}
	_tmp4_ = self->priv->logger;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	_tmp6_ = b;
	_tmp7_ = _tmp6_->str;
	_tmp8_ = g_strdup_printf ("0710 -> response to test (%d bytes): %s", _tmp5__length1, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = fso_framework_logger_debug (_tmp4_, _tmp9_);
	g_assert (_tmp10_);
	_g_free0 (_tmp9_);
	multiplexer_clearPingResponseTimeout (self);
	_g_string_free0 (b);
}


static void value_multiplexer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_multiplexer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		multiplexer_unref (value->data[0].v_pointer);
	}
}


static void value_multiplexer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = multiplexer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_multiplexer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_multiplexer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Multiplexer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = multiplexer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_multiplexer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Multiplexer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = multiplexer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_multiplexer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMultiplexer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MULTIPLEXER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_multiplexer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTIPLEXER), NULL);
	return value->data[0].v_pointer;
}


void value_set_multiplexer (GValue* value, gpointer v_object) {
	Multiplexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTIPLEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MULTIPLEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		multiplexer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		multiplexer_unref (old);
	}
}


void value_take_multiplexer (GValue* value, gpointer v_object) {
	Multiplexer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MULTIPLEXER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MULTIPLEXER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		multiplexer_unref (old);
	}
}


static void multiplexer_class_init (MultiplexerClass * klass) {
	multiplexer_parent_class = g_type_class_peek_parent (klass);
	MULTIPLEXER_CLASS (klass)->finalize = multiplexer_finalize;
	g_type_class_add_private (klass, sizeof (MultiplexerPrivate));
}


static void multiplexer_instance_init (Multiplexer * self) {
	Channel** _tmp0_ = NULL;
	self->priv = MULTIPLEXER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (Channel*, GSM0710_MAX_CHANNELS + 1);
	self->priv->vc = _tmp0_;
	self->priv->vc_length1 = GSM0710_MAX_CHANNELS;
	self->priv->_vc_size_ = self->priv->vc_length1;
	self->ref_count = 1;
}


static void multiplexer_finalize (Multiplexer* obj) {
	Multiplexer * self;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkLogger* _tmp3_;
	gboolean _tmp4_ = FALSE;
	self = MULTIPLEXER (obj);
	_tmp0_ = self->priv->transport;
	if (_tmp0_ != NULL) {
		FsoFrameworkTransport* _tmp1_;
		FsoFrameworkTransport* _tmp2_;
		_tmp1_ = self->priv->transport;
		fso_framework_transport_freeze (_tmp1_);
		_tmp2_ = self->priv->transport;
		fso_framework_transport_close (_tmp2_);
	}
	_tmp3_ = self->priv->logger;
	_tmp4_ = fso_framework_logger_debug (_tmp3_, "Destructed");
	g_assert (_tmp4_);
	_g_object_unref0 (self->priv->manager);
	_g_free0 (self->priv->portname);
	_g_free0 (self->priv->porttype);
	_g_object_unref0 (self->priv->logger);
	_gsm0710_context_free0 (self->priv->ctx);
	_g_timer_destroy0 (self->priv->idle_wakeup_timer);
	_g_timer_destroy0 (self->priv->send_pause_timer);
	self->priv->vc = (_vala_array_free (self->priv->vc, self->priv->vc_length1, (GDestroyNotify) channel_unref), NULL);
	_g_object_unref0 (self->priv->transport);
}


GType multiplexer_get_type (void) {
	static volatile gsize multiplexer_type_id__volatile = 0;
	if (g_once_init_enter (&multiplexer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_multiplexer_init, value_multiplexer_free_value, value_multiplexer_copy_value, value_multiplexer_peek_pointer, "p", value_multiplexer_collect_value, "p", value_multiplexer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MultiplexerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiplexer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Multiplexer), 0, (GInstanceInitFunc) multiplexer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType multiplexer_type_id;
		multiplexer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Multiplexer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&multiplexer_type_id__volatile, multiplexer_type_id);
	}
	return multiplexer_type_id__volatile;
}


gpointer multiplexer_ref (gpointer instance) {
	Multiplexer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void multiplexer_unref (gpointer instance) {
	Multiplexer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MULTIPLEXER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



