/* $Id: size.c,v 1.2 2005/05/21 20:40:36 cegger Exp $
******************************************************************************

   Graphics library for GGIWmh. Position and Size.

   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "quartzwmh.h"
#include <ggi/input/quartz.h>
#include <ggi/internal/wmh_debug.h>


static int resizefunc(void *vis, Rect orig, Rect prev, Rect cur)
{
	LIB_ASSERT(vis != NULL, "vis == NULL\n");

	return GGI_quartz_updateWindowContext((ggi_visual *)vis, 1);
}


int enableResize(ggi_visual *vis)
{
	gii_event ev;
	gii_quartz_cmddata_setparam data;
	ggi_quartz_priv *priv = QUARTZ_PRIV(vis);

	LIB_ASSERT(priv != NULL, "priv == NULL\n");
	LIB_ASSERT(priv->inp != NULL, "priv->inp == NULL\n");

	data.resizefunc = resizefunc;
	data.flags = GII_QZFLAG_UPDATE_RESIZEFUNC;

	ev.cmd.size = sizeof(gii_cmd_event);
	ev.cmd.type = evCommand;
	ev.cmd.target = priv->inp->origin;
	ev.cmd.code = GII_CMDCODE_QZSETPARAM;

	/* Ensure aligned memory access */
	memcpy(ev.cmd.data, &data, sizeof(gii_quartz_cmddata_setparam));

	return giiEventSend(priv->inp, &ev);
}


static OSStatus _ggiwmh_getgeometry(ggi_visual *vis, Rect *bounds)
{
	ggi_quartz_priv *priv;

	priv = QUARTZ_PRIV(vis);

	/* kWindowContentRgn gets bounds w/o and,
	 * kWindowStructureRgn gets bounds with window decoration
	 */
	return GetWindowBounds(priv->theWindow, kWindowContentRgn, bounds);
}

int GGIwmh_quartz_getpos(ggi_visual *vis,int *x,int *y)
{
	int err;
	Rect bounds;

	err = _ggiwmh_getgeometry(vis, &bounds);
	LIB_ASSERT(err == noErr, "Could not figure window position\n");

	*x = bounds.left;
	*y = bounds.top;

	return GGI_OK;
}

int GGIwmh_quartz_getsize(ggi_visual *vis,int *x,int *y)
{
	int err;
	Rect bounds;

	err = _ggiwmh_getgeometry(vis, &bounds);
	LIB_ASSERT(err == noErr, "Could not figure window size\n");

	*x = bounds.right - bounds.left;
	*y = bounds.bottom - bounds.top;

	return GGI_OK;
}

int GGIwmh_quartz_resize(ggi_visual *vis,int x,int y)
{
	ggi_quartz_priv *priv;
	priv = QUARTZ_PRIV(vis);

	LIB_ASSERT(priv != NULL, "priv == NULL\n");

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	SizeWindow(priv->theWindow, x, y, 1);
	if (!priv->enableUserResize) {
		return GGI_quartz_updateWindowContext(vis, 0);
	}
	return GGI_OK;
}

int GGIwmh_quartz_allowresize(ggi_visual *vis, int xmin, int ymin,
			int xmax, int ymax, int xstep, int ystep)
{
	WindowAttributes winAttrs;
	ggi_quartz_priv *priv;
	priv = QUARTZ_PRIV(vis);

	LIB_ASSERT(priv != NULL, "priv == NULL\n");

	if (priv->fullscreen)
		return GGI_ENOMATCH;

	if ((xmin < 0)  || (ymin < 0)
	   || (xstep < 1) || (ystep < 1)
	   || (xmin > xmax) || (ymin > ymax) )
	{
		return GGI_ENOSPACE;
	}

	winAttrs = kWindowLiveResizeAttribute | kWindowResizableAttribute;

	priv->windowAttrs |= winAttrs;

	ChangeWindowAttributes(priv->theWindow, winAttrs,
				kWindowNoAttributes);
#if 0
	priv->enableUserResize = 1;
#endif
	return GGI_OK;
}

int GGIwmh_quartz_maximize(ggi_visual *vis,int x,int y)
{
	return GGI_ENOFUNC;
}
