/* $Id: init.c,v 1.1 2002/11/28 18:35:12 cegger Exp $
******************************************************************************

   Wmh extension initialization.

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include <ggi/internal/wmh.h>

/* Static variables 
 */

static int 	 _WmhLibIsUp=0;
static void	*_WmhConfigHandle;
static char      _Wmhconfstub[512]=WMHCONFFILE;
static char     *_Wmhconffile=_Wmhconfstub+WMHTAGLEN;

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely...
 */
EXPORTVAR ggi_extid _WmhID = -1;


#define SUBLIB_PREFIX  "WMHdl_"



/* Dummy function which returns -1
   We use this to reset the function pointers */
static int dummyfunc(void)
{
	return -1;
}	/* dummyfunc */

/*-* Reset all function pointers to dummyfunc */
static void clearfuncs(wmhpriv *priv)
{
	priv->move		= (void *) dummyfunc;
	priv->resize		= (void *) dummyfunc;
	priv->getpos		= (void *) dummyfunc;
	priv->getsize		= (void *) dummyfunc;
	priv->maximize		= (void *) dummyfunc;
	priv->moveicon		= (void *) dummyfunc;
	priv->settitle		= (void *) dummyfunc;
	priv->seticontitle	= (void *) dummyfunc;
	priv->zorder		= (void *) dummyfunc;
	priv->iconify		= (void *) dummyfunc;
	priv->allowresize	= (void *) dummyfunc;
}	/* clearfuncs */


static int changed(ggi_visual_t vis,int whatchanged)
{
	GGIDPRINT("changed(%p, %i) called for misc extension\n",
		  vis, whatchanged);

	switch(whatchanged) {
	case GGI_CHG_APILIST: {
		int i;
		const char *fname;
		ggi_dlhandle *lib;
		char api[GGI_MAX_APILEN], args[GGI_MAX_APILEN];
		wmhpriv *priv;

		GGIDPRINT("changed() APILIST \n");

		priv = LIBGGI_WMHEXT(vis);

		clearfuncs(LIBGGI_WMHEXT(vis));

		for(i=0; ggiGetAPI(vis, i, api, args) == 0; i++) {
			strcat(api,"-wmh");
			fname = ggMatchConfig(_WmhConfigHandle, api, NULL);
			if (fname == NULL) {
				/* No special implementation for this sublib */
				continue;
			}	/* if */
			lib = ggiExtensionLoadDL(vis, fname, args, NULL,
						 SUBLIB_PREFIX);
		}	/* for */
	}
	break;
	}	/* switch */

	return 0;
}	/* changed */



/* Initialize the extension
 */
int ggiWmhInit(void)
{
	int err;

	_WmhLibIsUp++;
	if (_WmhLibIsUp > 1) return 0; /* Initialize only at first call. */

	err = ggLoadConfig(_Wmhconffile, &_WmhConfigHandle);
	if (err != GGI_OK) {
		fprintf(stderr,"LibWMH: couldn't open %s\n",
			_Wmhconffile);
		_WmhLibIsUp--;
		return err;
	}	/* if */

	_WmhID = ggiExtensionRegister("WMH", sizeof(wmhpriv), changed);

	if (_WmhID < 0) {
		fprintf(stderr,
			"LibWMH: failed to register as extension.\n");
		_WmhLibIsUp--;
		ggFreeConfig(_WmhConfigHandle);
		return _WmhID;
	}	/* if */

	return 0;
}	/* ggiWmhInit */


/* Deinitialize the extension
 */
int ggiWmhExit(void)
{
	int rc;
    
	if (!_WmhLibIsUp) return -1;

	if (_WmhLibIsUp > 1) {
		/* Exit only at last call */
		_WmhLibIsUp--;
		return 0;
	}	/* if */
	
	rc = ggiExtensionUnregister(_WmhID);
	ggFreeConfig(_WmhConfigHandle);

	_WmhLibIsUp = 0;

	return rc;
}	/* ggiWmhExit */



/* Attach the extension to a visual
 */
int ggiWmhAttach(ggi_visual_t vis)
{
	int rc;

	rc = ggiExtensionAttach(vis, _WmhID);
	if (rc < 0) {
		GGIDPRINT_CORE("Failed to attach myself to this visual.\n");
		goto err0;
	}	/* if */

	if (rc != 0) return rc;

	rc = 0;

	/* We are actually creating the primary instance. */
	memset(LIBGGI_WMHEXT(vis), 0, sizeof(wmhpriv));
                        
	/* Now fake an "API change" so the right libs get loaded */
	changed(vis, GGI_CHG_APILIST);

	return rc;

err0:
	return rc;
}	/* ggiWmhAttach */


/* Detach the extension from a visual
 */
int ggiWmhDetach(ggi_visual_t vis)
{
	return ggiExtensionDetach(vis, _WmhID);
}	/* ggiWmhDetach */
