/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		else if (op[1] == 'I')
			return GDA_SQL_OPERATOR_TYPE_ILIKE;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret = NULL;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 208 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    priv_gda_sql_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is priv_gda_sql_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    priv_gda_sql_parserARG_SDECL     A static variable declaration for the %extra_argument
**    priv_gda_sql_parserARG_PDECL     A parameter declaration for the %extra_argument
**    priv_gda_sql_parserARG_STORE     Code to store %extra_argument into yypParser
**    priv_gda_sql_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 211
#define YYACTIONTYPE unsigned short int
#define priv_gda_sql_parserTOKENTYPE GValue *
typedef union {
  int yyinit;
  priv_gda_sql_parserTOKENTYPE yy0;
  Limit yy44;
  CaseBody yy59;
  GdaSqlExpr * yy70;
  GdaSqlStatement * yy116;
  GdaSqlSelectTarget * yy134;
  GdaSqlExpr* yy146;
  GdaSqlOperatorType yy147;
  GdaTransactionIsolation yy169;
  GdaSqlSelectFrom * yy191;
  gboolean yy276;
  Distinct * yy297;
  GSList * yy325;
  GSList* yy333;
  GdaSqlParamSpec * yy339;
  GdaSqlSelectJoinType yy371;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define priv_gda_sql_parserARG_SDECL GdaSqlParserIface *pdata;
#define priv_gda_sql_parserARG_PDECL ,GdaSqlParserIface *pdata
#define priv_gda_sql_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define priv_gda_sql_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 365
#define YYNRULE 198
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1363)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    41,   40,  365,  246,  246,  141,  243,   22,   51,   49,
 /*    10 */    49,   44,  103,  366,   36,   43,   43,   43,   43,   37,
 /*    20 */    37,   37,   37,   37,  138,   47,   47,  160,   78,   52,
 /*    30 */    52,   51,   49,   49,   44,  244,  353,  352,  165,  351,
 /*    40 */   350,  349,  348,   45,   46,  203,   13,   39,   38,  238,
 /*    50 */   338,   78,   42,   42,   36,   43,   43,   43,   43,   37,
 /*    60 */    37,   37,   37,   37,  356,   47,   47,  322,  298,   52,
 /*    70 */    52,   51,   49,   49,   44,   84,  321,  317,  228,  227,
 /*    80 */   200,  199,  198,  229,  194,  182,  282,  195,   41,   40,
 /*    90 */   219,   78,  246,  318,  243,  276,  202,   21,  156,  145,
 /*   100 */   104,  278,  361,   43,   43,   43,   43,   37,   37,   37,
 /*   110 */    37,   37,  327,   47,   47,    6,  313,   52,   52,   51,
 /*   120 */    49,   49,   44,  244,  353,  263,  262,  193,  137,   50,
 /*   130 */   355,   45,   46,  203,   13,   39,   38,  238,  338,   78,
 /*   140 */    42,   42,   36,   43,   43,   43,   43,   37,   37,   37,
 /*   150 */    37,   37,  226,   47,   47,  286,  285,   52,   52,   51,
 /*   160 */    49,   49,   44,   41,   40,  246,   37,  304,   47,   47,
 /*   170 */   357,  197,   52,   52,   51,   49,   49,   44,   28,   78,
 /*   180 */    26,   52,   52,   51,   49,   49,   44,  332,  127,  351,
 /*   190 */   350,  349,  348,  175,   78,  246,  356,  304,  173,  172,
 /*   200 */   171,  189,  133,   78,  364,  363,   45,   46,  203,   13,
 /*   210 */    39,   38,  238,  338,  339,   42,   42,   36,   43,   43,
 /*   220 */    43,   43,   37,   37,   37,   37,   37,    1,   47,   47,
 /*   230 */    48,   50,   52,   52,   51,   49,   49,   44,   41,   40,
 /*   240 */   280,  279,  246,  347,  243,   37,   37,   37,   37,   37,
 /*   250 */    63,   47,   47,  132,   78,   52,   52,   51,   49,   49,
 /*   260 */    44,  232,  355,  335,  173,  172,  171,  246,  302,  205,
 /*   270 */   362,  267,  266,  244,  353,   82,  139,   78,  173,  172,
 /*   280 */   171,   45,   46,  203,   13,   39,   38,  238,  338,  356,
 /*   290 */    42,   42,   36,   43,   43,   43,   43,   37,   37,   37,
 /*   300 */    37,   37,  357,   47,   47,  146,  311,   52,   52,   51,
 /*   310 */    49,   49,   44,  183,  342,   41,   40,  184,    3,  334,
 /*   320 */   242,  337,  243,  368,  204,  173,  172,  171,  104,   78,
 /*   330 */   361,  368,  368,  368,  271,  291,  140,  131,  289,  261,
 /*   340 */   278,  278,  225,  287,  265,  264,  336,  333,  288,  328,
 /*   350 */   234,  244,  353,    2,  356,  355,  174,   77,   45,   46,
 /*   360 */   203,   13,   39,   38,  238,  338,   50,   42,   42,   36,
 /*   370 */    43,   43,   43,   43,   37,   37,   37,   37,   37,  196,
 /*   380 */    47,   47,   66,  181,   52,   52,   51,   49,   49,   44,
 /*   390 */   246,  155,  243,   79,  201,  357,   41,   40,  104,  235,
 /*   400 */   361,  242,  295,  243,   34,  246,   78,  243,  305,   65,
 /*   410 */    11,  178,   57,   95,  222,  215,  218,  364,  363,  346,
 /*   420 */   355,  244,  353,   56,  153,   76,  230,  173,  172,  171,
 /*   430 */   401,  296,  244,  353,  135,  126,  244,  353,   27,   45,
 /*   440 */    46,  203,   13,   39,   38,  238,  338,  356,   42,   42,
 /*   450 */    36,   43,   43,   43,   43,   37,   37,   37,   37,   37,
 /*   460 */   357,   47,   47,  326,  150,   52,   52,   51,   49,   49,
 /*   470 */    44,   82,  309,  180,   20,   73,  185,   41,   40,   55,
 /*   480 */   246,   50,  243,  246,   68,  243,   10,   78,   90,  340,
 /*   490 */   361,   90,   53,  361,  213,  122,   59,  173,  172,  171,
 /*   500 */   152,  146,  284,  208,  277,  246,  148,  358,  224,  146,
 /*   510 */   278,  244,  353,  355,  244,  353,  356,   58,  129,   24,
 /*   520 */    45,   46,  203,   13,   39,   38,  238,  338,  254,   42,
 /*   530 */    42,   36,   43,   43,   43,   43,   37,   37,   37,   37,
 /*   540 */    37,   18,   47,   47,  253,   50,   52,   52,   51,   49,
 /*   550 */    49,   44,  289,  357,   41,   40,  246,  287,  243,  376,
 /*   560 */   192,   50,  288,  246,  104,  243,  401,  191,   78,  329,
 /*   570 */   221,  104,  186,  376,  376,  325,  284,  173,  172,  171,
 /*   580 */   273,  316,  355,  173,  172,  171,  278,  244,  353,  361,
 /*   590 */   220,   62,  323,  196,  244,  353,   57,   45,   46,  203,
 /*   600 */    13,   39,   38,  238,  338,  341,   42,   42,   36,   43,
 /*   610 */    43,   43,   43,   37,   37,   37,   37,   37,  315,   47,
 /*   620 */    47,  314,  357,   52,   52,   51,   49,   49,   44,   41,
 /*   630 */    40,  246,  312,  243,  246,  190,  243,   75,  284,  104,
 /*   640 */    44,  158,  108,  293,  246,   78,  239,  186,   16,  173,
 /*   650 */   172,  171,  252,  375,  360,  310,  246,   78,  306,  188,
 /*   660 */   361,   54,  244,  353,  361,  244,  353,  375,  375,   76,
 /*   670 */   284,  361,   45,   35,  203,   13,   39,   38,  238,  338,
 /*   680 */   320,   42,   42,   36,   43,   43,   43,   43,   37,   37,
 /*   690 */    37,   37,   37,  341,   47,   47,  308,  292,   52,   52,
 /*   700 */    51,   49,   49,   44,   41,   40,  246,  297,  243,  246,
 /*   710 */   359,  243,  341,  246,  124,  243,  179,  142,  187,  281,
 /*   720 */    78,  107,  564,  147,  246,  125,  301,  361,  270,  246,
 /*   730 */   246,  151,  149,  361,  278,  361,  217,  244,  353,  269,
 /*   740 */   244,  353,  361,  216,  244,  353,   72,   45,   33,  203,
 /*   750 */    13,   39,   38,  238,  338,  300,   42,   42,   36,   43,
 /*   760 */    43,   43,   43,   37,   37,   37,   37,   37,  154,   47,
 /*   770 */    47,    9,  211,   52,   52,   51,   49,   49,   44,   41,
 /*   780 */    40,  246,    8,  243,  246,  246,  243,  207,  246,  143,
 /*   790 */   243,    7,   89,  251,  260,   78,  123,  246,   15,  206,
 /*   800 */   278,   70,   60,   14,  177,  176,   83,  294,  164,   81,
 /*   810 */    80,   53,  244,  353,   78,  244,  353,  144,   25,  244,
 /*   820 */   353,  163,  341,   46,  203,   13,   39,   38,  238,  338,
 /*   830 */   356,   42,   42,   36,   43,   43,   43,   43,   37,   37,
 /*   840 */    37,   37,   37,  231,   47,   47,  162,   19,   52,   52,
 /*   850 */    51,   49,   49,   44,   41,   40,  246,  233,  243,  246,
 /*   860 */   159,  243,  324,  246,  112,  243,  356,  109,  161,   23,
 /*   870 */    78,  169,  356,   17,  307,  223,  220,   57,  283,  275,
 /*   880 */   272,  240,  299,   74,  178,  268,   67,  244,  353,  136,
 /*   890 */   244,  353,  209,   71,  244,  353,  355,  210,  214,  203,
 /*   900 */    13,   39,   38,  238,  338,   61,   42,   42,   36,   43,
 /*   910 */    43,   43,   43,   37,   37,   37,   37,   37,  212,   47,
 /*   920 */    47,  250,  356,   52,   52,   51,   49,   49,   44,   69,
 /*   930 */   248,  240,  355,   85,  170,  237,  357,  303,  355,  335,
 /*   940 */   157,  249,   30,  319,  356,   78,  130,  356,  246,  356,
 /*   950 */   243,  245,  246,  240,  243,  354,  120,  258,  257,  289,
 /*   960 */   118,  256,  344,  241,  287,  290,   31,   32,  345,  288,
 /*   970 */   128,  274,  357,  247,  259,   29,    4,  255,  357,  244,
 /*   980 */   353,  565,  565,  244,  353,  356,  565,  565,  355,  335,
 /*   990 */   565,  565,   30,  565,  356,  334,  565,  220,  330,  246,
 /*  1000 */   196,  243,  565,  240,  565,  565,  146,  117,  134,  565,
 /*  1010 */   355,  335,  356,  355,   30,  355,   31,   32,   12,  565,
 /*  1020 */   565,  240,  336,  333,  236,   29,    5,  331,  357,  565,
 /*  1030 */   244,  353,  565,  565,  246,  565,  243,  565,   31,   32,
 /*  1040 */   345,  565,  116,  565,  246,  334,  243,   29,    5,  565,
 /*  1050 */   357,  355,  115,  357,  246,  357,  243,  565,  565,  565,
 /*  1060 */   355,  335,  114,  565,   30,  244,  353,  334,   12,  565,
 /*  1070 */   565,  565,  336,  333,  236,  244,  353,  331,  355,  335,
 /*  1080 */   565,  343,   30,  565,  565,  244,  353,  565,   31,   32,
 /*  1090 */    12,  357,  565,  565,  336,  333,  236,   29,    4,  331,
 /*  1100 */   357,  246,  565,  243,  565,  565,   31,   32,  565,  121,
 /*  1110 */   565,  246,  565,  243,  565,   29,    5,  334,  357,  106,
 /*  1120 */   565,  246,  565,  243,  565,  565,  565,  565,  146,  119,
 /*  1130 */   565,  565,  244,  353,  565,  334,  565,  565,  565,  246,
 /*  1140 */    12,  243,  244,  353,  336,  333,  236,  105,  246,  331,
 /*  1150 */   243,  565,  244,  353,  565,  565,  111,  246,   12,  243,
 /*  1160 */   565,  565,  336,  333,  236,  168,  565,  331,  565,  565,
 /*  1170 */   244,  353,  565,  246,  565,  243,  246,  565,  243,  244,
 /*  1180 */   353,  167,  565,  565,  110,  246,  565,  243,  244,  353,
 /*  1190 */   246,  565,  243,  166,  246,  565,  243,  565,   88,  565,
 /*  1200 */   565,  246,  102,  243,  244,  353,  565,  244,  353,  101,
 /*  1210 */   565,  246,  565,  243,  565,  565,  244,  353,  565,   87,
 /*  1220 */   565,  244,  353,  565,  565,  244,  353,  246,  565,  243,
 /*  1230 */   565,  565,  244,  353,  565,  100,  565,  246,  565,  243,
 /*  1240 */   565,  565,  244,  353,  565,   86,  246,  565,  243,  246,
 /*  1250 */   565,  243,  565,  565,   99,  565,  565,   98,  244,  353,
 /*  1260 */   565,  565,  246,  565,  243,  565,  565,  565,  244,  353,
 /*  1270 */    64,  246,  565,  243,  246,  565,  243,  244,  353,   97,
 /*  1280 */   244,  353,   96,  565,  246,  565,  243,  565,  246,  565,
 /*  1290 */   243,  565,   94,  244,  353,  565,   93,  565,  565,  565,
 /*  1300 */   565,  565,  244,  353,  565,  244,  353,  565,  565,  565,
 /*  1310 */   565,  565,  565,  565,  565,  244,  353,  565,  565,  244,
 /*  1320 */   353,  246,  565,  243,  565,  246,  565,  243,  565,   92,
 /*  1330 */   246,  565,  243,   91,  565,  565,  565,  565,  113,  565,
 /*  1340 */   565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
 /*  1350 */   565,  565,  244,  353,  565,  565,  244,  353,  565,  565,
 /*  1360 */   565,  244,  353,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    26,   27,    0,  172,  172,  174,  174,   33,   97,   98,
 /*    10 */    99,  100,  180,    0,   80,   81,   82,   83,   84,   85,
 /*    20 */    86,   87,   88,   89,  144,   91,   92,  196,  117,   95,
 /*    30 */    96,   97,   98,   99,  100,  203,  204,  155,  206,  157,
 /*    40 */   158,  159,  160,   69,   70,   71,   72,   73,   74,   75,
 /*    50 */    76,  117,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    60 */    86,   87,   88,   89,    1,   91,   92,    5,  123,   95,
 /*    70 */    96,   97,   98,   99,  100,  130,   14,  107,  108,  109,
 /*    80 */   110,  111,  112,  113,   23,  165,   53,   54,   26,   27,
 /*    90 */    57,  117,  172,  123,  174,  166,  176,  123,  169,  185,
 /*   100 */   180,  172,  182,   81,   82,   83,   84,   85,   86,   87,
 /*   110 */    88,   89,  106,   91,   92,  201,  107,   95,   96,   97,
 /*   120 */    98,   99,  100,  203,  204,   64,   65,   66,  144,  123,
 /*   130 */    67,   69,   70,   71,   72,   73,   74,   75,   76,  117,
 /*   140 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   150 */    88,   89,  143,   91,   92,   58,   59,   95,   96,   97,
 /*   160 */    98,   99,  100,   26,   27,  172,   89,  174,   91,   92,
 /*   170 */   107,  178,   95,   96,   97,   98,   99,  100,  148,  117,
 /*   180 */   150,   95,   96,   97,   98,   99,  100,  155,  125,  157,
 /*   190 */   158,  159,  160,  154,  117,  172,    1,  174,  114,  115,
 /*   200 */   116,  178,  144,  117,  120,  121,   69,   70,   71,   72,
 /*   210 */    73,   74,   75,   76,  106,   78,   79,   80,   81,   82,
 /*   220 */    83,   84,   85,   86,   87,   88,   89,  105,   91,   92,
 /*   230 */   105,  123,   95,   96,   97,   98,   99,  100,   26,   27,
 /*   240 */    55,   56,  172,  106,  174,   85,   86,   87,   88,   89,
 /*   250 */   180,   91,   92,  144,  117,   95,   96,   97,   98,   99,
 /*   260 */   100,  191,   67,   68,  114,  115,  116,  172,    1,  174,
 /*   270 */   106,   64,   65,  203,  204,  105,  181,  117,  114,  115,
 /*   280 */   116,   69,   70,   71,   72,   73,   74,   75,   76,    1,
 /*   290 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   300 */    88,   89,  107,   91,   92,  135,  107,   95,   96,   97,
 /*   310 */    98,   99,  100,  165,  106,   26,   27,  106,  105,  124,
 /*   320 */   172,   17,  174,  106,  176,  114,  115,  116,  180,  117,
 /*   330 */   182,  114,  115,  116,  166,  166,  167,  168,   13,  171,
 /*   340 */   172,  172,  143,   18,   64,   65,  151,  152,   23,  106,
 /*   350 */   202,  203,  204,  105,    1,   67,  154,  145,   69,   70,
 /*   360 */    71,   72,   73,   74,   75,   76,  123,   78,   79,   80,
 /*   370 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   54,
 /*   380 */    91,   92,    8,  165,   95,   96,   97,   98,   99,  100,
 /*   390 */   172,   17,  174,  105,  176,  107,   26,   27,  180,   75,
 /*   400 */   182,  172,  134,  174,   80,  172,  117,  174,  106,  180,
 /*   410 */   138,   58,  145,  180,  146,   62,   63,  120,  121,  106,
 /*   420 */    67,  203,  204,   49,   50,  123,  193,  114,  115,  116,
 /*   430 */    51,  202,  203,  204,   60,   61,  203,  204,  149,   69,
 /*   440 */    70,   71,   72,   73,   74,   75,   76,    1,   78,   79,
 /*   450 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   460 */   107,   91,   92,  106,  106,   95,   96,   97,   98,   99,
 /*   470 */   100,  105,  107,  165,  123,  122,  165,   26,   27,  105,
 /*   480 */   172,  123,  174,  172,  123,  174,  138,  117,  180,  106,
 /*   490 */   182,  180,  131,  182,  128,  194,  195,  114,  115,  116,
 /*   500 */   126,  135,  123,  129,  166,  172,  132,  174,  143,  135,
 /*   510 */   172,  203,  204,   67,  203,  204,    1,  167,  168,  149,
 /*   520 */    69,   70,   71,   72,   73,   74,   75,   76,  106,   78,
 /*   530 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   540 */    89,  123,   91,   92,  106,  123,   95,   96,   97,   98,
 /*   550 */    99,  100,   13,  107,   26,   27,  172,   18,  174,  106,
 /*   560 */   176,  123,   23,  172,  180,  174,   51,  176,  117,  106,
 /*   570 */   163,  180,  165,  120,  121,  106,  123,  114,  115,  116,
 /*   580 */   166,  107,   67,  114,  115,  116,  172,  203,  204,  182,
 /*   590 */    51,  105,  192,   54,  203,  204,  145,   69,   70,   71,
 /*   600 */    72,   73,   74,   75,   76,  205,   78,   79,   80,   81,
 /*   610 */    82,   83,   84,   85,   86,   87,   88,   89,  107,   91,
 /*   620 */    92,  107,  107,   95,   96,   97,   98,   99,  100,   26,
 /*   630 */    27,  172,  107,  174,  172,  176,  174,  122,  123,  180,
 /*   640 */   100,  106,  180,  165,  172,  117,  174,  165,  142,  114,
 /*   650 */   115,  116,  106,  106,  165,  107,  172,  117,  174,   52,
 /*   660 */   182,  122,  203,  204,  182,  203,  204,  120,  121,  123,
 /*   670 */   123,  182,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   680 */   192,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   690 */    87,   88,   89,  205,   91,   92,  107,  106,   95,   96,
 /*   700 */    97,   98,   99,  100,   26,   27,  172,  200,  174,  172,
 /*   710 */   165,  174,  205,  172,  180,  174,  165,  180,  165,   54,
 /*   720 */   117,  180,  162,  163,  172,  165,  174,  182,  166,  172,
 /*   730 */   172,  174,  174,  182,  172,  182,   68,  203,  204,  124,
 /*   740 */   203,  204,  182,  123,  203,  204,  127,   69,   70,   71,
 /*   750 */    72,   73,   74,   75,   76,  203,   78,   79,   80,   81,
 /*   760 */    82,   83,   84,   85,   86,   87,   88,   89,   68,   91,
 /*   770 */    92,  105,  123,   95,   96,   97,   98,   99,  100,   26,
 /*   780 */    27,  172,  105,  174,  172,  172,  174,  174,  172,  180,
 /*   790 */   174,  105,  180,    1,  166,  117,  180,  172,   79,  174,
 /*   800 */   172,  130,  133,   79,  209,  209,  183,  134,  179,  183,
 /*   810 */   183,  131,  203,  204,  117,  203,  204,  207,  148,  203,
 /*   820 */   204,  187,  205,   70,   71,   72,   73,   74,   75,   76,
 /*   830 */     1,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   840 */    87,   88,   89,  140,   91,   92,  188,  139,   95,   96,
 /*   850 */    97,   98,   99,  100,   26,   27,  172,  137,  174,  172,
 /*   860 */   197,  174,  190,  172,  180,  174,    1,  180,  189,  136,
 /*   870 */   117,  180,    1,  142,  198,  141,   51,  145,  168,  168,
 /*   880 */   122,   10,  200,  170,   58,  171,  170,  203,  204,   60,
 /*   890 */   203,  204,   69,  175,  203,  204,   67,  123,  173,   71,
 /*   900 */    72,   73,   74,   75,   76,  105,   78,   79,   80,   81,
 /*   910 */    82,   83,   84,   85,   86,   87,   88,   89,  177,   91,
 /*   920 */    92,  179,    1,   95,   96,   97,   98,   99,  100,  173,
 /*   930 */   164,   10,   67,  184,  186,  208,  107,  200,   67,   68,
 /*   940 */   169,  179,   71,  199,    1,  117,  169,    1,  172,    1,
 /*   950 */   174,  172,  172,   10,  174,  172,  180,  172,  172,   13,
 /*   960 */   180,  172,   97,  172,   18,  167,   95,   96,   97,   23,
 /*   970 */   169,  167,  107,  164,  172,  104,  105,  172,  107,  203,
 /*   980 */   204,  210,  210,  203,  204,    1,  210,  210,   67,   68,
 /*   990 */   210,  210,   71,  210,    1,  124,  210,   51,   77,  172,
 /*  1000 */    54,  174,  210,   10,  210,  210,  135,  180,   60,  210,
 /*  1010 */    67,   68,    1,   67,   71,   67,   95,   96,  147,  210,
 /*  1020 */   210,   10,  151,  152,  153,  104,  105,  156,  107,  210,
 /*  1030 */   203,  204,  210,  210,  172,  210,  174,  210,   95,   96,
 /*  1040 */    97,  210,  180,  210,  172,  124,  174,  104,  105,  210,
 /*  1050 */   107,   67,  180,  107,  172,  107,  174,  210,  210,  210,
 /*  1060 */    67,   68,  180,  210,   71,  203,  204,  124,  147,  210,
 /*  1070 */   210,  210,  151,  152,  153,  203,  204,  156,   67,   68,
 /*  1080 */   210,   97,   71,  210,  210,  203,  204,  210,   95,   96,
 /*  1090 */   147,  107,  210,  210,  151,  152,  153,  104,  105,  156,
 /*  1100 */   107,  172,  210,  174,  210,  210,   95,   96,  210,  180,
 /*  1110 */   210,  172,  210,  174,  210,  104,  105,  124,  107,  180,
 /*  1120 */   210,  172,  210,  174,  210,  210,  210,  210,  135,  180,
 /*  1130 */   210,  210,  203,  204,  210,  124,  210,  210,  210,  172,
 /*  1140 */   147,  174,  203,  204,  151,  152,  153,  180,  172,  156,
 /*  1150 */   174,  210,  203,  204,  210,  210,  180,  172,  147,  174,
 /*  1160 */   210,  210,  151,  152,  153,  180,  210,  156,  210,  210,
 /*  1170 */   203,  204,  210,  172,  210,  174,  172,  210,  174,  203,
 /*  1180 */   204,  180,  210,  210,  180,  172,  210,  174,  203,  204,
 /*  1190 */   172,  210,  174,  180,  172,  210,  174,  210,  180,  210,
 /*  1200 */   210,  172,  180,  174,  203,  204,  210,  203,  204,  180,
 /*  1210 */   210,  172,  210,  174,  210,  210,  203,  204,  210,  180,
 /*  1220 */   210,  203,  204,  210,  210,  203,  204,  172,  210,  174,
 /*  1230 */   210,  210,  203,  204,  210,  180,  210,  172,  210,  174,
 /*  1240 */   210,  210,  203,  204,  210,  180,  172,  210,  174,  172,
 /*  1250 */   210,  174,  210,  210,  180,  210,  210,  180,  203,  204,
 /*  1260 */   210,  210,  172,  210,  174,  210,  210,  210,  203,  204,
 /*  1270 */   180,  172,  210,  174,  172,  210,  174,  203,  204,  180,
 /*  1280 */   203,  204,  180,  210,  172,  210,  174,  210,  172,  210,
 /*  1290 */   174,  210,  180,  203,  204,  210,  180,  210,  210,  210,
 /*  1300 */   210,  210,  203,  204,  210,  203,  204,  210,  210,  210,
 /*  1310 */   210,  210,  210,  210,  210,  203,  204,  210,  210,  203,
 /*  1320 */   204,  172,  210,  174,  210,  172,  210,  174,  210,  180,
 /*  1330 */   172,  210,  174,  180,  210,  210,  210,  210,  180,  210,
 /*  1340 */   210,  210,  210,  210,  210,  210,  210,  210,  210,  210,
 /*  1350 */   210,  210,  203,  204,  210,  210,  203,  204,  210,  210,
 /*  1360 */   210,  203,  204,
};
#define YY_SHIFT_USE_DFLT (-121)
#define YY_SHIFT_COUNT (248)
#define YY_SHIFT_MIN   (-120)
#define YY_SHIFT_MAX   (1011)
static const short yy_shift_ofst[] = {
 /*     0 */   374,  871,  993,  993,  993,  993,  943, 1011, 1011, 1011,
 /*    10 */  1011, 1011, 1011,  921, 1011, 1011, 1011, 1011, 1011, 1011,
 /*    20 */  1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
 /*    30 */  1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
 /*    40 */  1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011, 1011,
 /*    50 */  1011, 1011, 1011, 1011,  946,  374,  353,  195,  515,  288,
 /*    60 */   446,  446,  446,   62,   62,  451,  539,   63,  446,  446,
 /*    70 */   446,  366,  446,  446,  446,  446,  446,  446,  446,  170,
 /*    80 */   170,  170,  170,  170, -121, -121,  -26,  370,  289,  212,
 /*    90 */   137,  528,  528,  528,  528,  528,  528,  528,  528,  528,
 /*   100 */   528,  528,  528,  528,  528,  678,  603,  528,  528,  753,
 /*   110 */   828,  828,  828,  -66,  -66,  -66,  -66,  -66,  -66,   22,
 /*   120 */   160,   77,  -30,   86,  -89,   84,  948,  829,  325,  547,
 /*   130 */   325,  453,  984,  865,  446,  446,  446,  446,  446,  361,
 /*   140 */   379,  267,  540,  540,   30,  -55,  268,  297,  823,  680,
 /*   150 */   774,  800,  823,  758,  826,  758,  825,  825,  732,  734,
 /*   160 */   731,  733,  720,  708,  703,  670,  697,  697,  697,  697,
 /*   170 */   680,  673,  673,  673, -121, -121,   32, -118,   61,  535,
 /*   180 */   469,  463,  383,  313,  217,  211,  164,  150,   33,  546,
 /*   190 */   438,  422,  358,  280,  207,  185,   97,  302,  365,  199,
 /*   200 */     9,  243,  108,  324,    6,  724,  719,  669,  671,  792,
 /*   210 */   686,  677,  649,  666,  619,  700,  615,  620,  668,  665,
 /*   220 */   607,  591,  506,  486,  589,  548,  525,  514,  511,  474,
 /*   230 */   418,  348,  351,  272,  357,  248,  202,  304,  213,  208,
 /*   240 */   125,  109,   58,  122,   39,  -16, -120,   13,    2,
};
#define YY_REDUCE_USE_DFLT (-170)
#define YY_REDUCE_COUNT (175)
#define YY_REDUCE_MIN   (-169)
#define YY_REDUCE_MAX   (1158)
static const short yy_reduce_ofst[] = {
 /*     0 */   560,  148,  218,  -80,  311,  308,  229,  459,  391,  384,
 /*    10 */   233,   70, -168, 1158, 1153, 1149, 1116, 1112, 1102, 1099,
 /*    20 */  1090, 1077, 1074, 1065, 1055, 1039, 1029, 1022, 1018, 1013,
 /*    30 */  1004, 1001,  985,  976,  967,  949,  939,  929,  882,  872,
 /*    40 */   862,  827,  780,  776,  691,  687,  684,  616,  612,  609,
 /*    50 */   541,  537,  534,  462,  169,  407,  168,  552,  -71, -169,
 /*    60 */    95,   23,   -7,  488,  400,  507,  350,  628,  625,  613,
 /*    70 */   558,  553,  557,  562,  414,  338,  484,  472,  333,  551,
 /*    80 */   545,  489,  482,  478,  301,  -86,  617,  617,  617,  617,
 /*    90 */   617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
 /*   100 */   617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
 /*   110 */   617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
 /*   120 */   617,  617,  744,  617,  617,  809,  805,  802,  804,  801,
 /*   130 */   798,  777,  783,  791,  789,  786,  785,  783,  779,  762,
 /*   140 */   771,  737,  617,  617,  727,  748,  749,  766,  756,  742,
 /*   150 */   741,  718,  725,  716,  714,  713,  711,  710,  682,  676,
 /*   160 */   663,  672,  679,  658,  634,  610,  617,  617,  617,  617,
 /*   170 */   629,  627,  626,  623,  596,  595,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   563,  497,  497,  497,  563,  563,  563,  497,  497,  497,
 /*    10 */   563,  563,  538,  563,  563,  563,  563,  563,  563,  563,
 /*    20 */   563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
 /*    30 */   563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
 /*    40 */   563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
 /*    50 */   563,  563,  563,  563,  407,  563,  407,  563,  407,  563,
 /*    60 */   563,  563,  563,  453,  453,  490,  371,  407,  563,  563,
 /*    70 */   563,  563,  563,  407,  407,  407,  563,  563,  563,  563,
 /*    80 */   563,  563,  563,  563,  463,  482,  444,  563,  563,  563,
 /*    90 */   563,  435,  434,  494,  465,  496,  495,  455,  446,  445,
 /*   100 */   540,  541,  539,  537,  499,  563,  563,  498,  432,  516,
 /*   110 */   527,  526,  515,  530,  523,  522,  521,  520,  519,  525,
 /*   120 */   518,  524,  459,  512,  509,  563,  563,  563,  563,  401,
 /*   130 */   563,  401,  563,  563,  563,  563,  563,  563,  563,  431,
 /*   140 */   377,  490,  510,  511,  542,  458,  491,  563,  422,  431,
 /*   150 */   419,  426,  422,  399,  387,  399,  563,  563,  490,  462,
 /*   160 */   466,  443,  447,  454,  456,  563,  528,  514,  513,  517,
 /*   170 */   431,  440,  440,  440,  552,  552,  563,  563,  563,  563,
 /*   180 */   563,  563,  563,  563,  531,  563,  563,  421,  563,  563,
 /*   190 */   563,  563,  563,  392,  391,  563,  563,  563,  563,  563,
 /*   200 */   563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
 /*   210 */   563,  563,  420,  563,  563,  563,  563,  385,  563,  563,
 /*   220 */   563,  563,  493,  563,  563,  563,  563,  563,  563,  563,
 /*   230 */   457,  563,  448,  563,  563,  563,  563,  563,  563,  563,
 /*   240 */   563,  561,  560,  503,  501,  561,  560,  563,  563,  433,
 /*   250 */   430,  423,  427,  425,  424,  416,  415,  414,  418,  417,
 /*   260 */   390,  389,  394,  393,  398,  397,  396,  395,  388,  386,
 /*   270 */   384,  383,  400,  382,  381,  380,  374,  373,  408,  406,
 /*   280 */   405,  404,  403,  378,  402,  413,  412,  411,  410,  409,
 /*   290 */   379,  372,  367,  437,  441,  492,  484,  483,  481,  480,
 /*   300 */   489,  488,  479,  478,  429,  461,  428,  460,  477,  476,
 /*   310 */   475,  474,  473,  472,  471,  470,  469,  468,  467,  464,
 /*   320 */   450,  452,  451,  449,  442,  531,  506,  504,  534,  535,
 /*   330 */   544,  551,  549,  548,  547,  546,  545,  536,  543,  532,
 /*   340 */   533,  529,  507,  487,  486,  485,  505,  502,  556,  555,
 /*   350 */   554,  553,  550,  500,  562,  559,  558,  557,  508,  439,
 /*   360 */   438,  436,  368,  370,  369,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      ILIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*    TEXTUAL => nothing */
   67,  /*     STRING => TEXTUAL */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  priv_gda_sql_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void priv_gda_sql_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "ILIKE",       
  "MATCH",         "PLAN",          "QUERY",         "KEY",         
  "OF",            "OFFSET",        "PRAGMA",        "RAISE",       
  "REPLACE",       "RESTRICT",      "ROW",           "TEMP",        
  "TRIGGER",       "VACUUM",        "VIEW",          "VIRTUAL",     
  "REINDEX",       "RENAME",        "CTIME_KW",      "IF",          
  "DELIMITER",     "COMMIT",        "ROLLBACK",      "ISOLATION",   
  "LEVEL",         "SERIALIZABLE",  "READ",          "COMMITTED",   
  "UNCOMMITTED",   "REPEATABLE",    "WRITE",         "ONLY",        
  "SAVEPOINT",     "RELEASE",       "COMMENT",       "FORCE",       
  "WAIT",          "NOWAIT",        "BATCH",         "TEXTUAL",     
  "STRING",        "OR",            "AND",           "NOT",         
  "IS",            "NOTLIKE",       "NOTILIKE",      "IN",          
  "ISNULL",        "NOTNULL",       "DIFF",          "EQ",          
  "BETWEEN",       "GT",            "LEQ",           "LT",          
  "GEQ",           "REGEXP",        "REGEXP_CI",     "NOT_REGEXP",  
  "NOT_REGEXP_CI",  "SIMILAR",       "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "COLLATE",       "UMINUS",        "UPLUS",       
  "BITNOT",        "LP",            "RP",            "JOIN",        
  "INNER",         "NATURAL",       "LEFT",          "RIGHT",       
  "FULL",          "CROSS",         "UNION",         "EXCEPT",      
  "INTERSECT",     "PGCAST",        "ILLEGAL",       "SQLCOMMENT",  
  "SEMI",          "END_OF_FILE",   "TRANSACTION",   "COMMA",       
  "INTEGER",       "TO",            "INSERT",        "INTO",        
  "VALUES",        "DELETE",        "FROM",          "WHERE",       
  "UPDATE",        "SET",           "ALL",           "SELECT",      
  "LIMIT",         "ORDER",         "BY",            "HAVING",      
  "GROUP",         "USING",         "ON",            "OUTER",       
  "DOT",           "AS",            "DISTINCT",      "CASE",        
  "WHEN",          "THEN",          "ELSE",          "NULL",        
  "FLOAT",         "UNSPECVAL",     "LSBRACKET",     "RSBRACKET",   
  "SIMPLEPARAM",   "PNAME",         "PDESCR",        "PTYPE",       
  "PNULLOK",       "error",         "stmt",          "cmd",         
  "eos",           "compound",      "nm_opt",        "transtype",   
  "transilev",     "opt_comma",     "trans_opt_kw",  "ora_commit_write",
  "nm",            "opt_on_conflict",  "fullname",      "inscollist_opt",
  "rexprlist",     "ins_extra_values",  "inscollist",    "where_opt",   
  "expr",          "setlist",       "selectcmd",     "opt_compound_all",
  "distinct",      "selcollist",    "from",          "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sortlist",    
  "sortorder",     "rnexprlist",    "seltablist",    "stl_prefix",  
  "seltarget",     "on_cond",       "using_opt",     "jointype",    
  "as",            "sclp",          "starname",      "value",       
  "pvalue",        "uni_op",        "case_operand",  "case_exprlist",
  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP rexprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP rexprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP rexprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP rexprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY rnexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "rnexprlist ::= rnexprlist COMMA expr",
 /* 131 */ "rnexprlist ::= expr",
 /* 132 */ "rexprlist ::=",
 /* 133 */ "rexprlist ::= rexprlist COMMA expr",
 /* 134 */ "rexprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP rexprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr ILIKE expr",
 /* 157 */ "expr ::= expr NOTLIKE expr",
 /* 158 */ "expr ::= expr NOTILIKE expr",
 /* 159 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 160 */ "expr ::= expr BETWEEN expr AND expr",
 /* 161 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 162 */ "expr ::= NOT expr",
 /* 163 */ "expr ::= BITNOT expr",
 /* 164 */ "expr ::= expr uni_op",
 /* 165 */ "expr ::= expr IS expr",
 /* 166 */ "expr ::= LP compound RP",
 /* 167 */ "expr ::= expr IN LP rexprlist RP",
 /* 168 */ "expr ::= expr IN LP compound RP",
 /* 169 */ "expr ::= expr NOT IN LP rexprlist RP",
 /* 170 */ "expr ::= expr NOT IN LP compound RP",
 /* 171 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 172 */ "case_operand ::= expr",
 /* 173 */ "case_operand ::=",
 /* 174 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 175 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 176 */ "case_else ::= ELSE expr",
 /* 177 */ "case_else ::=",
 /* 178 */ "uni_op ::= ISNULL",
 /* 179 */ "uni_op ::= IS NOTNULL",
 /* 180 */ "value ::= NULL",
 /* 181 */ "value ::= STRING",
 /* 182 */ "value ::= INTEGER",
 /* 183 */ "value ::= FLOAT",
 /* 184 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 185 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 186 */ "pvalue ::= SIMPLEPARAM",
 /* 187 */ "paramspec ::=",
 /* 188 */ "paramspec ::= paramspec PNAME",
 /* 189 */ "paramspec ::= paramspec PDESCR",
 /* 190 */ "paramspec ::= paramspec PTYPE",
 /* 191 */ "paramspec ::= paramspec PNULLOK",
 /* 192 */ "nm ::= JOIN",
 /* 193 */ "nm ::= ID",
 /* 194 */ "nm ::= TEXTUAL",
 /* 195 */ "fullname ::= nm",
 /* 196 */ "fullname ::= nm DOT nm",
 /* 197 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to priv_gda_sql_parser and priv_gda_sql_parserFree.
*/
void *priv_gda_sql_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  priv_gda_sql_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
      /* TERMINAL Destructor */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* ILIKE */
    case 28: /* MATCH */
    case 29: /* PLAN */
    case 30: /* QUERY */
    case 31: /* KEY */
    case 32: /* OF */
    case 33: /* OFFSET */
    case 34: /* PRAGMA */
    case 35: /* RAISE */
    case 36: /* REPLACE */
    case 37: /* RESTRICT */
    case 38: /* ROW */
    case 39: /* TEMP */
    case 40: /* TRIGGER */
    case 41: /* VACUUM */
    case 42: /* VIEW */
    case 43: /* VIRTUAL */
    case 44: /* REINDEX */
    case 45: /* RENAME */
    case 46: /* CTIME_KW */
    case 47: /* IF */
    case 48: /* DELIMITER */
    case 49: /* COMMIT */
    case 50: /* ROLLBACK */
    case 51: /* ISOLATION */
    case 52: /* LEVEL */
    case 53: /* SERIALIZABLE */
    case 54: /* READ */
    case 55: /* COMMITTED */
    case 56: /* UNCOMMITTED */
    case 57: /* REPEATABLE */
    case 58: /* WRITE */
    case 59: /* ONLY */
    case 60: /* SAVEPOINT */
    case 61: /* RELEASE */
    case 62: /* COMMENT */
    case 63: /* FORCE */
    case 64: /* WAIT */
    case 65: /* NOWAIT */
    case 66: /* BATCH */
    case 67: /* TEXTUAL */
    case 68: /* STRING */
    case 69: /* OR */
    case 70: /* AND */
    case 71: /* NOT */
    case 72: /* IS */
    case 73: /* NOTLIKE */
    case 74: /* NOTILIKE */
    case 75: /* IN */
    case 76: /* ISNULL */
    case 77: /* NOTNULL */
    case 78: /* DIFF */
    case 79: /* EQ */
    case 80: /* BETWEEN */
    case 81: /* GT */
    case 82: /* LEQ */
    case 83: /* LT */
    case 84: /* GEQ */
    case 85: /* REGEXP */
    case 86: /* REGEXP_CI */
    case 87: /* NOT_REGEXP */
    case 88: /* NOT_REGEXP_CI */
    case 89: /* SIMILAR */
    case 90: /* ESCAPE */
    case 91: /* BITAND */
    case 92: /* BITOR */
    case 93: /* LSHIFT */
    case 94: /* RSHIFT */
    case 95: /* PLUS */
    case 96: /* MINUS */
    case 97: /* STAR */
    case 98: /* SLASH */
    case 99: /* REM */
    case 100: /* CONCAT */
    case 101: /* COLLATE */
    case 102: /* UMINUS */
    case 103: /* UPLUS */
    case 104: /* BITNOT */
    case 105: /* LP */
    case 106: /* RP */
    case 107: /* JOIN */
    case 108: /* INNER */
    case 109: /* NATURAL */
    case 110: /* LEFT */
    case 111: /* RIGHT */
    case 112: /* FULL */
    case 113: /* CROSS */
    case 114: /* UNION */
    case 115: /* EXCEPT */
    case 116: /* INTERSECT */
    case 117: /* PGCAST */
    case 118: /* ILLEGAL */
    case 119: /* SQLCOMMENT */
    case 120: /* SEMI */
    case 121: /* END_OF_FILE */
    case 122: /* TRANSACTION */
    case 123: /* COMMA */
    case 124: /* INTEGER */
    case 125: /* TO */
    case 126: /* INSERT */
    case 127: /* INTO */
    case 128: /* VALUES */
    case 129: /* DELETE */
    case 130: /* FROM */
    case 131: /* WHERE */
    case 132: /* UPDATE */
    case 133: /* SET */
    case 134: /* ALL */
    case 135: /* SELECT */
    case 136: /* LIMIT */
    case 137: /* ORDER */
    case 138: /* BY */
    case 139: /* HAVING */
    case 140: /* GROUP */
    case 141: /* USING */
    case 142: /* ON */
    case 143: /* OUTER */
    case 144: /* DOT */
    case 145: /* AS */
    case 146: /* DISTINCT */
    case 147: /* CASE */
    case 148: /* WHEN */
    case 149: /* THEN */
    case 150: /* ELSE */
    case 151: /* NULL */
    case 152: /* FLOAT */
    case 153: /* UNSPECVAL */
    case 154: /* LSBRACKET */
    case 155: /* RSBRACKET */
    case 156: /* SIMPLEPARAM */
    case 157: /* PNAME */
    case 158: /* PDESCR */
    case 159: /* PTYPE */
    case 160: /* PNULLOK */
{
#line 9 "./parser.y"
if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}
#line 1398 "parser.c"
}
      break;
    case 162: /* stmt */
{
#line 280 "./parser.y"
g_print ("Statement destroyed by parser: %p\n", (yypminor->yy116)); gda_sql_statement_free ((yypminor->yy116));
#line 1405 "parser.c"
}
      break;
    case 163: /* cmd */
    case 165: /* compound */
    case 182: /* selectcmd */
{
#line 303 "./parser.y"
gda_sql_statement_free ((yypminor->yy116));
#line 1414 "parser.c"
}
      break;
    case 175: /* inscollist_opt */
    case 178: /* inscollist */
    case 198: /* using_opt */
{
#line 480 "./parser.y"
if ((yypminor->yy333)) {g_slist_foreach ((yypminor->yy333), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy333));}
#line 1423 "parser.c"
}
      break;
    case 176: /* rexprlist */
    case 193: /* rnexprlist */
{
#line 766 "./parser.y"
if ((yypminor->yy325)) {g_slist_foreach ((yypminor->yy325), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy325));}
#line 1431 "parser.c"
}
      break;
    case 177: /* ins_extra_values */
{
#line 469 "./parser.y"
GSList *list;
		for (list = (yypminor->yy333); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy333));

#line 1444 "parser.c"
}
      break;
    case 179: /* where_opt */
    case 180: /* expr */
    case 188: /* having_opt */
    case 197: /* on_cond */
    case 204: /* pvalue */
{
#line 502 "./parser.y"
gda_sql_expr_free ((yypminor->yy70));
#line 1455 "parser.c"
}
      break;
    case 181: /* setlist */
{
#line 522 "./parser.y"
GSList *list;
	for (list = (yypminor->yy333); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy333));

#line 1470 "parser.c"
}
      break;
    case 184: /* distinct */
{
#line 752 "./parser.y"
if ((yypminor->yy297)) {if ((yypminor->yy297)->expr) gda_sql_expr_free ((yypminor->yy297)->expr); g_free ((yypminor->yy297));}
#line 1477 "parser.c"
}
      break;
    case 185: /* selcollist */
    case 201: /* sclp */
{
#line 709 "./parser.y"
g_slist_foreach ((yypminor->yy325), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy325));
#line 1485 "parser.c"
}
      break;
    case 186: /* from */
    case 194: /* seltablist */
    case 195: /* stl_prefix */
{
#line 635 "./parser.y"
gda_sql_select_from_free ((yypminor->yy191));
#line 1494 "parser.c"
}
      break;
    case 187: /* groupby_opt */
{
#line 630 "./parser.y"
if ((yypminor->yy333)) {g_slist_foreach ((yypminor->yy333), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy333));}
#line 1501 "parser.c"
}
      break;
    case 189: /* orderby_opt */
    case 191: /* sortlist */
{
#line 599 "./parser.y"
if ((yypminor->yy325)) {g_slist_foreach ((yypminor->yy325), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy325));}
#line 1509 "parser.c"
}
      break;
    case 190: /* limit_opt */
{
#line 592 "./parser.y"
gda_sql_expr_free ((yypminor->yy44).count); gda_sql_expr_free ((yypminor->yy44).offset);
#line 1516 "parser.c"
}
      break;
    case 196: /* seltarget */
{
#line 694 "./parser.y"
gda_sql_select_target_free ((yypminor->yy134));
#line 1523 "parser.c"
}
      break;
    case 206: /* case_operand */
    case 208: /* case_else */
{
#line 933 "./parser.y"
gda_sql_expr_free ((yypminor->yy146));
#line 1531 "parser.c"
}
      break;
    case 207: /* case_exprlist */
{
#line 938 "./parser.y"
g_slist_foreach ((yypminor->yy59).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy59).when_list);
	g_slist_foreach ((yypminor->yy59).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy59).then_list);
#line 1539 "parser.c"
}
      break;
    case 209: /* paramspec */
{
#line 976 "./parser.y"
gda_sql_param_spec_free ((yypminor->yy339));
#line 1546 "parser.c"
}
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos;

  if( pParser->yyidx<0 ) return 0;
  yytos = &pParser->yystack[pParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from priv_gda_sql_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void priv_gda_sql_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int priv_gda_sql_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   priv_gda_sql_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1732 "parser.c"
   priv_gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 162, 2 },
  { 162, 2 },
  { 163, 3 },
  { 165, 3 },
  { 164, 1 },
  { 164, 1 },
  { 163, 1 },
  { 163, 3 },
  { 163, 4 },
  { 163, 3 },
  { 163, 2 },
  { 163, 3 },
  { 163, 3 },
  { 163, 5 },
  { 163, 5 },
  { 163, 4 },
  { 163, 4 },
  { 163, 3 },
  { 163, 2 },
  { 163, 3 },
  { 163, 3 },
  { 163, 5 },
  { 163, 3 },
  { 163, 4 },
  { 163, 2 },
  { 163, 3 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 170, 0 },
  { 170, 1 },
  { 169, 0 },
  { 169, 1 },
  { 168, 3 },
  { 168, 4 },
  { 168, 4 },
  { 168, 4 },
  { 166, 0 },
  { 166, 1 },
  { 167, 1 },
  { 167, 1 },
  { 167, 1 },
  { 167, 2 },
  { 167, 2 },
  { 163, 2 },
  { 163, 3 },
  { 163, 2 },
  { 163, 4 },
  { 163, 5 },
  { 163, 9 },
  { 163, 10 },
  { 163, 6 },
  { 173, 0 },
  { 173, 2 },
  { 177, 5 },
  { 177, 4 },
  { 175, 0 },
  { 175, 3 },
  { 178, 3 },
  { 178, 1 },
  { 163, 4 },
  { 179, 0 },
  { 179, 2 },
  { 163, 6 },
  { 181, 5 },
  { 181, 3 },
  { 165, 1 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 183, 0 },
  { 183, 1 },
  { 182, 9 },
  { 190, 0 },
  { 190, 2 },
  { 190, 4 },
  { 190, 4 },
  { 189, 0 },
  { 189, 3 },
  { 191, 4 },
  { 191, 2 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 188, 0 },
  { 188, 2 },
  { 187, 0 },
  { 187, 3 },
  { 186, 0 },
  { 186, 2 },
  { 194, 4 },
  { 198, 4 },
  { 198, 0 },
  { 195, 0 },
  { 195, 2 },
  { 197, 2 },
  { 197, 0 },
  { 199, 1 },
  { 199, 1 },
  { 199, 2 },
  { 199, 2 },
  { 199, 2 },
  { 199, 2 },
  { 199, 3 },
  { 199, 2 },
  { 199, 3 },
  { 199, 2 },
  { 199, 3 },
  { 196, 2 },
  { 196, 2 },
  { 196, 4 },
  { 201, 2 },
  { 201, 0 },
  { 185, 3 },
  { 185, 2 },
  { 202, 1 },
  { 202, 3 },
  { 202, 5 },
  { 200, 2 },
  { 200, 2 },
  { 200, 0 },
  { 184, 0 },
  { 184, 1 },
  { 184, 1 },
  { 184, 3 },
  { 193, 3 },
  { 193, 1 },
  { 176, 0 },
  { 176, 3 },
  { 176, 1 },
  { 180, 1 },
  { 180, 1 },
  { 180, 3 },
  { 180, 1 },
  { 180, 4 },
  { 180, 4 },
  { 180, 4 },
  { 180, 6 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 2 },
  { 180, 2 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 180, 5 },
  { 180, 6 },
  { 180, 2 },
  { 180, 2 },
  { 180, 2 },
  { 180, 3 },
  { 180, 3 },
  { 180, 5 },
  { 180, 5 },
  { 180, 6 },
  { 180, 6 },
  { 180, 5 },
  { 206, 1 },
  { 206, 0 },
  { 207, 5 },
  { 207, 4 },
  { 208, 2 },
  { 208, 0 },
  { 205, 1 },
  { 205, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 1 },
  { 203, 1 },
  { 204, 4 },
  { 204, 4 },
  { 204, 1 },
  { 209, 0 },
  { 209, 2 },
  { 209, 2 },
  { 209, 2 },
  { 209, 2 },
  { 172, 1 },
  { 172, 1 },
  { 172, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  priv_gda_sql_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 281 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy116;}
#line 2044 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 282 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy116->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy116;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy116);
	}
}
#line 2062 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */ yytestcase(yyruleno==3);
#line 296 "./parser.y"
{yygotominor.yy116 = yymsp[-1].minor.yy116;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2070 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 299 "./parser.y"
{
  yy_destructor(yypParser,120,&yymsp[0].minor);
}
#line 2077 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 300 "./parser.y"
{
  yy_destructor(yypParser,121,&yymsp[0].minor);
}
#line 2084 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 308 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(yypParser,8,&yymsp[0].minor);
}
#line 2090 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 309 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2099 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 313 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[-2].minor.yy0);
						      gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2109 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 318 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[-1].minor.yy0);
					  gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
}
#line 2118 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 323 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[0].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-1].minor);
}
#line 2126 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 327 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[0].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2135 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 331 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,8,&yymsp[-2].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2144 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 335 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[-2].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[0].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,122,&yymsp[-3].minor);
}
#line 2154 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 340 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[0].minor.yy0);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[-2].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-4].minor);
  yy_destructor(yypParser,122,&yymsp[-3].minor);
}
#line 2164 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 345 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[-2].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[0].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2173 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 350 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy116, yymsp[0].minor.yy0);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy116, yymsp[-2].minor.yy169);
  yy_destructor(yypParser,8,&yymsp[-3].minor);
}
#line 2182 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 355 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,17,&yymsp[-2].minor);
}
#line 2190 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 359 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2198 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 363 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,122,&yymsp[-1].minor);
}
#line 2207 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 367 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,63,&yymsp[-1].minor);
  yy_destructor(yypParser,68,&yymsp[0].minor);
}
#line 2215 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 368 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-4].minor);
  yy_destructor(yypParser,63,&yymsp[-3].minor);
  yy_destructor(yypParser,68,&yymsp[-2].minor);
  yy_destructor(yypParser,123,&yymsp[-1].minor);
  yy_destructor(yypParser,124,&yymsp[0].minor);
}
#line 2225 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 369 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-2].minor);
  yy_destructor(yypParser,62,&yymsp[-1].minor);
  yy_destructor(yypParser,68,&yymsp[0].minor);
}
#line 2233 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 370 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-3].minor);
  yy_destructor(yypParser,62,&yymsp[-2].minor);
  yy_destructor(yypParser,68,&yymsp[-1].minor);
}
#line 2241 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 371 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(yypParser,49,&yymsp[-1].minor);
}
#line 2247 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 373 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-2].minor);
}
#line 2255 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 377 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,23,&yymsp[0].minor);
}
#line 2263 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 378 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,66,&yymsp[0].minor);
}
#line 2271 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2279 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2287 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 381 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2296 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,23,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2305 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 383 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,64,&yymsp[0].minor);
}
#line 2314 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 384 "./parser.y"
{
  yy_destructor(yypParser,58,&yymsp[-2].minor);
  yy_destructor(yypParser,66,&yymsp[-1].minor);
  yy_destructor(yypParser,65,&yymsp[0].minor);
}
#line 2323 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 387 "./parser.y"
{
  yy_destructor(yypParser,122,&yymsp[0].minor);
}
#line 2330 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 390 "./parser.y"
{
  yy_destructor(yypParser,123,&yymsp[0].minor);
}
#line 2337 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 393 "./parser.y"
{yygotominor.yy169 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(yypParser,51,&yymsp[-2].minor);
  yy_destructor(yypParser,52,&yymsp[-1].minor);
  yy_destructor(yypParser,53,&yymsp[0].minor);
}
#line 2345 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 394 "./parser.y"
{yygotominor.yy169 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,57,&yymsp[-1].minor);
  yy_destructor(yypParser,54,&yymsp[0].minor);
}
#line 2354 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 395 "./parser.y"
{yygotominor.yy169 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,55,&yymsp[0].minor);
}
#line 2363 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 396 "./parser.y"
{yygotominor.yy169 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(yypParser,51,&yymsp[-3].minor);
  yy_destructor(yypParser,52,&yymsp[-2].minor);
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,56,&yymsp[0].minor);
}
#line 2372 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */ yytestcase(yyruleno==57);
      case 125: /* as ::= */ yytestcase(yyruleno==125);
#line 398 "./parser.y"
{yygotominor.yy0 = NULL;}
#line 2379 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 44: /* transtype ::= DEFERRED */ yytestcase(yyruleno==44);
      case 45: /* transtype ::= IMMEDIATE */ yytestcase(yyruleno==45);
      case 46: /* transtype ::= EXCLUSIVE */ yytestcase(yyruleno==46);
      case 120: /* starname ::= STAR */ yytestcase(yyruleno==120);
      case 181: /* value ::= STRING */ yytestcase(yyruleno==181);
      case 182: /* value ::= INTEGER */ yytestcase(yyruleno==182);
      case 183: /* value ::= FLOAT */ yytestcase(yyruleno==183);
      case 192: /* nm ::= JOIN */ yytestcase(yyruleno==192);
      case 193: /* nm ::= ID */ yytestcase(yyruleno==193);
      case 194: /* nm ::= TEXTUAL */ yytestcase(yyruleno==194);
      case 195: /* fullname ::= nm */ yytestcase(yyruleno==195);
#line 399 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;}
#line 2395 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 404 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy0, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy0, "READ_WRITE");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,58,&yymsp[0].minor);
}
#line 2405 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 408 "./parser.y"
{yygotominor.yy0 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy0, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy0, "READ_ONLY");
  yy_destructor(yypParser,54,&yymsp[-1].minor);
  yy_destructor(yypParser,59,&yymsp[0].minor);
}
#line 2415 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 416 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2423 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 420 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2432 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 424 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,61,&yymsp[-1].minor);
}
#line 2440 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 428 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-3].minor);
  yy_destructor(yypParser,125,&yymsp[-1].minor);
}
#line 2449 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 432 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy116, yymsp[0].minor.yy0);
  yy_destructor(yypParser,50,&yymsp[-4].minor);
  yy_destructor(yypParser,125,&yymsp[-2].minor);
  yy_destructor(yypParser,60,&yymsp[-1].minor);
}
#line 2459 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP rexprlist RP */
#line 439 "./parser.y"
{
	yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy116, yymsp[-5].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy116, yymsp[-4].minor.yy333);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy116, g_slist_reverse (yymsp[-1].minor.yy325));
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy116, yymsp[-7].minor.yy0);
  yy_destructor(yypParser,126,&yymsp[-8].minor);
  yy_destructor(yypParser,127,&yymsp[-6].minor);
  yy_destructor(yypParser,128,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2475 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP rexprlist RP ins_extra_values */
#line 447 "./parser.y"
{
	yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy116, yymsp[-6].minor.yy0);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy116, yymsp[-5].minor.yy333);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy116, g_slist_reverse (yymsp[-2].minor.yy325));
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy116, yymsp[0].minor.yy333);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy116, yymsp[-8].minor.yy0);
  yy_destructor(yypParser,126,&yymsp[-9].minor);
  yy_destructor(yypParser,127,&yymsp[-7].minor);
  yy_destructor(yypParser,128,&yymsp[-4].minor);
  yy_destructor(yypParser,105,&yymsp[-3].minor);
  yy_destructor(yypParser,106,&yymsp[-1].minor);
}
#line 2492 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 456 "./parser.y"
{
        yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy116, yymsp[-2].minor.yy0);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy116, yymsp[-1].minor.yy333);
        gda_sql_statement_insert_take_select (yygotominor.yy116, yymsp[0].minor.yy116);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy116, yymsp[-4].minor.yy0);
  yy_destructor(yypParser,126,&yymsp[-5].minor);
  yy_destructor(yypParser,127,&yymsp[-3].minor);
}
#line 2505 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 466 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 2511 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP rexprlist RP */
#line 476 "./parser.y"
{yygotominor.yy333 = g_slist_append (yymsp[-4].minor.yy333, g_slist_reverse (yymsp[-1].minor.yy325));  yy_destructor(yypParser,123,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2519 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP rexprlist RP */
#line 477 "./parser.y"
{yygotominor.yy333 = g_slist_append (NULL, g_slist_reverse (yymsp[-1].minor.yy325));  yy_destructor(yypParser,123,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2527 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */ yytestcase(yyruleno==97);
#line 481 "./parser.y"
{yygotominor.yy333 = NULL;}
#line 2533 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 482 "./parser.y"
{yygotominor.yy333 = yymsp[-1].minor.yy333;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2540 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 486 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy0);
						    yygotominor.yy333 = g_slist_append (yymsp[-2].minor.yy333, field);
  yy_destructor(yypParser,123,&yymsp[-1].minor);
}
#line 2550 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 491 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy0);
				yygotominor.yy333 = g_slist_prepend (NULL, field);
}
#line 2558 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 497 "./parser.y"
{yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy116, yymsp[-1].minor.yy0);
						  gda_sql_statement_delete_take_condition (yygotominor.yy116, yymsp[0].minor.yy70);  yy_destructor(yypParser,129,&yymsp[-3].minor);
  yy_destructor(yypParser,130,&yymsp[-2].minor);
}
#line 2567 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */ yytestcase(yyruleno==89);
      case 101: /* on_cond ::= */ yytestcase(yyruleno==101);
#line 503 "./parser.y"
{yygotominor.yy70 = NULL;}
#line 2574 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 504 "./parser.y"
{yygotominor.yy70 = yymsp[0].minor.yy70;  yy_destructor(yypParser,131,&yymsp[-1].minor);
}
#line 2580 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 507 "./parser.y"
{
	GSList *list;
	yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy116, yymsp[-3].minor.yy0);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy116, yymsp[-4].minor.yy0);
	gda_sql_statement_update_take_condition (yygotominor.yy116, yymsp[0].minor.yy70);
	for (list = yymsp[-1].minor.yy333; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy116, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy333);
  yy_destructor(yypParser,132,&yymsp[-5].minor);
  yy_destructor(yypParser,133,&yymsp[-2].minor);
}
#line 2599 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 531 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy0;
							 set->expr = yymsp[0].minor.yy70;
							 yygotominor.yy333 = g_slist_append (yymsp[-4].minor.yy333, set);
  yy_destructor(yypParser,123,&yymsp[-3].minor);
  yy_destructor(yypParser,79,&yymsp[-1].minor);
}
#line 2611 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 537 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy0;
					set->expr = yymsp[0].minor.yy70;
					yygotominor.yy333 = g_slist_append (NULL, set);
  yy_destructor(yypParser,79,&yymsp[-1].minor);
}
#line 2622 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 548 "./parser.y"
{
	yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy116, yymsp[0].minor.yy116);
}
#line 2630 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 552 "./parser.y"
{
	yygotominor.yy116 = compose_multiple_compounds (yymsp[-1].minor.yy276 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy116, yymsp[0].minor.yy116);
  yy_destructor(yypParser,114,&yymsp[-2].minor);
}
#line 2639 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 557 "./parser.y"
{
	yygotominor.yy116 = compose_multiple_compounds (yymsp[-1].minor.yy276 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy116, yymsp[0].minor.yy116);
  yy_destructor(yypParser,115,&yymsp[-2].minor);
}
#line 2648 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 562 "./parser.y"
{
	yygotominor.yy116 = compose_multiple_compounds (yymsp[-1].minor.yy276 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy116, yymsp[0].minor.yy116);
  yy_destructor(yypParser,116,&yymsp[-2].minor);
}
#line 2657 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 568 "./parser.y"
{yygotominor.yy276 = FALSE;}
#line 2662 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 569 "./parser.y"
{yygotominor.yy276 = TRUE;  yy_destructor(yypParser,134,&yymsp[0].minor);
}
#line 2668 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 576 "./parser.y"
{
	yygotominor.yy116 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy297) {
		gda_sql_statement_select_take_distinct (yygotominor.yy116, yymsp[-7].minor.yy297->distinct, yymsp[-7].minor.yy297->expr);
		g_free (yymsp[-7].minor.yy297);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy116, yymsp[-6].minor.yy325);
	gda_sql_statement_select_take_from (yygotominor.yy116, yymsp[-5].minor.yy191);
	gda_sql_statement_select_take_where_cond (yygotominor.yy116, yymsp[-4].minor.yy70);
	gda_sql_statement_select_take_group_by (yygotominor.yy116, yymsp[-3].minor.yy333);
	gda_sql_statement_select_take_having_cond (yygotominor.yy116, yymsp[-2].minor.yy70);
	gda_sql_statement_select_take_order_by (yygotominor.yy116, yymsp[-1].minor.yy325);
	gda_sql_statement_select_take_limits (yygotominor.yy116, yymsp[0].minor.yy44.count, yymsp[0].minor.yy44.offset);
  yy_destructor(yypParser,135,&yymsp[-8].minor);
}
#line 2687 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 593 "./parser.y"
{yygotominor.yy44.count = NULL; yygotominor.yy44.offset = NULL;}
#line 2692 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 594 "./parser.y"
{yygotominor.yy44.count = yymsp[0].minor.yy70; yygotominor.yy44.offset = NULL;  yy_destructor(yypParser,136,&yymsp[-1].minor);
}
#line 2698 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 595 "./parser.y"
{yygotominor.yy44.count = yymsp[-2].minor.yy70; yygotominor.yy44.offset = yymsp[0].minor.yy70;  yy_destructor(yypParser,136,&yymsp[-3].minor);
  yy_destructor(yypParser,33,&yymsp[-1].minor);
}
#line 2705 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 596 "./parser.y"
{yygotominor.yy44.count = yymsp[-2].minor.yy70; yygotominor.yy44.offset = yymsp[0].minor.yy70;  yy_destructor(yypParser,136,&yymsp[-3].minor);
  yy_destructor(yypParser,123,&yymsp[-1].minor);
}
#line 2712 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 600 "./parser.y"
{yygotominor.yy325 = 0;}
#line 2717 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 601 "./parser.y"
{yygotominor.yy325 = yymsp[0].minor.yy325;  yy_destructor(yypParser,137,&yymsp[-2].minor);
  yy_destructor(yypParser,138,&yymsp[-1].minor);
}
#line 2724 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 605 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy70;
							 order->asc = yymsp[0].minor.yy276;
							 yygotominor.yy325 = g_slist_append (yymsp[-3].minor.yy325, order);
  yy_destructor(yypParser,123,&yymsp[-2].minor);
}
#line 2735 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 611 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy70;
				       order->asc = yymsp[0].minor.yy276;
				       yygotominor.yy325 = g_slist_prepend (NULL, order);
}
#line 2745 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 619 "./parser.y"
{yygotominor.yy276 = TRUE;  yy_destructor(yypParser,5,&yymsp[0].minor);
}
#line 2751 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 620 "./parser.y"
{yygotominor.yy276 = FALSE;  yy_destructor(yypParser,14,&yymsp[0].minor);
}
#line 2757 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 621 "./parser.y"
{yygotominor.yy276 = TRUE;}
#line 2762 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 627 "./parser.y"
{yygotominor.yy70 = yymsp[0].minor.yy70;  yy_destructor(yypParser,139,&yymsp[-1].minor);
}
#line 2768 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 631 "./parser.y"
{yygotominor.yy333 = 0;}
#line 2773 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY rnexprlist */
#line 632 "./parser.y"
{yygotominor.yy333 = g_slist_reverse (yymsp[0].minor.yy325);  yy_destructor(yypParser,140,&yymsp[-2].minor);
  yy_destructor(yypParser,138,&yymsp[-1].minor);
}
#line 2780 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */ yytestcase(yyruleno==98);
#line 636 "./parser.y"
{yygotominor.yy191 = NULL;}
#line 2786 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 637 "./parser.y"
{yygotominor.yy191 = yymsp[0].minor.yy191;  yy_destructor(yypParser,130,&yymsp[-1].minor);
}
#line 2792 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 644 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy191)
		yygotominor.yy191 = yymsp[-3].minor.yy191;
	else 
		yygotominor.yy191 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy191, yymsp[-2].minor.yy134);
	last = g_slist_last (yygotominor.yy191->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy70;
		join->position = g_slist_length (yygotominor.yy191->targets) - 1;
		join->use = yymsp[0].minor.yy333;
	}
}
#line 2811 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 662 "./parser.y"
{yygotominor.yy333 = yymsp[-1].minor.yy333;  yy_destructor(yypParser,141,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 2819 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 666 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy191 = yymsp[-1].minor.yy191;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy191));
					      join->type = yymsp[0].minor.yy371;
					      gda_sql_select_from_take_new_join (yygotominor.yy191, join);
}
#line 2829 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 676 "./parser.y"
{yygotominor.yy70 = yymsp[0].minor.yy70;  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 2835 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 680 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,123,&yymsp[0].minor);
}
#line 2841 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 681 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2847 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 682 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(yypParser,113,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2854 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 683 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(yypParser,108,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2861 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 684 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(yypParser,109,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2868 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 685 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,110,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2875 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(yypParser,110,&yymsp[-2].minor);
  yy_destructor(yypParser,143,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2883 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 687 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,111,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2890 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(yypParser,111,&yymsp[-2].minor);
  yy_destructor(yypParser,143,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2898 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 689 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,112,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2905 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 690 "./parser.y"
{yygotominor.yy371 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(yypParser,112,&yymsp[-2].minor);
  yy_destructor(yypParser,143,&yymsp[-1].minor);
  yy_destructor(yypParser,107,&yymsp[0].minor);
}
#line 2913 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 695 "./parser.y"
{yygotominor.yy134 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy134, yymsp[0].minor.yy0);
				     gda_sql_select_target_take_table_name (yygotominor.yy134, yymsp[-1].minor.yy0);
}
#line 2921 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 699 "./parser.y"
{yygotominor.yy134 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy134, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy134, yymsp[-1].minor.yy0);
}
#line 2929 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 703 "./parser.y"
{yygotominor.yy134 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy134, yymsp[0].minor.yy0);
					     gda_sql_select_target_take_select (yygotominor.yy134, yymsp[-2].minor.yy116);
  yy_destructor(yypParser,105,&yymsp[-3].minor);
  yy_destructor(yypParser,106,&yymsp[-1].minor);
}
#line 2939 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 713 "./parser.y"
{yygotominor.yy325 = yymsp[-1].minor.yy325;  yy_destructor(yypParser,123,&yymsp[0].minor);
}
#line 2945 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* rexprlist ::= */ yytestcase(yyruleno==132);
#line 714 "./parser.y"
{yygotominor.yy325 = NULL;}
#line 2951 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 716 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy70);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy0); 
					  yygotominor.yy325 = g_slist_append (yymsp[-2].minor.yy325, field);}
#line 2960 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 721 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy0);
					yygotominor.yy325 = g_slist_append (yymsp[-1].minor.yy325, field);}
#line 2968 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
      case 196: /* fullname ::= nm DOT nm */ yytestcase(yyruleno==196);
#line 727 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,144,&yymsp[-1].minor);
}
#line 2982 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
      case 197: /* fullname ::= nm DOT nm DOT nm */ yytestcase(yyruleno==197);
#line 736 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy0), 
							 g_value_get_string (yymsp[-2].minor.yy0), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy0 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy0, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy0, str);
				  g_value_reset (yymsp[-4].minor.yy0); g_free (yymsp[-4].minor.yy0);
				  g_value_reset (yymsp[-2].minor.yy0); g_free (yymsp[-2].minor.yy0);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(yypParser,144,&yymsp[-3].minor);
  yy_destructor(yypParser,144,&yymsp[-1].minor);
}
#line 2999 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */ yytestcase(yyruleno==124);
#line 747 "./parser.y"
{yygotominor.yy0 = yymsp[0].minor.yy0;  yy_destructor(yypParser,145,&yymsp[-1].minor);
}
#line 3006 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 753 "./parser.y"
{yygotominor.yy297 = NULL;}
#line 3011 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 754 "./parser.y"
{yygotominor.yy297 = NULL;  yy_destructor(yypParser,134,&yymsp[0].minor);
}
#line 3017 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 755 "./parser.y"
{yygotominor.yy297 = g_new0 (Distinct, 1); yygotominor.yy297->distinct = TRUE;  yy_destructor(yypParser,146,&yymsp[0].minor);
}
#line 3023 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 756 "./parser.y"
{yygotominor.yy297 = g_new0 (Distinct, 1); yygotominor.yy297->distinct = TRUE; yygotominor.yy297->expr = yymsp[0].minor.yy70;  yy_destructor(yypParser,146,&yymsp[-2].minor);
  yy_destructor(yypParser,142,&yymsp[-1].minor);
}
#line 3030 "parser.c"
        break;
      case 130: /* rnexprlist ::= rnexprlist COMMA expr */
      case 133: /* rexprlist ::= rexprlist COMMA expr */ yytestcase(yyruleno==133);
#line 761 "./parser.y"
{yygotominor.yy325 = g_slist_prepend (yymsp[-2].minor.yy325, yymsp[0].minor.yy70);  yy_destructor(yypParser,123,&yymsp[-1].minor);
}
#line 3037 "parser.c"
        break;
      case 131: /* rnexprlist ::= expr */
      case 134: /* rexprlist ::= expr */ yytestcase(yyruleno==134);
#line 762 "./parser.y"
{yygotominor.yy325 = g_slist_append (NULL, yymsp[0].minor.yy70);}
#line 3043 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 774 "./parser.y"
{yygotominor.yy70 = yymsp[0].minor.yy70;}
#line 3048 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */ yytestcase(yyruleno==138);
#line 775 "./parser.y"
{yygotominor.yy70 = gda_sql_expr_new (NULL); yygotominor.yy70->value = yymsp[0].minor.yy0;}
#line 3054 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 776 "./parser.y"
{yygotominor.yy70 = yymsp[-1].minor.yy70;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3061 "parser.c"
        break;
      case 139: /* expr ::= fullname LP rexprlist RP */
#line 778 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy70 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy70)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    gda_sql_function_take_args_list (func, g_slist_reverse (yymsp[-1].minor.yy325));
					    yygotominor.yy70->func = func;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3073 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 784 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy70 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy70)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy116);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy70->func = func;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3088 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 793 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy70 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy70));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy0);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy0;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy70->func = func;  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3103 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 802 "./parser.y"
{yygotominor.yy70 = yymsp[-3].minor.yy70;
						yymsp[-3].minor.yy70->cast_as = g_value_dup_string (yymsp[-1].minor.yy0);
						g_value_reset (yymsp[-1].minor.yy0);
						g_free (yymsp[-1].minor.yy0);  yy_destructor(yypParser,10,&yymsp[-5].minor);
  yy_destructor(yypParser,105,&yymsp[-4].minor);
  yy_destructor(yypParser,145,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3115 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 806 "./parser.y"
{yygotominor.yy70 = yymsp[-2].minor.yy70;
					 yymsp[-2].minor.yy70->cast_as = g_value_dup_string (yymsp[0].minor.yy0);
					 g_value_reset (yymsp[0].minor.yy0);
					 g_free (yymsp[0].minor.yy0);  yy_destructor(yypParser,117,&yymsp[-1].minor);
}
#line 3124 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 811 "./parser.y"
{yygotominor.yy70 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy70, yymsp[0].minor.yy70);}
#line 3129 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 812 "./parser.y"
{yygotominor.yy70 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,97,&yymsp[-1].minor);
}
#line 3135 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */ yytestcase(yyruleno==147);
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */ yytestcase(yyruleno==153);
      case 154: /* expr ::= expr DIFF|EQ expr */ yytestcase(yyruleno==154);
      case 159: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */ yytestcase(yyruleno==159);
#line 813 "./parser.y"
{yygotominor.yy70 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy70, yymsp[0].minor.yy70);}
#line 3144 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 816 "./parser.y"
{yygotominor.yy70 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy70);  yy_destructor(yypParser,96,&yymsp[-1].minor);
}
#line 3150 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 817 "./parser.y"
{yygotominor.yy70 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy70);  yy_destructor(yypParser,95,&yymsp[-1].minor);
}
#line 3156 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 819 "./parser.y"
{yygotominor.yy70 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3162 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 820 "./parser.y"
{yygotominor.yy70 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,69,&yymsp[-1].minor);
}
#line 3168 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 821 "./parser.y"
{yygotominor.yy70 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,100,&yymsp[-1].minor);
}
#line 3174 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 825 "./parser.y"
{yygotominor.yy70 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,26,&yymsp[-1].minor);
}
#line 3180 "parser.c"
        break;
      case 156: /* expr ::= expr ILIKE expr */
#line 826 "./parser.y"
{yygotominor.yy70 = create_two_expr (GDA_SQL_OPERATOR_TYPE_ILIKE, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,27,&yymsp[-1].minor);
}
#line 3186 "parser.c"
        break;
      case 157: /* expr ::= expr NOTLIKE expr */
#line 827 "./parser.y"
{yygotominor.yy70 = create_two_expr (GDA_SQL_OPERATOR_TYPE_NOTLIKE, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,73,&yymsp[-1].minor);
}
#line 3192 "parser.c"
        break;
      case 158: /* expr ::= expr NOTILIKE expr */
#line 828 "./parser.y"
{yygotominor.yy70 = create_two_expr (GDA_SQL_OPERATOR_TYPE_NOTILIKE, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,74,&yymsp[-1].minor);
}
#line 3198 "parser.c"
        break;
      case 160: /* expr ::= expr BETWEEN expr AND expr */
#line 830 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy70 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
						  yygotominor.yy70->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy70);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy70);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy70);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,80,&yymsp[-3].minor);
  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3216 "parser.c"
        break;
      case 161: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 843 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy70);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy70);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy70);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy70 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
						      yygotominor.yy70->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,80,&yymsp[-3].minor);
  yy_destructor(yypParser,70,&yymsp[-1].minor);
}
#line 3243 "parser.c"
        break;
      case 162: /* expr ::= NOT expr */
#line 864 "./parser.y"
{yygotominor.yy70 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy70);  yy_destructor(yypParser,71,&yymsp[-1].minor);
}
#line 3249 "parser.c"
        break;
      case 163: /* expr ::= BITNOT expr */
#line 865 "./parser.y"
{yygotominor.yy70 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy70);  yy_destructor(yypParser,104,&yymsp[-1].minor);
}
#line 3255 "parser.c"
        break;
      case 164: /* expr ::= expr uni_op */
#line 866 "./parser.y"
{yygotominor.yy70 = create_uni_expr (yymsp[0].minor.yy147, yymsp[-1].minor.yy70);}
#line 3260 "parser.c"
        break;
      case 165: /* expr ::= expr IS expr */
#line 868 "./parser.y"
{yygotominor.yy70 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy70, yymsp[0].minor.yy70);  yy_destructor(yypParser,72,&yymsp[-1].minor);
}
#line 3266 "parser.c"
        break;
      case 166: /* expr ::= LP compound RP */
#line 869 "./parser.y"
{yygotominor.yy70 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy70, yymsp[-1].minor.yy116);  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3273 "parser.c"
        break;
      case 167: /* expr ::= expr IN LP rexprlist RP */
#line 870 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy70 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
					   yygotominor.yy70->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (g_slist_reverse (yymsp[-1].minor.yy325), yymsp[-4].minor.yy70);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3290 "parser.c"
        break;
      case 168: /* expr ::= expr IN LP compound RP */
#line 880 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy70 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
					    yygotominor.yy70->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy116);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy70);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3310 "parser.c"
        break;
      case 169: /* expr ::= expr NOT IN LP rexprlist RP */
#line 893 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy70 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
					       yygotominor.yy70->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (g_slist_reverse (yymsp[-1].minor.yy325), yymsp[-5].minor.yy70);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3328 "parser.c"
        break;
      case 170: /* expr ::= expr NOT IN LP compound RP */
#line 903 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy70 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy70));
					       yygotominor.yy70->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy116);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy70);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy70)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(yypParser,71,&yymsp[-4].minor);
  yy_destructor(yypParser,75,&yymsp[-3].minor);
  yy_destructor(yypParser,105,&yymsp[-2].minor);
  yy_destructor(yypParser,106,&yymsp[0].minor);
}
#line 3349 "parser.c"
        break;
      case 171: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 916 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy70 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy70));
	sc->base_expr = yymsp[-3].minor.yy146;
	sc->else_expr = yymsp[-1].minor.yy146;
	sc->when_expr_list = yymsp[-2].minor.yy59.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy59.then_list;
	yygotominor.yy70->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(yypParser,147,&yymsp[-4].minor);
  yy_destructor(yypParser,17,&yymsp[0].minor);
}
#line 3370 "parser.c"
        break;
      case 172: /* case_operand ::= expr */
#line 934 "./parser.y"
{yygotominor.yy146 = yymsp[0].minor.yy70;}
#line 3375 "parser.c"
        break;
      case 173: /* case_operand ::= */
      case 177: /* case_else ::= */ yytestcase(yyruleno==177);
#line 935 "./parser.y"
{yygotominor.yy146 = NULL;}
#line 3381 "parser.c"
        break;
      case 174: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 941 "./parser.y"
{
	yygotominor.yy59.when_list = g_slist_append (yymsp[-4].minor.yy59.when_list, yymsp[-2].minor.yy70);
	yygotominor.yy59.then_list = g_slist_append (yymsp[-4].minor.yy59.then_list, yymsp[0].minor.yy70);
  yy_destructor(yypParser,148,&yymsp[-3].minor);
  yy_destructor(yypParser,149,&yymsp[-1].minor);
}
#line 3391 "parser.c"
        break;
      case 175: /* case_exprlist ::= WHEN expr THEN expr */
#line 945 "./parser.y"
{
	yygotominor.yy59.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy70);
	yygotominor.yy59.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy70);
  yy_destructor(yypParser,148,&yymsp[-3].minor);
  yy_destructor(yypParser,149,&yymsp[-1].minor);
}
#line 3401 "parser.c"
        break;
      case 176: /* case_else ::= ELSE expr */
#line 952 "./parser.y"
{yygotominor.yy146 = yymsp[0].minor.yy70;  yy_destructor(yypParser,150,&yymsp[-1].minor);
}
#line 3407 "parser.c"
        break;
      case 178: /* uni_op ::= ISNULL */
#line 956 "./parser.y"
{yygotominor.yy147 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(yypParser,76,&yymsp[0].minor);
}
#line 3413 "parser.c"
        break;
      case 179: /* uni_op ::= IS NOTNULL */
#line 957 "./parser.y"
{yygotominor.yy147 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(yypParser,72,&yymsp[-1].minor);
  yy_destructor(yypParser,77,&yymsp[0].minor);
}
#line 3420 "parser.c"
        break;
      case 180: /* value ::= NULL */
#line 961 "./parser.y"
{yygotominor.yy0 = NULL;  yy_destructor(yypParser,151,&yymsp[0].minor);
}
#line 3426 "parser.c"
        break;
      case 184: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 970 "./parser.y"
{yygotominor.yy70 = gda_sql_expr_new (NULL); yygotominor.yy70->param_spec = yymsp[-1].minor.yy339;  yy_destructor(yypParser,153,&yymsp[-3].minor);
  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,155,&yymsp[0].minor);
}
#line 3434 "parser.c"
        break;
      case 185: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 971 "./parser.y"
{yygotominor.yy70 = gda_sql_expr_new (NULL); yygotominor.yy70->value = yymsp[-3].minor.yy0; yygotominor.yy70->param_spec = yymsp[-1].minor.yy339;  yy_destructor(yypParser,154,&yymsp[-2].minor);
  yy_destructor(yypParser,155,&yymsp[0].minor);
}
#line 3441 "parser.c"
        break;
      case 186: /* pvalue ::= SIMPLEPARAM */
#line 972 "./parser.y"
{yygotominor.yy70 = gda_sql_expr_new (NULL); yygotominor.yy70->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3446 "parser.c"
        break;
      case 187: /* paramspec ::= */
#line 977 "./parser.y"
{yygotominor.yy339 = NULL;}
#line 3451 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PNAME */
#line 978 "./parser.y"
{if (!yymsp[-1].minor.yy339) yygotominor.yy339 = gda_sql_param_spec_new (NULL); else yygotominor.yy339 = yymsp[-1].minor.yy339; 
					 gda_sql_param_spec_take_name (yygotominor.yy339, yymsp[0].minor.yy0);}
#line 3457 "parser.c"
        break;
      case 189: /* paramspec ::= paramspec PDESCR */
#line 980 "./parser.y"
{if (!yymsp[-1].minor.yy339) yygotominor.yy339 = gda_sql_param_spec_new (NULL); else yygotominor.yy339 = yymsp[-1].minor.yy339; 
					 gda_sql_param_spec_take_descr (yygotominor.yy339, yymsp[0].minor.yy0);}
#line 3463 "parser.c"
        break;
      case 190: /* paramspec ::= paramspec PTYPE */
#line 982 "./parser.y"
{if (!yymsp[-1].minor.yy339) yygotominor.yy339 = gda_sql_param_spec_new (NULL); else yygotominor.yy339 = yymsp[-1].minor.yy339; 
					 gda_sql_param_spec_take_type (yygotominor.yy339, yymsp[0].minor.yy0);}
#line 3469 "parser.c"
        break;
      case 191: /* paramspec ::= paramspec PNULLOK */
#line 984 "./parser.y"
{if (!yymsp[-1].minor.yy339) yygotominor.yy339 = gda_sql_param_spec_new (NULL); else yygotominor.yy339 = yymsp[-1].minor.yy339; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy339, yymsp[0].minor.yy0);}
#line 3475 "parser.c"
        break;
      default:
      /* (34) trans_opt_kw ::= */ yytestcase(yyruleno==34);
      /* (36) opt_comma ::= */ yytestcase(yyruleno==36);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  priv_gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  priv_gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  priv_gda_sql_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3542 "parser.c"
  priv_gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  priv_gda_sql_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  priv_gda_sql_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "priv_gda_sql_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void priv_gda_sql_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  priv_gda_sql_parserTOKENTYPE yyminor       /* The value for the token */
  priv_gda_sql_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  priv_gda_sql_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
