/*****************************************************************************
 * command.h: common definitions
 *****************************************************************************
 * Copyright (C) 2002 VideoLAN
 * $Id: command.h,v 1.4 2003/01/29 20:55:26 sam Exp $
 *
 * Authors: Stephane Borel <stef@via.ecp.fr>
 *
 * Adapted from Ogle - A video player
 * Copyright (C) 2000, 2001 Martin Norbck, Hkan Hjort
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/


typedef enum
{
  LinkNoLink  = 0,

  LinkTopC    = 1,
  LinkNextC   = 2,
  LinkPrevC   = 3,

  LinkTopPG   = 5,
  LinkNextPG  = 6,
  LinkPrevPG  = 7,

  LinkTopPGC  = 9,
  LinkNextPGC = 10,
  LinkPrevPGC = 11,
  LinkGoUpPGC = 12,
  LinkTailPGC = 13,

  LinkRSM     = 16,

  LinkPGCN,
  LinkPTTN,
  LinkPGN,
  LinkCN,

  Exit,

  JumpTT, /* 22 */
  JumpVTS_TT,
  JumpVTS_PTT,

  JumpSS_FP,
  JumpSS_VMGM_MENU,
  JumpSS_VTSM,
  JumpSS_VMGM_PGC,

  CallSS_FP, /* 29 */
  CallSS_VMGM_MENU,
  CallSS_VTSM,
  CallSS_VMGM_PGC,

  PlayThis
} link_cmd_t;

typedef struct link_s
{
  link_cmd_t    command;
  uint16_t      data1;
  uint16_t      data2;
  uint16_t      data3;
} link_t;

/* struct to evaluate command */
typedef struct cmd_s
{
  uint8_t pi_bits[8];
  uint8_t pi_examined[8];
} cmd_t;


typedef struct registers_s
{
  uint16_t SPRM[24];
  uint16_t GPRM[16];
  /* Need to have some thing to indicate normal/counter mode for every GPRM */
  /* int GPRM_mode[16]; */
} registers_t;

int  _dvdplay_CommandTable( dvdplay_ptr, vm_cmd_t*, int );

void vmPrint_LINK(link_t value);
void vmPrint_mnemonic(vm_cmd_t *command);
void vmPrint_CMD(int row, vm_cmd_t *command);

