# Configure paths for COVEB
# Raph Levien 98-11-18
# stolen from Manish Singh    98-9-30
# stolen back from Frank Belew
# stolen from Manish Singh
# Shamelessly stolen from Owen Taylor

dnl AM_PATH_COVEB([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl Test for COVEB, and define COVEB_CFLAGS and COVEB_LIBS
dnl
AC_DEFUN([AM_PATH_COVEB],
[dnl 
dnl Get the cflags and libraries from the coveb-config script
dnl
AC_ARG_WITH(coveb-prefix,[  --with-coveb-prefix=PFX   Prefix where COVEB is installed (optional)],
            coveb_prefix="$withval", coveb_prefix="")
AC_ARG_WITH(coveb-exec-prefix,[  --with-coveb-exec-prefix=PFX Exec prefix where COVEB is installed (optional)],
            coveb_exec_prefix="$withval", coveb_exec_prefix="")
AC_ARG_ENABLE(covebtest, [  --disable-covebtest       Do not try to compile and run a test COVEB program],
		    , enable_covebtest=yes)

  if test x$coveb_exec_prefix != x ; then
     coveb_args="$coveb_args --exec-prefix"
     if test x${COVEB_CONFIG+set} != xset ; then
        COVEB_CONFIG=$coveb_exec_prefix/bin/coveb-config
     fi
  fi
  if test x$coveb_prefix != x ; then
     coveb_args="$coveb_args --prefix"
     if test x${COVEB_CONFIG+set} != xset ; then
        COVEB_CONFIG=$coveb_prefix/bin/coveb-config
     fi
  fi

  AC_PATH_PROG(COVEB_CONFIG, coveb-config, no)
  min_coveb_version=ifelse([$1], ,0.2.5,$1)
  AC_MSG_CHECKING(for COVEB - version >= $min_coveb_version)
  no_coveb=""
  if test "$COVEB_CONFIG" = "no" ; then
    no_coveb=yes
  else
    COVEB_CFLAGS=`$COVEB_CONFIG $covebconf_args --cflags`
    COVEB_LIBS=`$COVEB_CONFIG $covebconf_args --libs`

    coveb_major_version=`$COVEB_CONFIG $coveb_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    coveb_minor_version=`$COVEB_CONFIG $coveb_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    coveb_micro_version=`$COVEB_CONFIG $coveb_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_covebtest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
dnl      CFLAGS="$CFLAGS $COVEB_CFLAGS"
dnl      LIBS="$LIBS $COVEB_LIBS"
dnl
dnl Now check if the installed COVEB is sufficiently new. (Also sanity
dnl checks the results of coveb-config to some extent
dnl
      rm -f conf.covebtest
      AC_TRY_RUN([
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char*
my_strdup (char *str)
{
  char *new_str;
  
  if (str)
    {
      new_str = malloc ((strlen (str) + 1) * sizeof(char));
      strcpy (new_str, str);
    }
  else
    new_str = NULL;
  
  return new_str;
}

int main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.covebtest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_coveb_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_coveb_version");
     exit(1);
   }

   if (($coveb_major_version > major) ||
      (($coveb_major_version == major) && ($coveb_minor_version > minor)) ||
      (($coveb_major_version == major) && ($coveb_minor_version == minor) && ($coveb_micro_version >= micro)))
    {
      return 0;
    }
  else
    {
      printf("\n*** 'coveb-config --version' returned %d.%d.%d, but the minimum version\n", $coveb_major_version, $coveb_minor_version, $coveb_micro_version);
      printf("*** of COVEB required is %d.%d.%d. If coveb-config is correct, then it is\n", major, minor, micro);
      printf("*** best to upgrade to the required version.\n");
      printf("*** If coveb-config was wrong, set the environment variable COVEB_CONFIG\n");
      printf("*** to point to the correct copy of coveb-config, and remove the file\n");
      printf("*** config.cache before re-running configure\n");
      return 1;
    }
}

],, no_coveb=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_coveb" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$COVEB_CONFIG" = "no" ; then
       echo "*** The coveb-config script installed by COVEB could not be found"
       echo "*** If COVEB was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the COVEB_CONFIG environment variable to the"
       echo "*** full path to coveb-config."
     else
       if test -f conf.covebtest ; then
        :
       else
          echo "*** Could not run COVEB test program, checking why..."
          CFLAGS="$CFLAGS $COVEB_CFLAGS"
          LIBS="$LIBS $COVEB_LIBS"
          AC_TRY_LINK([
#include <stdio.h>
#include <coveb/coveb.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding COVEB or finding the wrong"
          echo "*** version of COVEB. If it is not finding COVEB, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means COVEB was incorrectly installed"
          echo "*** or that you have moved COVEB since it was installed. In the latter case, you"
          echo "*** may want to edit the coveb-config script: $COVEB_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     COVEB_CFLAGS=""
     COVEB_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(COVEB_CFLAGS)
  AC_SUBST(COVEB_LIBS)
  rm -f conf.covebtest
])
