/*
 * $Id: input.c,v 1.9 2000/10/02 18:17:40 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  services.c  --  All the services the LysKOM server makes available
 *		    for clients.
 *
 *  Created by ceder 1990-07-17
 */

#include <config.h>
#include <kom-types.h>
#include <services.h>
#include <kom-errno.h>
#include "parse.h"
#include "client.h"
#include "async.h"
#include "input.h"

unsigned long 	err_stat = 0;

/* 
 * This parses the beginning of the answer from the server.
 * In most cases this is all that is needed since the `header'
 * contains information about wether the command has succeded
 * or has failed.
 *
 * Further parseing of the server output is only possible if this
 * returns OK.
 */

extern Success
input_header(void)
{
    int c;

    skipwhite(KS->in);
    
    while ( (c=my_getc(KS->in)) == ':' )
    {
	if ( async(KS->in) != OK )
	    return FAILURE;
	
	skipwhite(KS->in);
    }
    
    switch(c)
    {
    case '=':
	{
	    unsigned long refno;

	    refno = parse_long(KS->in);
	    if (refno != 0) { /* Check the ref-no */
#ifdef DEBUG
		fprintf(stderr, "Incorrect ref-no: %ld\n", refno);
#endif
		kom_errno = KOM_SERVER_IS_CRAZY;
		return FAILURE;
	    }
	    kom_errno = KOM_NO_ERROR;
	    return OK;
	}
    case '%':
	if ((c=my_getc(KS->in)) == '%' /* Checking for '%%' */
	    || c == ' ')	/* Checking for '% ' is this possible... */
	{
	    /* The server is sending '%% LysKOM protocol error.' */
	    /* or '% LysKOM protocol error.' */
	    /* BUG: Since the line is not discarded it is harder
	     *      than it ought to be to recover from this error. */
	    kom_errno = KOM_CLIENT_IS_CRAZY;
	    /* Try to fix it by reading to the end of the line. */
	    while (my_getc(KS->in) != '\n');
	    return FAILURE;
	}
	my_ungetc(c, KS->in);
	(void)parse_long(KS->in); /* Reading ref_no */
	kom_errno = (Kom_err)parse_long(KS->in);
	err_stat = parse_long(KS->in);
	return FAILURE;
	
    default:
	kom_errno = KOM_SERVER_IS_CRAZY;
#ifdef DEBUG
	fprintf(stderr, "KOM_SERVER_IS_CRAZY: %c %d\n", c, c);
	fprintf(stderr,">");
	while ((c=my_getc(KS->in)) != '\n')
	    fprintf(stderr,"%c",c);
	fprintf(stderr,"<\n");
#endif
	return FAILURE;
    }
}

	

extern  Pers_no
input_create_person (void)
{
    if ( input_header() != OK )
	return 0;

    return parse_long(KS->in);
}


extern  Success
input_get_person_stat (Person        * result )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_person(KS->in, result);
}

extern  Success
input_get_created_texts(Text_list   * result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_text_list(KS->in, result);
}


extern  Success
input_get_membership(Membership_list  * memberships)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_membership_list(KS->in, memberships);
}


extern  Success
input_query_read_texts ( Membership * result   )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_membership(KS->in, result );
}


extern  Conf_no
input_create_conf (void)
{
    if ( input_header() != OK )
	return 0;

    return parse_long(KS->in);
}




extern  Success
input_get_conf_stat (Conference     * result )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_conference(KS->in, result );
}

extern  Success
input_get_members (Member_list	* members)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_member_list(KS->in, members);
}


extern  Success
input_get_marks (Mark_list *result )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_mark_list(KS->in, result);
}



extern  Success
input_get_text (String  *result)
{
    if ( input_header() != OK )
	return FAILURE;
    
    return parse_string(KS->in, result);
}



extern  Success
input_get_text_stat (Text_stat *result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_text_stat(KS->in, result);
}



extern  Text_no
input_create_text (void)
{
    if ( input_header() != OK )
	return 0;

    return parse_long(KS->in);
}


extern  Text_no
input_create_anonymous_text (void)
{
    if ( input_header() != OK )
	return 0;

    return parse_long(KS->in);
}

extern  Success
input_get_map (Text_list  * result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_text_list(KS->in, result);
}



extern  Success
input_get_time ( struct tm *time_res )
{
    if ( input_header() != OK || parse_time(KS->in, time_res) != OK )
	return FAILURE;

    return OK;
}


extern  Success
input_get_info (Info *result )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_info(KS->in, result);
}


extern  Success
input_get_unread_confs (Conf_no_list *result )
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_conf_no_list (KS->in, result);
}


static  Success
intern_input_get_exactly_one_textno(Text_no *result)
{
    if ( input_header() != OK )
	return FAILURE;
    * result = parse_long(KS->in);
    return OK;
}


extern  Success
input_get_last_text (Text_no *result)
{
    return intern_input_get_exactly_one_textno(result);
}

extern  Success
input_get_next_text_no (Text_no *result)
{
    return intern_input_get_exactly_one_textno(result);
}

extern  Success
input_get_previous_text_no (Text_no *result)
{
    return intern_input_get_exactly_one_textno(result);
}

extern  Success
input_lookup_z_name(Conf_z_info_list * result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_conf_z_info_list (KS->in, result);
}

extern  Success
input_re_z_lookup(Conf_z_info_list * result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_conf_z_info_list (KS->in, result);
}

extern  Success
input_who_is_on_dynamic(Dynamic_session_info_list * result)
{
    if ( input_header() != OK )
	return FAILURE;

    return parse_dynamic_session_info_list(KS->in, result);
}

