//==============================================================================
//  Lynkeos 
//  $Id: MyImageListEnumerator.h,v 1.6 2005/01/27 23:06:34 j-etienne Exp $
//  Created by Jean-Etienne LAMIAUD on Tue Jul 27 2004.
//------------------------------------------------------------------------------
//  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
//------------------------------------------------------------------------------
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------

#ifndef __MYIMAGELISTENUM_H
#define __MYIMAGELISTENUM_H

#ifdef GNUSTEP
#else
#import <Cocoa/Cocoa.h>
#endif

#include "MyImageListItem.h"

/*!
 * @class MyImageListEnumerator
 * @abstract Enumerator on MyImageList
 * @discussion This enumerator scans all the MyImageListItem images in a 
 *    MyImageList. When the list contains a movie, it scans each MyMovieImage 
 *    inside the MyMovie instance.
 * @ingroup Models
 */
@interface MyImageListEnumerator : NSEnumerator
{
    NSArray*         _itemList;
    int              _listSize;
    int              _itemIndex;
    MyMovie*         _currentMovie;
    int              _movieSize;
    int              _movieIndex;
    int              _step;
    NSRecursiveLock  *_lock;
}

/*!
 * @method initWithImageList:startAt:directSense:
 * @abstract Base initializer
 * @param list The MyImageListItem array do scan
 * @param item The item to start with. If nil, the first or last (if reverse 
 *    enumerator) is taken
 * @param direct Direct or reverse enumerator
 * @discussion It initializes a MyImageListEnumerator whith a custom starting
 *    point and a custom scanning direction.
 */
- (id) initWithImageList :(NSArray*)list startAt:(id)item 
              directSense:(BOOL)direct;
/*!
 * @method initWithImageList:
 * @abstract Simplified initializer
 * @param list The MyImageListItem array do scan
 * @discussion It initializes a direct enumerator starting at the first item of
 *    the list.
 */
- (id) initWithImageList :(NSArray*)list ;

@end

#endif
