/*
 */

#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>

#include <netinet/in.h>

#include <vector>
#include <string>

#include <lufs/proto.h>
#include <lufs/fs.h>

using namespace std;

#include "file_handle.h"
#include "fs_modules.h"
#include "handlefs.h"

extern "C"{

/********************************************************************************
				C Wrappers
********************************************************************************/
	
void* wavfs_init(struct list_head *cfg, struct dir_cache *cache, struct credentials *cred, void **global_ctx)
{
/*    if(!lu_opt_getchar(cfg, "MOUNT", "username") || !lu_opt_getchar(cfg, "MOUNT", "host")){
	ERROR("you must specify at least a host and an username!");
	return NULL;
    }
 */  
    return (void*)new HandleFS(cfg, cache, cred);
}

void wavfs_free(void *ctx)
{
    HandleFS *p = (HandleFS*)ctx;
    delete p;
}

int wavfs_mount(void *ctx)
{
    return ((HandleFS*)ctx)->do_mount();
}

void wavfs_umount(void *ctx)
{
	((HandleFS*)ctx)->do_umount();
}

int wavfs_readdir(void *ctx, char *dir_name, struct directory *dir)
{
    return ((HandleFS*)ctx)->do_readdir(dir_name, dir);
}

int wavfs_stat(void *ctx, char *name, struct lufs_fattr *fattr)
{
    return ((HandleFS*)ctx)->do_stat(name, fattr);
}

int wavfs_open(void *ctx, char *file, unsigned mode)
{
    return ((HandleFS*)ctx)->do_open(file);
}

int wavfs_release(void *ctx, char *file)
{
    return ((HandleFS*)ctx)->do_release(file);
}

int wavfs_read(void *ctx, char *file, long long offset, unsigned long count, char *buf)
{
    return ((HandleFS*)ctx)->do_read(file, offset, count, buf);
}

/********************************************************************************
				Default OS Implementation
********************************************************************************/

int wavfs_readlink(void *ctx, char *link, char *buf, int buflen)
{
    return readlink(link, buf, buflen);
}

/********************************************************************************
				Write operations are not implemented
********************************************************************************/

int read_only_error()
{
	ERROR("This filesystem is read-only.");
	return -1;
}

int wavfs_mkdir(void *ctx, char *dir, int mode)	{ return read_only_error(); }
int wavfs_rmdir(void *ctx, char *dir)	{ return read_only_error(); }
int wavfs_create(void *ctx, char *file, int mode)	{ return read_only_error(); }
int wavfs_unlink(void *ctx, char *file)	{ return read_only_error(); }
int wavfs_rename(void *ctx, char *old_name, char *new_name)	{ return read_only_error(); }
int wavfs_write(void *ctx, char *file, long long offset, unsigned long count, char *buf) 	{ return read_only_error(); }
int wavfs_link(void *ctx, char *target, char *link)	{ return read_only_error(); }
int wavfs_symlink(void *ctx, char *target, char *link)	{ return read_only_error(); }
int wavfs_setattr(void *ctx, char *file, struct lufs_fattr *fattr)	{ return read_only_error(); }

} /* extern "C" */
