#ifndef _GNET_H_
#define _GNET_H_

struct gnet;

struct gnet_config {
    int			shared_files;
    int			shared_kb;
    unsigned short	listen_port;
    unsigned short	query_ttl;
    unsigned		query_wait;
    unsigned		min_speed;
    unsigned		min_hosts;
    unsigned		max_hosts;
    unsigned		keep_peers;
    unsigned		keep_connecting;
    unsigned		connect_to;
    unsigned		rw_to;
    unsigned		check_to;    
};


struct gnet_xfer;
struct gnet_locator {
    char		*name;
    char		ip[4];
    char		guid[16];
    unsigned short 	port;
    unsigned long	index;
    unsigned long	size;
    unsigned long	bwidth;
    struct list_head	list;
    struct gnet_xfer	*xfer;
    int 		firewalled;
};

struct gnet *gnet_init(struct gnet_config*);
void gnet_shutdown(struct gnet*);
void gnet_set_defaults(struct gnet_config*);
void gnet_stop_search(struct gnet*, unsigned long);
void gnet_xfer_shutdown(struct gnet_locator*);
int gnet_start_search(struct gnet*, char*, void(*)(void*, struct gnet_locator*, unsigned long), void*, unsigned, unsigned long*);
int gnet_add_peer(struct gnet*, char*, unsigned short);
int gnet_xfer_read(struct gnet*, struct gnet_locator*, unsigned long, unsigned long, char*);

#endif
