/******************************************************************************/
/*                                                                            */
/* Copyright (c) 2009 FUJITSU LIMITED                                         */
/*                                                                            */
/* This program is free software;  you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by       */
/* the Free Software Foundation; either version 2 of the License, or          */
/* (at your option) any later version.                                        */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY;  without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See                  */
/* the GNU General Public License for more details.                           */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program;  if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA    */
/*                                                                            */
/* Author: Miao Xie <miaox@cn.fujitsu.com>                                    */
/*                                                                            */
/******************************************************************************/

#include <libgen.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/mman.h>

int unit = 1024 * 1024;

//argv[1] memory use(M) (>0)

int
main(int argc, char *argv[])
{
	long int use;
	if (argc != 2) {
		fprintf(stderr, "usage: %s mmap-size-in-kB\n", basename(argv[0]));
		exit(1);
	}
	if ((use = strtol(argv[1], NULL, 10)) < 0) {
		fprintf(stderr, "Invalid mmap size specified (must be a long "
				"int greater than 1)\n");
		exit(1);
	}

	long int pagesize = getpagesize();
	long int mmap_block = use * unit / 10 / pagesize;
	long int total_block = 0;

	while (pagesize * mmap_block > 2 * unit) {
		unsigned long *addr = mmap(NULL, pagesize * mmap_block, 
			PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
		if (addr == MAP_FAILED) {
			mmap_block = mmap_block / 2;
			continue;
		}
		memset(addr, 0xF7, pagesize * mmap_block);
		total_block += mmap_block;
		if (total_block * pagesize >= use * unit)
			break;
	}
	return 0;
}
