/*
 * dstore.c - Linux global storage for /dev/kmem-based lslk
 *
 * V. Abell
 * Purdue University Computing Center
 *
 * Chris Eleveld <chris@sector7.com>
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.4 99/11/10 15:02:10 abe Exp $";
#endif

#include "lslk.h"


/*
 * Local global variables
 */

int Kd = -1;				/* kernel memory file descriptor */
struct nlist Nl[] = {			/* NB: COFF form used. ELF form
					 * symbols have no leading `_'. */

#if	LINUXV>=1300
	{ "_file_lock_table",		0, 0 },
#else	/* LINUXV<1300 */
	{ "_first_file",		0, 0 },
#endif	/* LINUXV>=1300 */
	{ NULL,				0, 0 }
};
	


#include "lslk.h"
