# Copyright (C) 2009-2010 LottaNZB Development Team
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

from lottanzb.plugins import PluginBase
from lottanzb.util import _

class Plugin(PluginBase):
    title = _("Start minimized")
    description = _("Only display the notification area icon when starting.")
    author = _("LottaNZB Development Team")
    requires = ["panel_menu"]
    
    def __init__(self, app, config):
        PluginBase.__init__(self, app, config)
        
        # Prevent the main window from being displayed if the plug-in is 
        # enabled.
        if self.enabled:
            self.app.silent_start = True
